# massive-com

OpenClaw-oriented Bash CLI and public skill for Massive's documented REST API.

This repo is intentionally thin: it provides a generic, extensible shell wrapper for Massive endpoints, OpenClaw-compatible secret resolution, and safe logging defaults for agent workflows.

## What It Includes

- `scripts/massive`: Bash CLI for generic REST requests and pagination
- `SKILL.md`: skill instructions for Codex/OpenClaw-style agents
- `agents/openai.yaml`: Clawhub/OpenAI skill metadata
- `BUNDLE_MANIFEST.md`: required files for packaged skill artifacts
- `references/`: API, secrets, and security guidance
- `tests/test_massive.sh`: local smoke tests with mocked `curl`

## Install

### GitHub checkout

Clone the repo and run the CLI directly:

```bash
git clone https://github.com/oscraters/massive-com.git
cd massive-com
chmod +x scripts/massive
```

### Clawhub / OpenClaw usage

This repo is structured as a public skill bundle:

- `SKILL.md` contains the agent instructions
- `agents/openai.yaml` contains the UI/invocation metadata
- `scripts/massive` is the executable wrapper

For Clawhub distribution, publish the repo as-is and point consumers at the repository root. Do not add local-only setup files, captured payloads, or personal environment artifacts.
If a published artifact omits any file listed in `BUNDLE_MANIFEST.md`, treat it as a packaging error and regenerate the bundle.

Required runtime tools:

- `bash`
- `curl`
- `jq`

Recommended development tools:

- `shellcheck`
- `shfmt`

## Authentication

Preferred:

```bash
export MASSIVE_API_KEY_REF='{"source":"env","name":"OPENCLAW_MASSIVE_API_KEY"}'
export OPENCLAW_MASSIVE_API_KEY='your-api-key'
```

Fallback:

```bash
export MASSIVE_API_KEY='your-api-key'
```

The CLI does not maintain a local credential store. It resolves OpenClaw-style secret refs first, then falls back to `MASSIVE_API_KEY`.
The published skill metadata declares `MASSIVE_API_KEY_REF` as the preferred credential input and `MASSIVE_API_KEY` as the local fallback.

For OpenClaw agents, prefer `MASSIVE_API_KEY_REF` so the runtime remains responsible for secret delivery and rotation.

## Usage

Health check:

```bash
scripts/massive health
```

Generic request:

```bash
scripts/massive get /v3/reference/tickers/AAPL
```

Generic request with query params:

```bash
scripts/massive get /v3/reference/tickers --query ticker=AAPL --query active=true
```

Follow pagination:

```bash
scripts/massive get "/v3/reference/tickers?limit=10" > page-1.json
scripts/massive next < page-1.json
```

Safe request preview:

```bash
scripts/massive --dry-run get /v3/reference/tickers/AAPL
```

## Design Constraints

- Keep the wrapper generic and extensible.
- Prefer documented Massive paths over heavy wrapper abstractions.
- Default to `https://api.massive.com` and reject absolute URLs from other origins unless `MASSIVE_BASE_URL` is explicitly overridden.
- Keep the repo Clawhub-safe and redistribution-safe.
- Keep `stdout` machine-readable and `stderr` diagnostic-only.
- Never print secrets or auth headers in logs.
- Avoid storing local artifacts or private payloads in the repo.

## Development

Run smoke tests:

```bash
bash tests/test_massive.sh
```

Validate the skill shape:

```bash
python3 /home/noir/.codex/skills/.system/skill-creator/scripts/quick_validate.py .
```

## Releases

Push a version tag to create a GitHub release:

```bash
git tag v0.1.0
git push origin v0.1.0
```

The release workflow publishes an autogenerated GitHub release from the tag.
