# 万豪旅享家 Skill 使用指南

## 快速开始

```
/marriott 帮我查下上海杨浦周边的酒店，下周三到周五，要可以免费取消的
```

---

## 前置条件（每次使用前必做）

### 第一步：启动调试版 Chrome

skill 脚本需要连接一个**运行在端口 9222 的 Chrome 实例**。由于 Chrome 新版本要求 remote debugging 必须用非默认 profile，需指定临时目录：

```bash
# 关闭已有 Chrome
pkill -f "Google Chrome" 2>/dev/null; sleep 2

# 复制你的 Cookie 到临时目录（带上登录态）
rm -rf /tmp/chrome-marriott-profile
mkdir -p /tmp/chrome-marriott-profile/Default
cp ~/Library/Application\ Support/Google/Chrome/Default/Cookies \
   /tmp/chrome-marriott-profile/Default/
cp ~/Library/Application\ Support/Google/Chrome/Local\ State \
   /tmp/chrome-marriott-profile/

# 启动 Chrome
"/Applications/Google Chrome.app/Contents/MacOS/Google Chrome" \
  --remote-debugging-port=9222 \
  --user-data-dir=/tmp/chrome-marriott-profile \
  --no-first-run \
  --no-default-browser-check \
  --disable-blink-features=AutomationControlled \
  > /tmp/chrome.log 2>&1 &

# 确认启动成功
sleep 5 && curl -s http://localhost:9222/json/version | grep Browser
```

输出 `"Browser": "Chrome/..."` 即表示成功。

### 第二步：在 Chrome 中登录万豪账号

Chrome 启动后会弹出浏览器窗口，导航至万豪登录页并完成登录：

```
https://www.marriott.com.cn/sign-in.mi
```

登录成功后，页面右上角会显示你的姓名（如"Jun ye"）。

### 第三步：验证登录状态

```bash
cd ~/.claude/skills/marriott
node -e "
const { chromium } = require('playwright');
(async () => {
  const b = await chromium.connectOverCDP('http://localhost:9222');
  const cookies = await b.contexts()[0].cookies('https://www.marriott.com.cn');
  const s = cookies.find(c => c.name === 's_loginState');
  console.log('登录状态:', s ? s.value : '未登录');
  await b.close();
})();
"
```

输出 `登录状态: authenticated` 或 `remembered` 即可开始使用。

---

## 使用方式

直接用自然语言描述需求，skill 会自动解析：

```
/marriott 帮我找上海虹桥附近的酒店，3月10日到13日，1间大床房，要灵活退改的
/marriott 北京三里屯周边酒店，明天到后天
/marriott --dest "上海陆家嘴" --in 2026-03-10 --out 2026-03-12 --adults 2
```

---

## 完整流程说明

### 搜索 → 选择酒店 → 选择房型 → 确认预订

```
你                    Claude                     Marriott
 |                       |                           |
 |  /marriott 上海虹桥   |                           |
 |---------------------->|                           |
 |                       |-- skill-search.js ------->|
 |                       |<-- 酒店列表 JSON ---------|
 |<-- 展示4家酒店表格 ---|                           |
 |                       |                           |
 |  选2号               |                           |
 |---------------------->|                           |
 |                       |-- skill-select.js         |
 |                       |-- skill-rooms.js -------->|
 |                       |<-- 房型列表 JSON ----------|
 |<-- 展示房型价格表 ----|                           |
 |                       |                           |
 |  选3号（大床+灵活）  |                           |
 |---------------------->|                           |
 |<-- 预订摘要确认 ------|                           |
 |                       |                           |
 |  确认                |                           |
 |---------------------->|                           |
 |                       |-- skill-book.js --------->|
 |<-- 确认号 + 总价 -----|                           |
```

---

## 常见问题

### ❌ `无法连接 Chrome`
Chrome 未在端口 9222 启动。重新执行"前置条件第一步"。

### ❌ `未检测到登录状态`
Chrome 已连接但未登录万豪。在 Chrome 中打开 `https://www.marriott.com.cn/sign-in.mi` 完成登录。

### ❌ `Access Denied`（Akamai 拦截）
Akamai 检测到自动化浏览器。原因通常是：
- 用了空白 profile 的 Chrome（没有真实 Cookie/指纹）
- skill 脚本尝试直接跳转搜索 URL 而非通过已有会话

解决：按照前置条件，用复制了真实 Cookie 的 profile 启动 Chrome，并确保已登录。

### ❌ `rooms 为空`
查看截图排查：
```bash
open ~/.claude/skills/marriott/debug-no-rooms.png
```

### Chrome 重启后登录失效
每次重启 Chrome 时重新复制 Cookies 文件（登录态由 Cookie 保持，每次复制时需保证原 Chrome 已关闭）：
```bash
pkill -f "Google Chrome" 2>/dev/null; sleep 1
cp ~/Library/Application\ Support/Google/Chrome/Default/Cookies \
   /tmp/chrome-marriott-profile/Default/
```

---

## 技术背景

| 组件 | 作用 |
|------|------|
| `skill-search.js` | 地理编码 + 连接 Chrome on 9222 → 导航搜索页 → 提取酒店卡片 |
| `skill-select.js` | 将用户选择写入 `selection.json` |
| `skill-rooms.js` | 打开酒店页 → 提取所有房型×价格方案 |
| `skill-book.js` | 点击"预订"按钮 → 等待确认页 → 返回确认号 |
| `cookies.json` | search 后保存的 Cookie，供 rooms/book 使用 |

**为什么不能直接跳 URL**：万豪使用 Akamai Bot Manager，会检测无历史 Cookie、Canvas 指纹异常、缺少正常浏览行为的请求，直接 `findHotels.mi?...` 跳转会被 403 拦截。skill 通过连接真实用户 Chrome 绕过此检测。

**为什么必须指定 `--user-data-dir`**：Chrome 115+ 禁止在默认 profile 上开启 remote debugging（安全策略），必须使用非默认目录。

---

## 文件说明

```
~/.claude/skills/marriott/
├── 使用指南.md          # 本文件
├── SKILL.md             # Claude skill 定义（供 Claude 内部使用）
├── launch-chrome.sh     # 旧版启动脚本（macOS open -a 方式，有兼容性问题）
├── skill-search.js      # 搜索脚本
├── skill-select.js      # 选择酒店脚本
├── skill-rooms.js       # 查询房型脚本
├── skill-book.js        # 执行预订脚本
├── search-results.json  # 搜索结果缓存
├── selection.json       # 用户选择缓存
├── rooms-results.json   # 房型结果缓存
└── cookies.json         # 会话 Cookie 缓存
```
