# Struggling Marriage

Recurring conflict, disconnection, resentment. Not yet considering divorce, but hurting.

## Diagnostic: What Kind of Stuck?

**Communication breakdown:**
- Same fight, different topic
- Can't discuss without escalating
- Walking on eggshells
- Silent treatment cycles

**Emotional disconnection:**
- Roommates, not partners
- No intimacy (physical or emotional)
- Loneliness while married
- Don't share real feelings

**Trust damage:**
- Betrayal (affair, financial, other)
- Broken promises pattern
- Suspicious of motives
- Can't be vulnerable

**Resentment accumulation:**
- Keeping score
- Contempt in conflict
- Can't let go of past hurts
- Victim mentality

---

## Breaking Negative Cycles

**The Four Horsemen (Gottman):**
1. **Criticism** — Attacking character, not behavior
2. **Contempt** — Disgust, superiority, mockery (worst predictor)
3. **Defensiveness** — Never taking responsibility
4. **Stonewalling** — Shutting down, walking away

**Antidotes:**
1. Criticism → Gentle startup, "I" statements
2. Contempt → Build culture of appreciation
3. Defensiveness → Take some responsibility
4. Stonewalling → Self-soothe, return to conversation

---

## De-escalation Protocol

**When fight is escalating:**
1. Notice physiological flooding (heart rate >100)
2. Call timeout: "I need 20 minutes to calm down"
3. Agree on return time (not abandonment)
4. Self-soothe: walk, breathe, don't rehearse argument
5. Return and try again

**Can't problem-solve while flooded.**

---

## The Roommate Marriage

**Signs:**
- Efficient household, empty relationship
- Parallel schedules, minimal intersection
- Topics: kids, logistics, nothing personal
- Physical affection absent

**Rebuilding:**
- Schedule connection (yes, schedule)
- Small bids for attention (respond to them)
- One meaningful conversation daily
- Touch without sexual expectation
- Shared activities beyond household

---

## One-Sided Effort

**When you're trying, they're not:**
- Communicate what you need (specifically)
- Set deadline for visible effort
- Consider: are they incapable or unwilling?
- Therapy request as serious ask
- Know your own limits

**You cannot save a marriage alone.**

---

## Forgiveness Work

**Forgiveness is:**
- Releasing the debt
- Choosing not to punish forever
- Process, not single moment
- For you, not just them

**Forgiveness requires:**
- Full acknowledgment of hurt (from offender)
- Genuine remorse demonstrated
- Changed behavior over time
- Patience with setbacks

**Cannot forgive what isn't acknowledged.**

---

## The Scorekeeping Trap

**Signs:**
- "I always..." / "You never..."
- Cataloging wrongs
- Transactional mentality
- Waiting for them to go first

**Breaking it:**
- Give without tallying
- Focus on contribution, not comparison
- Address patterns, not individual incidents
- Reset to partnership mindset

---

## Kids Complication

**When to shield kids:**
- No fighting in front of children
- Never use kids as messengers
- Don't badmouth other parent
- Protect from adult problems

**When kids witness:**
- They also need to see repair
- Model healthy conflict resolution
- Reassure about family stability
- Consider family therapy

---

## Professional Help

**When to seek:**
- Same patterns despite effort
- Can't have productive conversations
- Trust breach needs mediated repair
- One or both considering ending it
- Individual issues affecting marriage

**Types:**
- Marriage/couples therapy (together)
- Individual therapy (separate issues)
- Marriage retreat/intensive
- Religious counseling (if aligned)

**Finding right fit matters. Try another if first doesn't work.**

---

## Rough Patch vs Fundamental Problem

**Rough patch:**
- Caused by external stress
- Both want to fix it
- History of good times to reference
- Skills deficit, not will deficit

**Fundamental problem:**
- Core values misalignment
- One person checked out
- Pattern across entire marriage
- Toxicity baseline

**Different situations need different responses.**
