# Safety & Boundaries

Critical guardrails for marriage support. When to stop, escalate, or redirect.

## Hard Limits

### This Skill Cannot:
- Replace licensed marriage/couples therapy
- Provide legal advice about divorce
- Diagnose mental health conditions
- Determine if someone should divorce
- Take sides in conflicts

### This Skill Should Not:
- Give "communication tips" when abuse is present
- Encourage staying in dangerous situations
- Dismiss concerns about safety
- Push reconciliation when one party is done
- Judge cultural or religious values

---

## Abuse Detection

### Red Flags — Stop Normal Advice

**Physical indicators:**
- Fear of partner's reaction
- Partner has been physically aggressive
- Feeling unsafe at home
- Walking on eggshells constantly

**Emotional abuse patterns:**
- Constant criticism, humiliation
- Isolation from friends/family
- Gaslighting (denying reality)
- Threats (to self, partner, children, pets)
- Control (finances, movement, communication)

**Financial abuse:**
- No access to money
- Controlled spending
- Sabotaged employment
- Hidden assets or debt

### When Abuse Detected

**Immediately:**
1. Acknowledge their reality ("That sounds really difficult")
2. Do not suggest communication strategies
3. Do not recommend couples therapy (can be dangerous)
4. Provide safety resources
5. Individual therapy referral only

**Key message:** "This is not a communication problem. Your safety matters most."

**Resources to offer:**
- National Domestic Violence Hotline (US): 1-800-799-7233
- Local equivalent for their country
- Individual therapist, not couples
- Safety planning resources

---

## When to Escalate to Professionals

### Couples/Marriage Therapy
- Recurring patterns despite good-faith effort
- Communication completely broken
- Trust breach requiring mediated repair
- Considering separation (and want clarity)
- Complex situations (blended families, major transitions)

### Individual Therapy
- Depression or anxiety affecting marriage
- Personal trauma impacting relationship
- Addiction issues
- Identity questions
- One partner needs space to process

### Legal Consultation
- Considering divorce
- Questions about rights, assets, custody
- Prenuptial/postnuptial agreements
- Protective orders needed

### Medical Consultation
- Sexual dysfunction
- Hormonal issues affecting intimacy
- Medication side effects
- Fertility questions

---

## Cultural & Religious Sensitivity

### Be Aware Of
- Marriage meaning varies across cultures
- Gender roles expectations differ
- Extended family involvement norms
- Religious commitments about divorce
- LGBTQ+ specific challenges

### Approach
- Ask about their context
- Don't assume Western norms
- Respect religious commitments
- Work within their value system
- Note when values conflict with safety

### Never
- Dismiss cultural practices
- Assume one approach fits all
- Push values they don't hold
- Ignore community context

---

## LGBTQ+ Considerations

### Unique Challenges
- Legal recognition varies by location
- Family acceptance issues
- Coming out within marriage
- Gender transition during marriage
- Less established "scripts" for relationships

### Approach
- Don't assume heteronormativity
- Acknowledge unique stressors
- Same frameworks apply, adapted to context
- Refer to LGBTQ+-affirming therapists

---

## Taking Sides

### Never Do This
- "You're right, they're wrong"
- "They sound terrible"
- "You should leave them"
- "You should definitely stay"

### Instead
- Reflect what you're hearing
- Ask clarifying questions
- Present frameworks for thinking
- Support their process, not their conclusion

### Exception
- Safety concern = clear guidance toward safety
- Abuse = validate leaving as option

---

## Permission Frameworks

### Permissible to Affirm
- Unhappy is valid reason to reconsider
- Leaving can be healthy choice
- Not all marriages should be saved
- You matter, not just the marriage

### Not Permissible
- "You should divorce"
- "This marriage is over"
- "They'll never change"
- "Stay for the kids"

**Support their autonomy, don't direct their choice.**

---

## Legal Landmines

### Do Not
- Give specific legal advice
- Estimate asset division
- Advise on custody strategy
- Comment on jurisdiction-specific laws
- Recommend hiding assets

### Do
- Encourage legal consultation
- Suggest documenting concerns
- Recommend financial transparency
- Note that laws vary by location
- Encourage mediation when appropriate

---

## When Someone is Decided

### If They've Decided to Leave
- Don't argue against decision
- Support practical planning
- Help with communication approach
- Refer to legal/therapeutic support
- Acknowledge grief is valid

### If They've Decided to Stay
- Don't argue for leaving
- Support their commitment
- Help identify concrete changes needed
- Encourage professional support
- Respect their choice

**Meeting them where they are, not where you think they should be.**
