# Marriage Frameworks

Universal tools applicable across marriage stages.

## Fighting Fair Protocol

### Conflict Structure
```
"When you [specific behavior], 
 I feel [emotion], 
 I need [specific request]."
```

### Rules
- One issue at a time (no kitchen-sinking)
- No "always" or "never"
- Attack problem, not person
- No contempt (eye rolls, mockery)
- Take breaks when flooded (return committed)

### Repair Attempts
- Humor (inside jokes)
- Touch (hand on arm)
- Acknowledgment ("you're right about X")
- De-escalation ("can we start over?")

**Accepting repair attempts is more important than making them.**

---

## Money Conversations

### Regular Money Meeting (Monthly)
1. Review spending vs budget
2. Progress on shared goals
3. Upcoming expenses
4. Any concerns or requests
5. Celebrate wins

### Big Financial Decision Framework
1. Both get full information
2. Understand each other's fears
3. Identify what you each need
4. Find creative middle ground
5. Set review date

### Money Boundaries
- Spending threshold for discussion
- Personal spending allowance (no questions)
- Transparency about debts
- Joint goals visibility

---

## Reconnection Rituals

### Daily Minimums
- 6-second kiss (Dr. Gottman's research)
- "How was your day?" with follow-up questions
- One expressed appreciation
- Device-free time together

### Weekly Non-Negotiables
- Date (not errands, actual date)
- Longer conversation (not logistics)
- Physical intimacy (whatever form works)

### Quarterly Check-in
**Questions to discuss:**
- What's working in our relationship?
- What needs more attention?
- What's one thing I could do differently?
- What are we looking forward to?

---

## Big Decisions Framework

### For Major Life Choices
1. **Information gathering** — Both research independently
2. **Fear sharing** — What worries each of you?
3. **Needs clarity** — What do you each need from outcome?
4. **Option generation** — Creative solutions beyond either/or
5. **Decision together** — United front once decided
6. **Review date** — Revisit if needed

### Decision Categories
- **Two yeses** — Both must agree (kids, major purchases, relocation)
- **One yes, one okay** — Important but not critical (vacation choices)
- **Individual domain** — Personal choice (career, friendships)

---

## Appreciation Practice

### Daily Habits
- Notice one thing partner did well
- Express it specifically ("I appreciate that you...")
- Public appreciation (in front of others)
- Written notes occasionally

### The 5:1 Ratio
**For stable marriages:**
- Five positive interactions
- For every one negative

**Positive includes:**
- Interest, affection, humor
- Validation, empathy, agreement
- Joy, playfulness, support

---

## Intimacy Maintenance

### Understanding Desire Types
- **Spontaneous** — Desire appears, then arousal
- **Responsive** — Arousal triggers desire

Most long-term relationships involve responsive desire. Starting intimacy without initial desire is normal and healthy.

### Negotiating Frequency
- Neither person's libido is "right"
- Find sustainable middle ground
- Quality over quantity
- Non-sexual intimacy counts

### Maintenance Conversation
- "What's working for you?"
- "What would you like more of?"
- "What's a fantasy you'd share?"
- "What gets in the way?"

---

## Boundary Conversations

### With In-Laws
- Partner addresses their own family
- "We've decided..." not "She says..."
- Kind but clear
- United front always

### Script Template
"We love you and [acknowledge positive]. We've decided that [boundary]. This helps us [reason that benefits family]. We hope you understand."

### Maintaining Boundaries
- Expect pushback
- Stay consistent
- Reinforce kindly
- Partner backs up partner

---

## Crisis Protocol

### When Acute Crisis Hits
1. Pause major decisions (24-48 hours minimum)
2. Get support (therapist, trusted friend)
3. Separate logistical from emotional
4. Basic self-care (sleep, eat)
5. Commit to process, not immediate outcome

### What Counts as Crisis
- Affair discovery
- Major betrayal (financial, other)
- Separation threat
- Health crisis
- Job loss / major stressor

---

## Forgiveness Process

### Steps
1. **Full acknowledgment** — Offender names what they did and impact
2. **Genuine remorse** — Not just "sorry you're upset"
3. **Behavior change** — Demonstrated over time
4. **Gradual trust rebuild** — Patience required
5. **Releasing the debt** — Choosing not to punish forever

### What Forgiveness Isn't
- Forgetting
- Pretending it didn't matter
- Trusting immediately
- Reconciliation (can forgive and still leave)

### Timeline
- Months to years, not days
- Non-linear (setbacks normal)
- Both people's work
