# Seller Guide

## Listing Optimization

**Titles (platform-specific):**
- eBay: 80-char limit, front-load brand + key attributes
- Etsy: Use all 13 tags, no keyword stuffing in title
- Amazon: Brand + Product + Key Features + Size/Quantity

**Photos:**
- First photo = most important (shows in search)
- Include measurements with ruler/tape
- Show ALL flaws clearly (prevents returns + bad reviews)
- Real photos always; stock photos = red flag to buyers

**Descriptions:**
- Lead with dimensions (the #1 question)
- Disclose every flaw—hiding them = returns + negative reviews
- Answer common questions preemptively
- Keep it scannable, not walls of text

## Pricing Strategy

**Research method:**
1. Search SOLD/COMPLETED listings, not active
2. Filter by same condition
3. Note price range and average sell time
4. Price at median for faster sale, above for margin

**Platform fee awareness:**
| Platform | Fee Structure |
|----------|---------------|
| eBay | ~13% final value (varies by category) + promoted listings 2-15% |
| Poshmark | Flat 20% for >$15, flat $2.95 for ≤$15 |
| Mercari | 10% + payment processing |
| Etsy | Listing ($0.20) + 6.5% transaction + 3%+ payment |
| Amazon | 8-45% referral (category) + FBA fees if applicable |

## Buyer Communication

**Lowball responses:**
- Sub-50% offers: "Thanks for the offer! I'm firm at $X."
- Reasonable offers (70-85%): Consider counter or accept

**Common scam patterns to reject:**
- "I'll pay more, send to this address" = triangulation
- Payment outside platform = no protection
- "My shipper will pick up" = stolen card

## Platform-Specific Rules

**eBay:**
- Promoted listings eat margins; test carefully
- Defect rate matters more than individual profit
- International = customs forms complexity

**Poshmark:**
- Flat $7.97 shipping under 5lbs; overweight = penalty
- Share listings daily to stay visible
- All communication is public

**FB Marketplace:**
- 50% no-show rate on meetups; don't travel far
- "Is this still available?" = 90% never follow up
- Algorithm buries slow responders

**Etsy:**
- Handmade/vintage only (technically)
- Fees add up fast: listing + transaction + payment + offsite ads
- Reselling mass-produced items = shop ban risk
