# Compliance & Legal Guide

## Tax Obligations

**US Sales Tax Nexus:**
- Economic nexus thresholds vary by state
- Common: $100K revenue OR 200 transactions (South Dakota standard)
- Marketplace Facilitator laws shift burden to platforms—but not always
- Multi-channel sellers must track exposure per state

**International VAT:**
- EU: €10K threshold for cross-border B2C
- Failure to register = back taxes + penalties + platform suspension
- UK: Separate post-Brexit registration required

**Income Reporting:**
- 1099-K threshold: $600 (current US)
- DAC7 (EU): Platforms report seller income to tax authorities
- "Hobby seller" defense increasingly rejected by auditors

## Platform Ban Triggers

**Universal violations:**
- Review manipulation (fake reviews, incentivized without disclosure)
- Multiple accounts without approval
- Off-platform transaction solicitation
- Shill bidding on your own items

**Amazon-specific:**
- Order Defect Rate > 1%
- Late shipment > 4%
- Inauthentic complaints (need supplier invoices, not retail receipts)
- Selling in restricted brands without ungating

**eBay-specific:**
- VeRO (brand IP) complaints
- Excessive shipping charges for fee avoidance
- Keyword spamming
- Feedback extortion

## Where AI Gives Dangerous Advice

**Tax advice failures:**
- ❌ "Under $X you don't need to report" — confuses 1099-K threshold with actual obligation
- ❌ "Register in Delaware for no taxes" — conflates entity formation with nexus
- ❌ Citing outdated thresholds from training data

**Legal structure failures:**
- ❌ "LLC protects you from product liability" — veil piercing is real
- ❌ Generic advice without jurisdiction context

**Platform rule failures:**
- ❌ Outdated ToS interpretation (policies change frequently)
- ❌ "Everyone does it" normalization of violations
- ❌ US-centric assumptions ignoring EU consumer rights

## Intellectual Property

**Common mistakes:**
- Using brand names/logos without authorization
- "Inspired by" products that violate design patents
- Assuming no trademark registration = safe (common law rights exist)

**Brand protection programs:**
- Amazon Brand Registry = brands can nuke listings instantly
- eBay VeRO = IP owners can strike your account
- Even small sellers get targeted—"too small to sue" is false

## Liability Exposure

| Category | Key Risk |
|----------|----------|
| Products | Injury liability if underinsured |
| Services | Worker classification (employee vs contractor) |
| Rentals | Damage disputes, security deposits |
| B2B | Invoice disputes, net-30 non-payment |

**Consumer protection:**
- EU: 14-day mandatory cooling-off period
- California Prop 65 applies to items shipped TO California
- Product recalls: even small sellers may have reporting duties
