# Arbitrage & Reselling Guide

## True ROI Calculation

**Include ALL costs:**
```
Revenue
- Platform fee (referral %)
- Fulfillment fee (FBA/shipping)
- Storage fees (especially Q4: 3x higher)
- Prep fees ($0.50-2.00/unit if using prep center)
- Return rate loss (15-30% in some categories)
- Inbound shipping cost
= Actual Profit
```

**Break-even analysis:**
- Calculate liquidation price if item doesn't sell
- Factor long-term storage fees (6+ months)
- Model time-to-sell based on category velocity

## Sourcing Evaluation

**Quick pass/fail:**
- <$5 profit after ALL fees = not worth it
- >50 sellers on listing = race to bottom
- Brand on restricted/gated list = instant suspension risk
- Category you're not ungated in = can't sell

**Good signals:**
- <10 FBA sellers on listing
- 30-day velocity > 10 units
- No Amazon "in-stock" threat
- Stable price history (check Keepa)

## Amazon-Specific Traps

**Suspension triggers:**
- Dropshipping from other retailers (you must be seller of record)
- "Inauthentic" complaints (retail receipts don't count as invoices)
- Listing store returns as "New"
- Selling restricted brands without ungating

**Fee complexity:**
- Referral fee: 8-45% depending on category
- FBA pick/pack: varies by size tier
- Dimensional weight vs actual weight
- Inbound placement fees (shipment splitting)
- Removal/disposal fees when inventory doesn't sell

**Buy Box factors:**
- Price isn't everything
- Account health score matters
- Fulfillment method (FBA favored)
- Inventory depth

## Multi-Platform Arbitrage

**Platform ToS awareness:**
| Action | Amazon | eBay |
|--------|--------|------|
| Dropship from retailer | ❌ Banned | ⚠️ Gray area |
| Multiple accounts | ❌ Instant ban | ⚠️ Requires approval |
| Cross-listing same item | ✓ OK | ✓ OK (manage inventory) |

**Price parity issues:**
- Some supplier agreements require same price across channels
- Violating = relationship damage, supply cut off

## Timing Traps

- **Q4 storage fees:** October-December = 3x normal
- **Seasonal buying:** Post-season liquidation = capital locked 12 months
- **Deal timing:** By the time you source, ship to FBA, and go live, 10 others found the same deal
- **Lightning deal sourcing:** Everyone sees it = instant saturation
