# Customer Validation

## Pre-Building Validation

### The Mom Test Questions

Avoid leading questions. Get facts about past behavior, not future intentions.

❌ "Would you use an app that does X?"
✅ "How do you currently solve X?"
✅ "What happened last time you faced this problem?"
✅ "How much time/money did that cost you?"

### Jobs-to-be-Done Framework

Structure: "When [situation], I want to [motivation], so I can [outcome]."

Example: "When I'm preparing for a board meeting, I want to quickly assess competitor moves, so I can confidently answer questions about market positioning."

### Finding Interview Subjects

**Cold outreach:**
- LinkedIn (filter by role + industry + company size)
- Twitter/X (search for people complaining about the problem)
- Industry Slack/Discord communities
- Relevant subreddits

**Warm introductions:**
- Ask existing network for intros
- Offer value exchange (share research findings)

**Target:** 20-30 conversations before any confidence in patterns

## Validation Signals

### Strong Signals (Worth Building)

| Signal | Weight |
|--------|--------|
| Customer gives you money (prepayment, LOI) | ⭐⭐⭐⭐⭐ |
| Customer spends significant time helping you | ⭐⭐⭐⭐ |
| Customer introduces you to others with same problem | ⭐⭐⭐⭐ |
| Customer describes workarounds they've built | ⭐⭐⭐ |
| Customer articulates the problem in your words | ⭐⭐⭐ |

### Weak Signals (Keep Digging)

| Signal | Reality |
|--------|---------|
| "I'd definitely use that" | Polite enthusiasm, not commitment |
| "Great idea!" | Compliment, not validation |
| Survey says 80% interested | Stated preference ≠ revealed preference |
| Lots of social media engagement | Attention ≠ willingness to pay |

## Survey Design

### Question Types

**Screening questions:** Filter to your target audience
**Behavioral questions:** What have they done (past tense)
**Preference questions:** What would they choose (less reliable)
**Open-ended questions:** Capture language and unexpected insights

### Sample Size

| Confidence Level | Margin of Error | Required Sample |
|-----------------|-----------------|-----------------|
| 95% | ±5% | ~400 responses |
| 95% | ±10% | ~100 responses |
| 90% | ±10% | ~70 responses |

For early validation, directional insights from 50-100 responses are often sufficient.

### Common Survey Mistakes

- Leading questions
- Double-barreled questions (asking two things at once)
- Social desirability bias (people say what sounds good)
- Too many questions (fatigue lowers quality)
- No screening for irrelevant respondents

## Pricing Research

### Van Westendorp Method

Ask 4 questions:
1. At what price would this be **too expensive** to consider?
2. At what price would this be **expensive but worth considering**?
3. At what price would this be a **good deal**?
4. At what price would this be **so cheap you'd question quality**?

Plot results to find optimal price range.

### Willingness-to-Pay Interview

"If this product existed today and solved [specific problem], what would you pay for it?"

Follow up: "What would make it worth 2x that price?"

### Competitive Pricing Analysis

| Competitor | Pricing Model | Entry Price | Mid-tier | Enterprise |
|------------|--------------|-------------|----------|------------|
| Competitor A | Per seat | $15/mo | $45/mo | Custom |
| Competitor B | Usage-based | $0.01/call | $0.008/call | Volume discounts |
| Competitor C | Flat rate | $99/mo | $299/mo | $999/mo |

Position your pricing based on:
- Value delivered vs alternatives
- Target customer segment
- Competitive reference points
