# Competitor Analysis Frameworks

## Landscape Mapping

### Direct vs Indirect Competitors

| Type | Definition | Example (CRM) |
|------|------------|---------------|
| **Direct** | Same solution, same customer | Salesforce, HubSpot |
| **Indirect** | Different solution, same problem | Spreadsheets, email |
| **Potential** | Could enter your space | Microsoft, Google |

### Positioning Matrix

Map competitors on 2 axes relevant to your market:
- Price vs Features
- Enterprise vs SMB
- Vertical vs Horizontal
- Simple vs Complex

Find the white space — where are customers underserved?

## Review Mining

### Where to Look
- **B2B SaaS:** G2, Capterra, TrustRadius
- **Consumer Apps:** App Store, Play Store
- **Physical Products:** Amazon, specialized forums
- **Services:** Yelp, Google Reviews, industry forums

### What to Extract
1. **Recurring complaints** — Same issue mentioned 10+ times = real problem
2. **Feature requests** — What's missing from existing solutions?
3. **Use case patterns** — How do different segments use the product?
4. **Switching triggers** — Why did they leave their previous solution?

### Template: Complaint Frequency Matrix

| Complaint | Competitor A | Competitor B | Competitor C |
|-----------|-------------|-------------|-------------|
| Slow support | 47 mentions | 12 mentions | 89 mentions |
| Confusing UI | 31 mentions | 56 mentions | 8 mentions |
| Too expensive | 22 mentions | 3 mentions | 15 mentions |

## Competitive Intelligence Sources

### Public Information
- **Financials:** 10-K, 10-Q (public companies), Crunchbase funding
- **Strategy signals:** Job postings, press releases, conference talks
- **Product changes:** Changelog, Product Hunt launches, app updates

### Ethical Intelligence Gathering
✅ Public filings and press releases
✅ Published pricing pages
✅ User reviews and forums
✅ Conference presentations
✅ Open source contributions

❌ Fake customer inquiries
❌ Social engineering employees
❌ Scraping behind paywalls
❌ Accessing internal documents

## Feature Comparison Matrix

### Template

| Feature | Your Product | Competitor A | Competitor B | Priority |
|---------|-------------|-------------|-------------|----------|
| Core feature 1 | ✅ | ✅ | ❌ | Must-have |
| Core feature 2 | 🔄 Building | ✅ | ✅ | Must-have |
| Advanced feature | ❌ | ✅ | ❌ | Nice-to-have |
| Unique differentiator | ✅ | ❌ | ❌ | Differentiator |

### How to Prioritize
1. **Must-have:** Without this, customers won't consider you
2. **Differentiator:** This is why they'll choose you over alternatives
3. **Nice-to-have:** Adds value but doesn't drive purchase decisions

## Market Share Estimation

When no public data exists:

1. **Traffic-based:** SimilarWeb, Alexa (if available)
2. **Employee-based:** Revenue per employee benchmarks × headcount
3. **Funding-based:** Typical revenue multiple for stage × funding raised
4. **App download-based:** Download counts → conversion assumptions → paying users

**Always caveat estimates** with methodology and confidence level.
