# Trusted News Sources for Market Analysis

## Tier 1: Primary Sources (Highest Priority)

### Central Banks and Government Agencies

**Federal Reserve:**
- FederalReserve.gov - FOMC statements, meeting minutes, economic projections
- Federal Reserve Economic Data (FRED) - St. Louis Fed database
- Fed Chair speeches and testimonies

**U.S. Treasury:**
- Treasury.gov - Debt auctions, policy announcements
- Treasury International Capital (TIC) data

**Bureau of Labor Statistics (BLS):**
- Employment reports (Non-Farm Payrolls)
- CPI, PPI inflation data
- Wage statistics

**Bureau of Economic Analysis (BEA):**
- GDP reports
- Personal income and spending data
- Trade balance

**U.S. Census Bureau:**
- Retail sales
- Housing starts and permits
- Durable goods orders

**European Central Bank (ECB):**
- ECB.europa.eu - Policy decisions, press conferences

**Bank of Japan (BOJ):**
- BOJ.or.jp - YCC policy, intervention signals

**People's Bank of China (PBOC):**
- English.pbc.gov.cn - LPR, RRR decisions

**International Organizations:**
- International Monetary Fund (IMF.org)
- World Bank
- Bank for International Settlements (BIS)

### Securities and Exchange Commission (SEC)

- SEC.gov/edgar - Corporate filings
- 10-K/10-Q reports
- 8-K material events
- Form 4 insider trading
- 13-F institutional holdings

## Tier 2: Major Financial News Organizations

### Bloomberg

**Bloomberg.com / Bloomberg Terminal:**
- Real-time market data
- Breaking news (high speed)
- Economic calendar
- Company-specific news
- Commodity market coverage

**Strengths:**
- Speed and accuracy
- Terminal access for professionals
- Global coverage
- Proprietary data/analytics

**Usage Notes:**
- Subscription required for full access
- Terminal news (FIRST) most timely
- Search: "company earnings", "FOMC", "oil prices", "geopolitical"

### Reuters

**Reuters.com:**
- Wire service speed
- Global bureaus
- Political and economic coverage
- Commodities expertise

**Strengths:**
- Fact-based reporting
- International reach
- Breaking news accuracy
- Energy/commodity specialization

**Usage Notes:**
- Search: "central bank", "earnings", "trade war", "sanctions"

### Wall Street Journal (WSJ)

**WSJ.com:**
- In-depth analysis
- Corporate investigations
- Markets section excellent
- Fed coverage authoritative

**Strengths:**
- Quality journalism
- Source credibility
- Business insights
- Investigative depth

**Usage Notes:**
- Paywall (subscription needed)
- Search markets, economy, tech sections
- "Heard on the Street" column valuable

### Financial Times (FT)

**FT.com:**
- European market focus
- Global economics
- Central bank coverage
- Energy/commodities

**Strengths:**
- International perspective
- ECB/BOE expertise
- Emerging markets coverage
- Quality analysis

**Usage Notes:**
- Paywall (subscription)
- Search: "ECB", "emerging markets", "China economy"

### CNBC

**CNBC.com:**
- Real-time market updates
- CEO interviews
- Trader perspectives
- Options/derivatives coverage

**Strengths:**
- Market-moving headlines
- Live coverage during trading hours
- Accessible (free)
- Video content

**Usage Notes:**
- Search: "breaking news", "earnings", "fed", sector-specific
- "Squawk Box", "Closing Bell" segments notable

### MarketWatch

**MarketWatch.com:**
- Retail investor focus
- Market summaries
- Economic calendar
- Real-time quotes

**Strengths:**
- Accessible language
- Free access
- Market wrap coverage
- Economic data releases

### Barron's

**Barrons.com:**
- Weekend edition analysis
- Stock picks and pans
- Macro themes
- Investor interviews

**Strengths:**
- Thoughtful analysis
- Long-term perspective
- Contrarian views
- Technical analysis

## Tier 3: Specialized Sources

### Energy and Commodities

**S&P Global Platts:**
- Oil price assessments
- Energy market data
- Commodity analytics

**Rigzone:**
- Oil & gas industry news
- Upstream/downstream coverage

**Mining.com:**
- Metals and mining news
- Production data
- M&A coverage

**AgWeb / Farm Journal:**
- Agricultural markets
- Weather impacts
- USDA data analysis

### Technology

**The Information:**
- Tech industry scoops
- Startup coverage
- Big Tech investigations
- Subscription investigative journalism

**TechCrunch:**
- Startup funding
- Product launches
- Tech M&A

**Ars Technica:**
- Deep technical analysis
- Hardware/semiconductor coverage

**AnandTech:**
- Semiconductor deep dives
- Chip architecture

### Emerging Markets

**Emerging Markets.com:**
- EM debt and equity
- Currency analysis
- Political risk

**Africa Report, LatAm Reports:**
- Regional focus
- Mining, agriculture coverage

### China-Specific

**Caixin Global:**
- Independent Chinese business news
- Economic data analysis
- English language

**South China Morning Post (SCMP):**
- Hong Kong perspective
- Greater China coverage
- Business section

**China Daily (State Media):**
- Official government view
- Policy direction signals
- Use with awareness of bias

### Cryptocurrency/Digital Assets

**CoinDesk:**
- Crypto market news
- Regulatory developments
- Blockchain technology

**The Block:**
- Crypto investigative journalism
- Industry analysis

## Tier 4: Analysis and Research

### Independent Research

**Strategas Research Partners:**
- Washington policy analysis
- Political impact on markets

**BCA Research:**
- Global macro strategy
- Asset allocation

**Gavekal Research:**
- Macro analysis
- China expertise

### Central Bank Researchers

**Federal Reserve Bank Publications:**
- New York Fed (Liberty Street Economics blog)
- San Francisco Fed (Economic Letter)
- Cleveland Fed (Inflation expectations)

### Think Tanks

**Peterson Institute (PIIE):**
- International economics
- Trade policy

**Brookings Institution:**
- Economic policy research

**Council on Foreign Relations (CFR):**
- Geopolitical analysis

## Search and Aggregation Tools

### News Aggregators

**Google Finance:**
- Company-specific news aggregation
- Stock screeners

**Yahoo Finance:**
- Free real-time quotes
- News aggregation
- Earnings calendar

**Seeking Alpha:**
- Crowdsourced analysis
- Earnings call transcripts
- Varied quality (user-generated)

### Economic Calendars

**Forex Factory:**
- Economic event calendar
- Impact ratings
- Consensus estimates

**Investing.com:**
- Global economic calendar
- Real-time data
- Multi-asset coverage

**TradingEconomics.com:**
- Historical economic data
- Forecasts
- Country-specific

## News Source Quality Assessment

### Reliability Indicators

**Positive Signals:**
- Named sources
- Corroborating reports from multiple outlets
- Official statements/documents referenced
- Transparent corrections policy
- Separation of news and opinion

**Red Flags:**
- Anonymous sources only
- Single-source stories
- Sensational headlines mismatching content
- Lack of verification
- Ideological bias overwhelming facts

### Speed vs. Accuracy Trade-off

**Fastest (Use for Alerts, Verify Later):**
- Bloomberg Terminal (FIRST function)
- Reuters wire
- Twitter/X (major news organizations' verified accounts)

**Most Accurate (Use for Analysis):**
- WSJ, FT investigative pieces
- Official government data releases
- SEC filings
- Central bank statements

**Balanced (Speed + Reliability):**
- Bloomberg web
- Reuters web
- CNBC breaking news

## Source Selection by News Type

### Monetary Policy (Fed, ECB, BOJ)

**Primary:**
1. Central bank official websites
2. WSJ Fed coverage
3. Reuters central bank desk
4. FT central banking section

**Supplementary:**
- Bloomberg central bank reporters (specific journalists)
- CNBC live Fed coverage

### Corporate Earnings

**Primary:**
1. Company press releases (IR websites)
2. SEC filings (10-Q, 8-K)
3. Bloomberg earnings coverage
4. WSJ company coverage

**Supplementary:**
- Seeking Alpha transcripts
- CNBC earnings alerts
- MarketWatch summaries

### Geopolitical Events

**Primary:**
1. Reuters international desk
2. FT geopolitical coverage
3. Bloomberg geopolitical news
4. BBC (for initial breaking news)

**Supplementary:**
- CFR analysis (for context)
- Energy-specific: Platts, Rigzone (if energy-related)

### Commodity Markets

**Primary:**
1. Reuters commodity desk
2. S&P Global Platts
3. Bloomberg commodity coverage

**Supplementary:**
- Mining.com (metals)
- AgWeb (agriculture)
- Rigzone (energy)

### Technology Sector

**Primary:**
1. Bloomberg tech
2. WSJ tech section
3. The Information (scoops)
4. Reuters tech coverage

**Supplementary:**
- TechCrunch (startups)
- Ars Technica (semiconductors)
- Company blogs (for product launches)

## Recommended News Search Strategy

### For Comprehensive 10-Day Analysis

**Day 1-2: Broad Search**
- Search terms: "stock market", "federal reserve", "inflation", "oil prices", "earnings", "geopolitical"
- Sources: Bloomberg, Reuters, WSJ
- Identify major themes

**Day 3-5: Deep Dive on Major Events**
- Identified themes: Search specific (e.g., "FOMC meeting", "NVIDIA earnings", "Israel conflict oil")
- Sources: Add FT, CNBC, specialized (Platts for commodities)
- Read original statements/filings when available

**Day 6-7: Impact Analysis**
- Market reaction search: "[Event] market reaction", "S&P 500 response", sector impacts
- Sources: MarketWatch, Barron's, Seeking Alpha (for varied perspectives)
- Analyst commentary

**Day 8-10: Synthesis**
- Connect dots between events
- Look for contrary indicators
- Verify facts across multiple sources

### WebSearch Query Recommendations

**For Recent News (Past 10 Days):**
- "stock market news past week"
- "FOMC meeting [current month]"
- "major earnings reports [current month]"
- "geopolitical events impacting markets [current month]"
- "oil prices news last 10 days"
- "Federal Reserve policy [current month]"

**For Specific Events:**
- "[Company] earnings [quarter] [year]"
- "FOMC statement [date]"
- "[Geopolitical event] commodity prices"
- "[Country] central bank decision [date]"

**For Market Reactions:**
- "[Event] market reaction"
- "S&P 500 [date] why"
- "[Sector] stocks [event]"

## Source Credibility Framework

### Tier 1 (Official, Primary Sources):
- Use for facts, data, official policy
- No interpretation needed, direct information

### Tier 2 (Major Financial Press):
- Use for breaking news, broad coverage
- Cross-check major scoops
- Trust for market-moving headlines

### Tier 3 (Specialized):
- Use for domain-specific deep dives
- Valuable for niche sectors
- Supplement Tier 1 & 2

### Tier 4 (Analysis):
- Use for interpretation, context
- Understand potential biases
- Compare multiple viewpoints

## Red Flag News Sources (Avoid or Use with Extreme Caution)

- Unverified social media rumors
- Clickbait financial sites
- Pump-and-dump stock promoters
- Anonymous blogs without editorial standards
- News aggregators without source verification
- AI-generated content farms (without human editorial)

## Best Practices

1. **Primary Source First**: Always seek official statements, filings, data releases
2. **Multiple Confirmation**: Major news should appear in 2+ Tier 2 sources
3. **Speed vs Accuracy**: Use fast sources for alerts, authoritative for analysis
4. **Bias Awareness**: Understand each source's perspective (US-centric, China-focused, etc.)
5. **Date Verification**: Ensure news is actually recent (past 10 days for this analysis)
6. **Update Cycle**: Some news develops over days (FOMC speculation → decision → reaction)
