# Market Event Patterns and Market Reactions

## Central Bank Monetary Policy Events

### Federal Reserve (FOMC)

**Event Types:**
- Federal Funds Rate Decisions
- Quantitative Easing (QE) / Quantitative Tightening (QT) Announcements
- Forward Guidance Changes
- Emergency Policy Actions

**Typical Market Reactions:**

**Interest Rate Hikes:**
- **Equity Markets**: Generally negative, especially for high-growth/tech stocks (higher discount rates reduce present value of future earnings)
- **Bond Markets**: Bond prices fall, yields rise
- **Dollar (USD)**: Strengthens
- **Commodities**: Gold typically weakens (opportunity cost of holding non-yielding asset), Oil may weaken on demand concerns
- **Sectors Most Impacted**:
  - Technology: Negative (high valuations sensitive to rates)
  - Financials: Positive initially (higher net interest margins), but negative if rate hikes slow economy
  - Utilities/REITs: Negative (yield-sensitive sectors)
  - Consumer Discretionary: Negative (higher borrowing costs impact spending)

**Interest Rate Cuts:**
- **Equity Markets**: Generally positive, especially growth stocks
- **Bond Markets**: Bond prices rise, yields fall
- **Dollar (USD)**: Weakens
- **Commodities**: Gold strengthens, commodities generally positive
- **Sectors Most Impacted**:
  - Technology: Positive
  - Real Estate (REITs): Positive
  - Financials: Mixed (lower margins but better credit quality)

**Quantitative Easing (QE):**
- **Equity Markets**: Strong positive (liquidity injection)
- **Bond Markets**: Bond prices rise (central bank buying)
- **Dollar (USD)**: Weakens (currency debasement)
- **Commodities**: Positive across the board (inflation hedge)
- **Risk Assets**: Broad support

**Quantitative Tightening (QT):**
- **Equity Markets**: Negative pressure (liquidity withdrawal)
- **Bond Markets**: Yields rise (reduced central bank demand)
- **Dollar (USD)**: Strengthens
- **Commodities**: Mixed to negative

**Hawkish vs Dovish Tone:**
- **Hawkish** (inflation-focused, tightening bias): Risk-off, USD strength, bond yields up
- **Dovish** (growth-focused, easing bias): Risk-on, USD weakness, bond yields down

### European Central Bank (ECB)

**Key Differences from Fed:**
- Eurozone fragmentation concerns (peripheral vs core spreads)
- Negative rate environment history
- Bank-centric economy (vs capital markets in US)

**Typical Reactions:**
- EUR/USD currency pair highly sensitive
- European bank stocks react strongly to rate decisions
- Sovereign bond spreads (Italy, Spain, Greece vs Germany) sensitive to policy

### Bank of Japan (BOJ)

**Unique Characteristics:**
- Yield Curve Control (YCC) policy
- Decades of ultra-loose policy
- Direct equity ETF purchases

**Typical Reactions:**
- JPY movements extreme when policy shifts (especially YCC band adjustments)
- Japanese equity markets (Nikkei) sensitive to JPY movements (export-dependent)
- Global carry trade implications (JPY as funding currency)

### People's Bank of China (PBOC)

**Policy Tools:**
- Loan Prime Rate (LPR)
- Reserve Requirement Ratio (RRR)
- Medium-term Lending Facility (MLF)

**Typical Reactions:**
- Easing: Positive for commodities (China as major consumer), positive for EM currencies
- Tightening: Negative for commodities, negative for risk assets globally
- Australian Dollar (AUD) highly sensitive (China trade exposure)

## Inflation Data Releases

### US CPI (Consumer Price Index)

**Higher Than Expected:**
- **Equity Markets**: Negative (rate hike expectations increase)
- **Bond Yields**: Rise sharply
- **Dollar**: Strengthens
- **Gold**: Mixed (inflation positive but rate hike negative)
- **Fed Policy Expectations**: Hawkish shift

**Lower Than Expected:**
- **Equity Markets**: Positive rally
- **Bond Yields**: Fall
- **Dollar**: Weakens
- **Gold**: Strengthens
- **Fed Policy Expectations**: Dovish shift

### PPI (Producer Price Index)

- Leading indicator for CPI
- Strong reactions in industrial/materials sectors
- Commodity-linked stocks sensitive

### PCE (Personal Consumption Expenditures)

- Fed's preferred inflation measure
- Core PCE most important
- Similar directional reactions to CPI but often larger magnitude

## Employment Data

### Non-Farm Payrolls (NFP)

**Stronger Than Expected (High Job Growth):**
- **Initial Reaction**: Positive (economic strength)
- **Secondary Reaction**: Can turn negative if triggers rate hike concerns
- **Sectors**: Cyclicals outperform, defensives underperform

**Weaker Than Expected:**
- **Initial Reaction**: Negative (growth concerns)
- **Secondary Reaction**: Can turn positive if dovish policy response expected
- **Sectors**: Defensives outperform

**Wage Growth Component:**
- Higher wages: Inflation concerns, negative for equities
- Lower wages: Disinflationary, positive for equities

### Unemployment Rate

- Below natural rate (~4%): Inflation concerns
- Above natural rate: Growth concerns
- Initial claims (weekly): Leading indicator sensitivity

## GDP Reports

**Stronger Than Expected:**
- Positive for equities generally
- Currency strengthens
- Rate hike expectations increase (if economy already strong)

**Weaker Than Expected:**
- Negative for equities
- Currency weakens
- Rate cut expectations increase (if economy weakening)

**GDP Components Matter:**
- Consumer spending strength: Positive for Consumer sectors
- Business investment: Positive for Industrials, Technology
- Trade balance: Currency implications

## Geopolitical Events

### Military Conflicts / Wars

**Immediate Reactions:**
- **Equity Markets**: Risk-off selloff, especially in affected regions
- **Safe Havens**: USD, JPY, CHF strengthen; Gold rallies
- **Oil**: Spikes if energy supply disruption risk
- **Volatility (VIX)**: Surges

**Examples:**
- Russia-Ukraine conflict: Energy prices surge, European equities weak, defense stocks rally
- Middle East conflicts: Oil volatility, regional equity weakness

### Trade Wars / Tariffs

**Announcement of Tariffs:**
- **Affected Countries' Equities**: Negative
- **Export-Dependent Sectors**: Negative (Industrials, Materials)
- **Domestic-Focused Sectors**: Relative outperformance
- **Currencies**: Affected countries' currencies weaken

**US-China Trade Tensions:**
- Technology sector highly sensitive (supply chain concerns)
- Agricultural commodities volatile (retaliatory tariffs)
- Emerging market currencies under pressure

### Sanctions

- Targeted country's assets decline
- Replacement suppliers benefit (e.g., US LNG exports when Russian gas sanctioned)
- Financial sector compliance costs

## Corporate Earnings Events

### Mega-Cap Technology Earnings

**Companies: Apple, Microsoft, Amazon, Google, Meta, NVIDIA, Tesla**

**Impact on Broader Market:**
- Index-level impact significant (high market cap weights)
- Sector rotation triggers (Tech strength/weakness affects growth vs value)
- Forward guidance critical (AI spending, cloud growth, etc.)

**Typical Reactions:**
- **Beat + Raise**: Strong positive, often lifts entire index
- **Beat + Lower Guidance**: Negative despite beat
- **Miss**: Severe selloff, can drag indices significantly
- **AI-Related Themes**: NVIDIA results particularly market-moving (2023-2024)

### Banking Sector Earnings

**Major Banks: JPMorgan, Bank of America, Wells Fargo, Citigroup**

**Key Metrics:**
- Net Interest Margin (NIM): Rate environment sensitivity
- Credit Loss Provisions: Economic outlook indicator
- Trading Revenue: Market volatility impact
- Loan Growth: Economic activity proxy

**Broader Implications:**
- Financial sector earnings often lead cycle
- Credit quality trends predictive of recession risk
- Regional bank stress contagion risk (March 2023 example)

### Energy Sector Earnings

**Key Drivers:**
- Oil/gas price realizations
- Production volumes
- Capital discipline (buybacks vs drilling)

**Market Impact:**
- Correlated with commodity prices
- Inflation narrative implications
- Geopolitical overlay

## Credit Events

### Corporate Defaults / Distress

- Credit spreads widen
- Flight to quality (Treasuries rally)
- Equity markets negative (systemic risk concerns)
- High-yield bonds decline

### Credit Rating Changes

**Downgrades:**
- Stock price negative
- Bond yields rise (prices fall)
- Sector contagion if systemic

**Upgrades:**
- Stock price positive
- Bond yields fall (prices rise)
- Limited broader impact

## Commodity-Specific Events

### OPEC+ Meetings

**Production Cuts:**
- Oil prices rally
- Energy stocks positive
- Inflation concerns if sustained

**Production Increases:**
- Oil prices decline
- Energy stocks negative
- Disinflationary positive for growth stocks

### Grain/Agricultural Reports (USDA)

- Weather impacts (droughts, floods)
- Planting/harvest data
- Agricultural commodity prices volatile
- Food inflation implications

### Metals Supply Disruptions

- Mining strikes
- Export restrictions
- Positive for metal prices
- Mining stocks rally

## Recession Indicators

### Yield Curve Inversion (2s10s)

**Inversion (short rates > long rates):**
- Historical recession predictor (12-18 month lead time)
- Initial reaction: Risk-off
- Financials particularly negative (NIM compression)

**Steepening (disinversion):**
- Can signal imminent recession (ironically negative initially)
- Or economic acceleration (positive if growth-driven)

### Leading Economic Indicators (LEI)

- Manufacturing PMI (ISM)
- Consumer confidence
- Housing starts
- Composite LEI

**Negative readings:** Recession concerns mount progressively

## Historical Case Studies

### 2008 Financial Crisis

**Lehman Bankruptcy (September 2008):**
- Equities: S&P 500 -40% peak to trough
- Credit spreads: Blew out to crisis levels
- Safe havens: Treasuries rallied, gold initially sold (liquidity crisis) then rallied
- USD: Strengthened (deleveraging)

### COVID-19 Pandemic (March 2020)

**Initial Selloff:**
- Fastest bear market in history (S&P 500 -34% in weeks)
- Oil crashed (WTI briefly negative)
- VIX hit 80+

**Fed Response:**
- Unlimited QE announcement: Market bottom
- Zero rates, emergency facilities
- Equities: V-shaped recovery

### 2022 Inflation Shock

**Aggressive Fed Tightening:**
- 75bps hikes (unprecedented in modern era)
- Growth stocks crushed (Nasdaq -33%)
- Bonds no diversification (60/40 worst year since 1970s)
- Dollar rallied strongly

## Pattern Recognition Framework

### News Type Classification

**Tier 1 (Market-Moving):**
- FOMC decisions
- Inflation surprises (±0.2% from consensus)
- Major geopolitical shocks
- Mega-cap tech earnings misses
- Banking crisis events

**Tier 2 (Sector-Moving):**
- Sector-specific regulation
- Commodity supply disruptions
- Large corporate M&A
- Credit rating changes (investment grade)

**Tier 3 (Stock-Specific):**
- Individual company earnings
- Management changes
- Product launches
- Smaller M&A deals

### Sentiment Analysis

**Risk-On Environment:**
- Growth stocks outperform value
- High-beta outperforms low-beta
- Emerging markets outperform developed
- Credit spreads tight
- VIX low (<15)

**Risk-Off Environment:**
- Value stocks outperform growth (or decline less)
- Low-volatility outperforms
- Developed markets outperform emerging
- Credit spreads widen
- VIX elevated (>20)

### Time Horizon Considerations

**Immediate (Intraday):**
- Algorithmic/HFT reactions
- Often overshoot

**Short-term (Days-Weeks):**
- Fundamental reassessment
- Positioning adjustments

**Medium-term (Months):**
- Earnings revision cycles
- Policy transmission lags

**Long-term (Quarters-Years):**
- Structural shifts
- Regime changes
