# Geopolitical Events and Commodity Correlations

## Energy Commodities

### Crude Oil (WTI / Brent)

**Middle East Conflicts:**

**Supply Disruption Risk:**
- Strait of Hormuz tensions: ~20% of global oil supply passes through
  - Iran tensions: Oil +5-15% immediately
  - Historical: 2019 Saudi Aramco attacks: Oil +15% in single day
- Saudi Arabia/UAE production: ~15% of global supply
  - Instability: Oil rallies sharply
- Iraq/Libya disruptions: Regional conflicts impact production
  - Libya civil war: Removed 1M+ barrels/day periodically

**Israel-Palestine Conflicts:**
- Direct impact minimal (neither major producer)
- Indirect via regional escalation concerns
- Safe-haven bid for oil typically +2-5%

**Iranian Tensions:**
- Nuclear program concerns
- Sanctions/sanctions relief
  - Sanctions: Removes ~1-2M barrels/day, oil +10-20%
  - Sanctions relief: Adds supply, oil -10-15%
- Proxy conflicts (Yemen, Syria, Lebanon)

**Russia-Ukraine Conflict:**

**Natural Gas:**
- European dependence on Russian gas (~40% pre-conflict)
- Nord Stream disruptions: Natural gas prices +300-400% (2022)
- Coal as alternative: Thermal coal rallied strongly
- LNG exports from US/Qatar beneficiaries

**Crude Oil:**
- Russia ~10% of global supply
- Sanctions impact: Removed ~1M barrels/day from market
- Oil price: +40% in initial months (2022)
- Urals discount to Brent widened to $30-40/barrel

**Petroleum Products:**
- Diesel shortages in Europe (Russia major supplier)
- Gasoline prices globally impacted

**US-China Tensions:**

**Energy Demand Implications:**
- Trade war: Chinese growth slowdown concerns, oil -5-10%
- Taiwan tensions: Regional instability premium, oil +3-7%
- Technology restrictions: Minimal direct impact on oil

**US-Iran Relations:**
- Sanctions enforcement cycles
- Oil supply ~1-2M barrels/day swing factor
- Price impact: ±10-15% depending on direction

**Venezuela Political Crisis:**
- Production collapsed from ~3M to ~0.7M barrels/day
- Sanctions impact
- Regime change prospects: Oil price sensitive to potential supply return

### Natural Gas

**European Energy Crisis (Russia-Ukraine):**
- As detailed above, massive impact
- Coal-to-gas switching reversed
- Renewables acceleration

**US Production Growth:**
- Shale revolution reduced geopolitical sensitivity
- LNG export capacity growth
- Winter weather events still create volatility

**Asian LNG Markets:**
- Japan/South Korea/China major importers
- Competition for LNG cargoes during crises
- Price spikes in supply disruptions

### Coal

**Russia-Ukraine Conflict:**
- Russian coal sanctions
- European utilities switching gas-to-coal
- Thermal coal prices +200% (2022)

**China-Australia Trade Tensions:**
- Informal coal import ban (2020-2021)
- China shifted to Indonesian/Russian coal
- Australian coal exporters found alternative buyers
- Metallurgical coal (steel-making) less impacted

**Climate Policy:**
- Long-term decline narrative
- Short-term supply tightness from underinvestment

## Precious Metals

### Gold

**Geopolitical Risk Premium:**

**General Pattern:**
- Conflicts/crises: Gold +2-10% immediate rally
- Safe-haven flows dominate
- Negative real rates amplify gains

**Specific Events:**

**Russia-Ukraine Conflict:**
- Gold rallied from $1,800 to $2,070 (March 2022)
- Central bank buying increased (dedollarization theme)
- Physical demand surge

**Middle East Escalations:**
- Historical: Iraq War (2003): Gold +7%
- Syria conflicts: Moderate impact (+2-4%)
- Recent Israel-Gaza: Gold +5-8%

**US-China Tensions:**
- Gradual safe-haven bid
- Central bank reserve diversification (China buying gold)
- Currency war implications

**Banking Crises:**
- 2008: Gold rallied during acute stress
- 2023 regional bank failures: Gold +10% in weeks
- Trust in fiat currency undermined

**Currency Debasement Concerns:**
- Massive fiscal deficits
- QE programs
- Inflation hedging demand

**Interest Rate Interaction:**
- Geopolitical premium can override rate headwinds
- Real rates still primary driver long-term
- Risk-off overrides opportunity cost considerations short-term

### Silver

**Industrial Demand Component:**
- 50% industrial use (solar, electronics, EVs)
- Economic slowdown from geopolitics: Negative
- Green energy push: Positive

**Gold Correlation:**
- Trades with gold during risk-off (0.7-0.8 correlation)
- Amplified moves (higher beta to gold)

**Russia-Ukraine Example:**
- Industrial recession fears limited silver gains vs gold
- Gold/Silver ratio widened (gold outperformed)

### Platinum/Palladium

**Russian Supply Dominance:**
- Russia ~40% of palladium supply
- ~10% of platinum supply
- Sanctions concerns: Prices spiked 2022

**Automotive Demand:**
- Catalytic converters
- EV transition threat long-term
- Recession fears negative

**South African Supply Risks:**
- Political instability
- Power shortages (load-shedding)
- Mining strikes frequent

## Base Metals

### Copper

**"Dr. Copper" - Economic Barometer:**

**China Demand (50% of global):**
- China-US trade war: Copper -20% (2018-2019)
- China stimulus: Copper rallies sharply
- Property sector troubles: Negative (major copper consumer)
- Infrastructure spending: Positive

**Chilean Supply (25% of global):**
- Political instability (2019 protests): Copper +5%
- Mining strikes: Immediate price spikes
- Environmental restrictions: Long-term supply concerns
- Water scarcity issues

**Peruvian Supply (10% of global):**
- Political instability frequent
- Community protests at mines
- Supply disruptions: Price supportive

**Zambia/DRC (African Copper Belt):**
- Political risk elevated
- Infrastructure challenges
- Chinese investment dominance

**Energy Transition Demand:**
- EVs use 4x copper vs ICE vehicles
- Grid infrastructure buildout
- Long-term bullish narrative

**Geopolitical Implications:**
- US-China tech war: Copper demand impact (semiconductors, data centers)
- Green energy policies: Demand support
- Recession fears: Demand destruction

### Aluminum

**China Production Dominance (60%):**
- Energy-intensive production
- Power shortages: Production curtailments, price spikes
- Environmental regulations: Supply constraints

**Russia Supply (~6%):**
- Sanctions concerns (Ukraine war)
- Aluminum rallied 2022
- European smelters curtailed (high energy costs)

**Guinea Bauxite (Major Supplier):**
- Political instability (2021 coup)
- Supply concerns for aluminum feedstock

**Applications:**
- Aerospace (geopolitical tensions affect demand)
- Automotive (EVs increasing content)
- Construction (economic growth sensitive)

### Nickel

**Indonesia Supply Dominance (Growing):**
- Ore export ban (2020): Reshuffled global supply chains
- Chinese investment in Indonesian processing
- Environmental concerns

**Russia Supply (~10%):**
- Sanctions risk (Ukraine war)
- Nickel short squeeze (LME chaos, March 2022): +250% in days
- Tsingshan vs LME positions

**Philippines Supply:**
- Environmental regulations
- Mining permit uncertainties
- Typhoon disruptions

**EV Battery Demand:**
- Nickel-rich cathodes (NMC, NCA)
- Competition with iron-phosphate (LFP) batteries
- Indonesia-China battery supply chain

### Zinc

**China Production/Consumption (~40%):**
- Galvanizing steel (construction, auto)
- Smelter margins squeeze when energy costs high
- Production cuts when unprofitable

**Peru/Australia Supply:**
- Mining disruptions
- Concentrate availability

**Russia Supply (~5%):**
- Sanctions impact moderate

## Agricultural Commodities

### Wheat

**Russia-Ukraine (30% of Global Exports):**
- Black Sea export disruptions
- Ukraine ports blockaded (2022): Wheat +50%
- Russia export restrictions/export tax adjustments
- Grain deal negotiations critical

**Weather Events:**
- Droughts in major producers (US Plains, Australia, Argentina)
- Floods in harvest seasons
- Climate change increasing volatility

**India Export Bans:**
- Domestic food security priorities
- Heat waves trigger export restrictions
- Sudden policy changes create price spikes

**North Africa/Middle East Importers:**
- Political instability when bread prices spike
- Arab Spring correlation with wheat prices
- Food security national security issue

### Corn

**US Production Dominance (35% of Global):**
- Weather in Midwest (drought/floods)
- USDA crop reports market-moving

**Brazil/Argentina (Major Exporters):**
- Weather patterns (La Niña impacts)
- Currency fluctuations affect export competitiveness
- Infrastructure challenges (Brazil transport)

**China Demand:**
- Livestock feed demand
- Trade deal purchase commitments
- ASF (African Swine Fever) impacts herd sizes

**Ukraine Supply Disruptions:**
- Corn exports halted during war
- Black Sea logistics

**Ethanol Demand:**
- US biofuel mandates
- Energy prices correlation

### Soybeans

**Brazil-China Trade:**
- China imports 60% of global soybeans
- US-China trade war: Brazil beneficiary
- Brazil overtook US as top exporter

**Argentina Processing:**
- Crushing industry
- Export taxes policy changes

**Weather Risks:**
- Brazil (drought in key states)
- Argentina (La Niña flooding/drought cycles)
- US Midwest (flash droughts)

**China Demand Drivers:**
- Livestock feed (pig herd cycles)
- African Swine Fever devastation (2019): Demand collapsed
- Herd rebuilding: Demand recovery

**Geopolitical Leverage:**
- US-China trade tool
- Brazil-China relationship benefits

## Rare Earth Elements / Critical Minerals

### Rare Earths

**China Dominance (60% Production, 90% Processing):**
- Export restrictions as geopolitical tool
- US-China tensions: Supply security concerns
- Price manipulation capability

**Applications:**
- Defense systems (missiles, jets)
- EVs (motors)
- Wind turbines
- Electronics

**Alternative Supply Development:**
- US (Mountain Pass mine)
- Australia (Lynas)
- Processing capacity bottleneck

**Historical Example:**
- 2010 China-Japan dispute: China restricted exports, prices surged

### Lithium

**EV Battery Critical Component:**

**Australia/Chile Supply (~75%):**
- Australia: Spodumene (hard rock)
- Chile: Brine deposits (Atacama)
- Political risks moderate

**China Processing Dominance (~60%):**
- Refining bottleneck
- US/Europe scrambling to build capacity

**Argentina "Lithium Triangle":**
- Chile-Argentina-Bolivia
- Nationalization risks
- Water usage controversies

**Price Volatility:**
- 2022: +400% on EV demand surge
- 2023: -70% on overcapacity concerns
- Geopolitical diversification premium

### Cobalt

**DRC Production (70% of Global):**
- Political instability
- Child labor controversies
- Chinese control of mines

**Battery Chemistry Shift:**
- Reducing cobalt content (ethical concerns, cost)
- Cobalt-free batteries development

**Sanctions/Ethical Sourcing:**
- Supply chain scrutiny
- Price premium for certified ethical cobalt

## Regional Geopolitical Frameworks

### Middle East

**Oil Price Transmission:**
- Conflicts → Oil ↑ → Inflation ↑ → Rate hikes → Equities ↓
- Energy stocks benefit
- Emerging markets pressured (oil importers)

**Safe Haven Flows:**
- Gold, USD, JPY, CHF rally
- Equities decline (especially European, EM)

**Shipping Disruptions:**
- Suez Canal (10% of global trade)
- Strait of Hormuz (oil)
- Red Sea shipping costs

### Russia-Europe Energy

**Natural Gas Dependency:**
- Europe vulnerable
- Russia leverage
- Coal, LNG, nuclear substitutes

**Sanctions Effectiveness:**
- Energy payments carve-outs complicated
- Oil price caps
- Gray market/smuggling

### Asia-Pacific

**Taiwan Strait Tensions:**
- Semiconductor supply chain choke point
- Shipping disruptions (South China Sea)
- Technology stocks highly sensitive
- Safe-haven flows massive if conflict

**South China Sea:**
- Shipping lanes (1/3 of global trade)
- Energy deposits disputes

### Latin America

**Commodity Exporters:**
- Political shifts affect mining/energy policy
- Nationalization risks
- Currency volatility amplifies commodity moves

**Examples:**
- Peru mining conflicts
- Chile constitutional changes (mining tax debates)
- Brazil Amazon policies (agricultural land)
- Argentina capital controls, export taxes

## Correlation Summary Table

| Geopolitical Event Type | Oil | Gold | Copper | Wheat | USD | Equities |
|------------------------|-----|------|--------|-------|-----|----------|
| Middle East War | ↑↑ | ↑↑ | ↓ | ↑ | ↑ | ↓↓ |
| Russia-Ukraine | ↑↑ | ↑↑ | ↓ | ↑↑ | ↑ | ↓↓ |
| US-China Trade War | ↓ | ↑ | ↓↓ | ↔ | ↑ | ↓ |
| Taiwan Conflict | ↑ | ↑↑ | ↓↓ | ↑ | ↑↑ | ↓↓↓ |
| Emerging Market Crisis | ↓ | ↑ | ↓↓ | ↔ | ↑↑ | ↓↓ |
| Banking Crisis | ↓↓ | ↑↑ | ↓↓ | ↓ | ↑ | ↓↓↓ |

**Legend:**
- ↑↑↑ = Very strong positive
- ↑↑ = Strong positive
- ↑ = Moderate positive
- ↔ = Neutral/mixed
- ↓ = Moderate negative
- ↓↓ = Strong negative
- ↓↓↓ = Very strong negative

## Time Horizon Considerations

**Immediate (Days):**
- Risk-off knee-jerk reactions
- Safe haven flows
- Energy spikes if supply threatened

**Short-term (Weeks-Months):**
- Reality check vs initial fears
- Supply chain actual disruptions materialize
- Central bank/government responses

**Medium-term (Months-Year):**
- Economic impact transmission
- Inflation effects through commodity channel
- Policy adjustments (strategic reserves, alternative suppliers)

**Long-term (Years):**
- Supply chain restructuring
- Energy transition acceleration
- Reserve currency implications
