# Market Indicators Reference

## Major Stock Indices

### Japan
- **Nikkei 225**: Stock price average of 225 representative stocks on Tokyo Stock Exchange Prime
  - Key levels: 30,000, 35,000, 40,000 yen
  - Moving averages: Emphasize 25-day, 75-day, 200-day lines

- **TOPIX**: Market-cap weighted average of all Tokyo Stock Exchange Prime stocks
  - Better reflects overall market
  - Heavily influenced by banking/financial sector

### United States
- **S&P 500**: 500 large-cap US stocks
  - Most representative US stock index
  - Key levels: 4,000, 4,500, 5,000 points

- **NASDAQ**: Tech-focused
  - Reflects mega-cap tech stock trends like GAFAM
  - Higher volatility

- **Dow Jones Industrial Average**: Simple average of 30 stocks
  - Historically significant but limited representation

## Foreign Exchange Rates

### USD/JPY (Dollar-Yen)
- Greatest impact on Japanese economy
- Key levels: 140, 145, 150, 155 yen
- BOJ intervention alert line: Reference past intervention records

### EUR/JPY (Euro-Yen)
- Related to European economy
- Influenced by ECB policy

### CNY/JPY (Yuan-Yen)
- Reflects Chinese economic trends
- Indicator of Asian trade

## Volatility Indicators

### VIX Index (Fear Index)
- Calculated from S&P 500 option prices
- Quantifies market anxiety psychology
- Interpretation:
  - 10-15: Low volatility, stable market
  - 15-20: Normal range
  - 20-30: Unstable, caution needed
  - 30+: High stress, panic selling

### Nikkei VI
- Volatility indicator for Nikkei Average
- Japanese version of VIX

## Commodities

### Crude Oil (WTI/Brent)
- Important as inflation indicator
- Reflects geopolitical risks
- Key levels: 70, 80, 90, 100 dollars/barrel

### Gold
- Representative safe asset
- Tends to rise during dollar weakness/inflation
- Key levels: 1,900, 2,000, 2,100 dollars/ounce

## Interest Rates & Bonds

### US 10-Year Treasury Yield
- Most critical interest rate indicator
- Direct impact on stock valuations
- Key levels: 3.5%, 4.0%, 4.5%, 5.0%

### Japan 10-Year Government Bond Yield
- Reflects BOJ policy
- Watch YCC target range

## Sector-Specific Focus Points

### Technology
- AI-related stock trends
- Semiconductor cycle
- Regulatory risks

### Financials
- Heavily influenced by interest rate trends
- Bank lending attitudes
- Non-performing loan ratios

### Energy
- Linked to crude oil prices
- Impact of decarbonization policies
- Renewable energy shift

### Consumer
- Consumer confidence index
- Retail sales
- Inflation impact
