---
name: Markdown
description: Generate clean, portable Markdown that renders correctly across parsers.
metadata: {"clawdbot":{"emoji":"📝","os":["linux","darwin","win32"]}}
---

## Whitespace Traps

- Blank line required before lists, code blocks, and blockquotes—without it, many parsers continue the previous paragraph
- Nested lists need 4 spaces (not 2) for GitHub/CommonMark; 2 spaces breaks nesting in strict parsers
- Two trailing spaces for `<br>` break—invisible and often stripped by editors; prefer blank line or `<br>` tag
- Lines with only spaces still break paragraphs—trim trailing whitespace

## Links & Images

- Parentheses in URLs break `[text](url)`—use `%28` `%29` or angle brackets: `[text](<url with (parens)>)`
- Spaces in URLs need `%20` or angle bracket syntax
- Reference-style links `[text][ref]` fail silently if `[ref]: url` is missing—verify all refs exist
- Images without alt text: always provide `![alt](url)` even if empty `![]()` for accessibility tools

## Code

- Triple backticks inside fenced blocks—use 4+ backticks for outer fence or indent method
- Inline backticks containing backtick—wrap with double backticks and pad: ``` `` `code` `` ```
- Language hint after fence affects syntax highlighting—omit only when truly plain text

## Tables

- Alignment colons go in separator row: `:---` left, `:---:` center, `---:` right
- Pipe `|` in cell content needs backslash escape: `\|`
- No blank line before table—some parsers fail
- Empty cells need at least one space or break rendering

## Escaping

- Characters needing escape in text: `\*`, `\_`, `\[`, `\]`, `\#`, `\>`, `\``, `\\`
- Escape not needed inside code spans/blocks
- Ampersand only needs escape as `&amp;` when it could form an HTML entity

## Portability

- HTML tags work in GitHub but stripped in many renderers—prefer pure Markdown
- Extended syntax (footnotes, task lists, emoji shortcodes) not universal—check target parser
- YAML frontmatter needs `---` fences and only at file start; some parsers render it as text
