---
name: markdown-viewer
description: Live markdown viewer for AI pair-editing. When you collaborate, the updates render instantly. Works with any AI agent and web browser.
homepage: https://github.com/wipcomputer/wip-markdown-viewer
metadata:
  {
    "openclaw":
      {
        "emoji": "📝",
        "requires": { "bins": ["node", "curl"] },
        "install":
          [
            {
              "id": "npm",
              "kind": "npm",
              "package": "@wipcomputer/markdown-viewer",
              "global": true,
              "bins": ["mdview"],
              "label": "Install markdown-viewer (npm)",
            },
          ],
      },
  }
---

# Live Markdown Viewer

Live markdown viewer for AI pair-editing. When you collaborate, the updates render instantly. Works with any AI agent and web browser.

GitHub: [wipcomputer/wip-markdown-viewer](https://github.com/wipcomputer/wip-markdown-viewer)
npm: [@wipcomputer/markdown-viewer](https://www.npmjs.com/package/@wipcomputer/markdown-viewer)

## Install

```bash
npm install -g @wipcomputer/markdown-viewer
```

This installs the `mdview` command globally. Zero runtime dependencies. Pure Node.js.

## Quick start

Start the server (binds to 127.0.0.1 only, never exposed to the network):

```bash
curl -s http://127.0.0.1:3000/ > /dev/null 2>&1 || mdview &
```

Open a file in your default browser:

```bash
# macOS
open "http://127.0.0.1:3000/view?path=/absolute/path/to/file.md"

# Linux
xdg-open "http://127.0.0.1:3000/view?path=/absolute/path/to/file.md"

# Windows
start "http://127.0.0.1:3000/view?path=/absolute/path/to/file.md"
```

## How it works

1. Tell your AI coding tool to install `@wipcomputer/markdown-viewer` globally
2. Tell your AI to open a .md file in md view
3. AI opens the file in your default browser
4. Every save re-renders the page instantly. No refresh needed.

Open multiple tabs to work on multiple documents at once.

## Security

- Server binds to `127.0.0.1` only. It is not accessible from other machines.
- The `/view?path=` parameter reads files from your local filesystem. Use `--root <dir>` to restrict access to a specific directory tree. Recommended for shared environments.
- Zero npm dependencies. No supply chain risk beyond Node.js itself.

## Features

- SSE-powered live reload (works in Safari, Chrome, Firefox)
- Multi-file support (each tab watches its own file)
- GitHub Flavored Markdown (tables, task lists, strikethrough)
- Syntax highlighting (180+ languages)
- Dark mode
- Table of contents
- Mermaid diagrams
- KaTeX math equations

## Troubleshooting

**Page shows the index instead of my file:** The server was started with `--root` restricting access. Restart without `--root`.

**Safari stalls or shows blank page:** Hard refresh (Cmd+Shift+R) or restart the server. Safari caches SSE connections aggressively.

**macOS `open` drops the query string:** Use AppleScript instead:
```bash
osascript -e 'tell application "Safari" to open location "http://127.0.0.1:3000/view?path=/your/file.md"'
```

## Notes

- Server runs at `http://127.0.0.1:3000` by default. Use `mdview --port 8080` to change.
- The server does not survive reboots. The curl check in quick start restarts it if needed.
- Do NOT start the server with a file path argument. Always start bare (`mdview`). Starting with a path locks the server to that directory.
- Drag and drop any .md file onto the homepage to view it.
- Zero external requests. All dependencies bundled locally.
