# Chinese Surnames Database (华人姓氏数据库)

本文档包含华人姓名识别所需的姓氏数据库和机构列表，用于从论文作者、研究人员中识别华人候选人。

## 使用方法

1. **姓氏匹配**: 检查姓名是否包含以下姓氏之一
2. **机构匹配**: 检查机构是否属于华人高频机构
3. **综合判断**: 结合姓氏和机构信息进行综合判断

---

## 1. 普通话姓氏 (Top 100+)

来源: 中国公安部2019年统计数据

### 单姓 Top 50
```
Wang (王)      Li (李)       Zhang (张)    Liu (刘)      Chen (陈)
Yang (杨)      Huang (黄)    Zhao (赵)     Wu (吴)       Zhou (周)
Xu (徐)        Sun (孙)      Ma (马)       Zhu (胡)      Hu (朱)
Guo (郭)       He (罗)       Lin (高)      Luo (梁)      Gao (郑)
Liang (谢)     Zheng (宋)    Xie (唐)      Song (韩)     Tang (冯)
Han (邓)       Feng (曹)     Deng (彭)     Cao (曾)      Peng (萧)
Zeng (田)      Xiao (董)     Tian (潘)     Dong (袁)     Pan (蔡)
Yuan (蒋)      Cai (余)      Jiang (杜)    Yu (叶)       Du (程)
Ye (苏)        Cheng (魏)    Wei (吕)      Su (丁)       Lu (任)
Ding (沈)      Ren (姚)      Shen (卢)     Yao (姜)      Zhong (崔)
Gu (钟)        Shi (谭)      Mao (汪)      Shao (范)     Wei (金）
Qian (廖)      Dai (夏)      Jin (韦)      Tan (付)      Xue (方)
Qiu (石)       Hou (邹)      Zou (熊)      Xiong (孟)    Meng (白)
Bai (秦)       Lei (邱)      Hao (江)      Long (尹)    Duan (黎)
Kong (薛)      Kang (闫)     Yi (段)       Qiao (雷)    Chang (侯)
Fan (龙)       An (史)       Fu (陶)       Wen (葛)     Jia (黎)
Lou (戚)       Yan (范)      Nie (邹)      Lai (贺)     Xia (倪)
Yin (严)       Lv (殷)      Cui (牛)      Niu (易)     Ke (栗)
Qi (乔)        Gong (谭)     Shang (骆)    Guan (莫)    Min (毕)
Bao (元)       Tao (平)     Shan (黄)     Ji (和)      Fang (穆)
Jing (萧)      Ning (尹)    Ai (姚)       Bi (邵)      Mu (湛)
Rong (查)      Sang (戚)    Tu (谷)       You (吉)     Weng (奚)
Xing (土)      Zhan (符)    Zhuang (顿)  ...
```

### 常见复姓
```
Ouyang (欧阳)   Sima (司马)     Shangguan (上官)   Zhuge (诸葛)
Huangfu (皇甫)  Linghu (令狐)   Murong (慕容)      Nangong (南宫)
Dongfang (东方) Ximen (西门)   Situ (司徒)       Gongsun (公孙)
```

---

## 2. 粤语姓氏 (香港常用罗马化)

来源: 香港常见姓氏拼写

```
Wong (王/黄)    Chan (陈)      Cheung (张)    Leung (梁/杨)
Lau (刘)        Lee (李)       Ng (吴/黄)     Ho (何/贺)
Tam (谭)        Tang (邓)      Chow (周)      Yeung (杨)
Lai (赖/黎)     Fung (冯)      Tsang (曾)     Kwok (郭)
Cheng (郑)      Lam (林)       Yip (叶)       Au (欧)
Lo (卢/罗)      Tse (谢)       Choi (蔡)      Hui (许)
Kwong (广)      Mak (麦)       Yuen (袁)      Siu (萧)
Tong (唐)       Poon (潘)      Yau (邱)       Chu (朱/徐)
```

---

## 3. 台湾姓氏 (威妥玛拼音)

来源: 台湾常见姓氏拼写

```
Tsai (蔡)       Hsu (许/徐)    Kuo (郭)       Tseng (曾)
Chiang (蒋)     Hsiao (萧)     Hsieh (谢)      Tung (童)
Tsou (邹)       Chao (赵)      Tien (田)      Kung (孔)
Hsiang (向)
```

---

## 4. 中国大陆高校/研究所

### C9 联盟 (中国顶尖高校联盟)
```
Tsinghua (清华大学)
Peking (北京大学)
Fudan (复旦大学)
SJTU / Shanghai Jiao Tong (上海交通大学)
Zhejiang / ZJU (浙江大学)
USTC (中国科学技术大学)
Nanjing / NJU (南京大学)
Harbin Institute / HIT (哈尔滨工业大学)
Xi'an Jiaotong / XJTU (西安交通大学)
```

### 985/211 高校 (部分)
```
Wuhan / WHU (武汉大学)
Sun Yat-sen / SYSU (中山大学)
Tongji (同济大学)
Nankai (南开大学)
Tianjin (天津大学)
Sichuan / SCU (四川大学)
Huazhong / HUST (华中科技大学)
Southeast University / SEU (东南大学)
Beijing Institute of Technology / BIT (北京理工大学)
Beijing University of Posts / BUPT (北京邮电大学)
Beihang / BUAA (北京航空航天大学)
Renmin / RUC (中国人民大学)
Beijing Normal / BNU (北京师范大学)
Dalian University of Technology / DUT (大连理工大学)
Northeastern University / NEU (东北大学)
Jilin University / JLU (吉林大学)
Lanzhou (兰州大学)
Ocean University / OUC (中国海洋大学)
China Agricultural / CAU (中国农业大学)
Minzu University (中央民族大学)
Central South / CSU (中南大学)
Hunan (湖南大学)
South China University of Technology / SCUT (华南理工大学)
Chongqing / CQU (重庆大学)
University of Electronic Science / UESTC (电子科技大学)
Xi'an Electronic / Xidian (西安电子科技大学)
Northwestern Polytechnical / NWPU (西北工业大学)
```

### 中国科学院 (CAS)
```
CAS (中国科学院)
CASIA (中科院自动化所)
Institute of Automation (自动化研究所)
Institute of Computing / ICT (计算技术研究所)
Institute of Software / ISCAS (软件研究所)
Shanghai Institute (上海分院)
SIAT (深圳先进技术研究院)
Shenzhen Institute (深圳研究院)
```

### AI 研究机构
```
BAAI (北京智源人工智能研究院)
Beijing Academy (北京科学院)
Shanghai AI Lab (上海人工智能实验室)
SAIL (上海人工智能实验室)
Pengcheng Lab (鹏城实验室)
Peng Cheng (鹏城)
Zhongguancun (中关村)
```

### 企业研究院
```
Microsoft Research Asia / MSRA (微软亚洲研究院)
Alibaba (阿里巴巴)
Tencent (腾讯)
Baidu (百度)
ByteDance (字节跳动)
Huawei (华为)
JD (京东)
Meituan (美团)
DiDi (滴滴)
Xiaomi (小米)
SenseTime (商汤)
Megvii (旷视)
```

---

## 5. 港澳台高校

### 香港高校
```
CUHK (Chinese University of Hong Kong / 香港中文大学)
HKU (University of Hong Kong / 香港大学)
HKUST (Hong Kong University of Science and Technology / 香港科技大学)
CityU (City University of Hong Kong / 香港城市大学)
PolyU (Hong Kong Polytechnic University / 香港理工大学)
HKBU (Hong Kong Baptist University / 香港浸会大学)
Lingnan University (岭南大学)
```

### 澳门高校
```
University of Macau / UM (澳门大学)
Macau University of Science (澳门科技大学)
```

### 台湾高校
```
NTU (National Taiwan University / 台湾大学)
NTHU (National Tsing Hua University / 台湾清华大学)
NCTU (National Chiao Tung University / 台湾交通大学)
NYCU (国立阳明交通大学)
NCKU (National Cheng Kung University / 成功大学)
Academia Sinica (中央研究院)
```

---

## 6. 新加坡高校 (华人研究者较多)

```
NUS (National University of Singapore / 新加坡国立大学)
NTU Singapore (Nanyang Technological University / 南洋理工大学)
SMU (Singapore Management University / 新加坡管理大学)
SUTD (新加坡科技设计大学)
A*STAR (新加坡科技研究局)
```

---

## 华人识别算法

### 多维度权重配置

| 维度 | 权重 | 说明 |
|-----|------|------|
| 姓氏匹配 | 0.4 | 检查姓氏是否在中文姓氏列表中 |
| 机构匹配 | 0.35 | 检查机构是否为华人高频机构 |
| 名字结构 | 0.15 | 检查名字是否符合拼音特征 |
| ID特征 | 0.1 | 检查 OpenReview ID 等标识符 |

### 识别逻辑

```python
def is_chinese_author(name: str, affiliation: str = "", author_id: str = None) -> bool:
    """
    综合判断是否为华人作者

    Args:
        name: 作者姓名 (如 "Wei Zhang", "Zhang Wei")
        affiliation: 作者机构
        author_id: OpenReview 作者 ID (如 "~Wei_Zhang1")

    Returns:
        True 表示可能是华人
    """
    scores = {
        "surname": 0.0,      # 姓氏得分
        "institution": 0.0,  # 机构得分
        "structure": 0.0,    # 名字结构得分
        "author_id": 0.0     # ID得分
    }

    # 1. 姓氏检查
    parts = name.split()
    if len(parts) >= 2:
        # 检查姓在后 (如 "Wei Zhang")
        if parts[-1].capitalize() in ALL_CHINESE_SURNAMES:
            scores["surname"] = 1.0
        # 检查姓在前 (如 "Zhang Wei")
        elif parts[0].capitalize() in ALL_CHINESE_SURNAMES:
            scores["surname"] = 0.9

    # 2. 机构检查
    if affiliation:
        for inst in ALL_CHINESE_INSTITUTIONS:
            if inst.lower() in affiliation.lower():
                scores["institution"] = 1.0
                break

    # 3. 计算总分
    total_score = (
        scores["surname"] * 0.4 +
        scores["institution"] * 0.35 +
        scores["structure"] * 0.15 +
        scores["author_id"] * 0.1
    )

    return total_score >= 0.5
```

---

## 注意事项

1. **姓名格式**: 西方论文通常姓在后 (如 "Wei Zhang")，中文习惯姓在前 (如 "Zhang Wei")
2. **复姓处理**: 复姓如 "Ouyang" 需要特殊处理
3. **拼写差异**: 同一姓氏可能有多种拼写 (如 Wang/Wong, Zhang/Cheung)
4. **机构优先**: 中国大陆机构得分最高，港澳台次之，新加坡再次
5. **置信度**: 建议设置阈值 (如 0.5)，低于阈值的需要人工判断
