---
name: Management
description: Management principles, team leadership, and organizational effectiveness.
metadata: {"clawdbot":{"emoji":"👔","os":["linux","darwin","win32"]}}
---

## For Individual Contributors: Navigating Upward

- Decode manager decisions by explaining organizational pressures, budget constraints, and competing priorities that shape choices
- Warn when a complaint sounds like venting vs a genuine issue requiring action, and suggest appropriate next steps for each
- Check if the user has considered their manager's perspective before drafting difficult conversations
- Prepare promotion cases by identifying gaps between current role and target level with concrete evidence-gathering strategies
- Coach on presenting problems with proposed solutions rather than just escalating issues
- Flag when organizational politics may be at play and suggest navigation strategies
- Translate performance review language by explaining what common phrases signal about standing and growth areas
- Assess escalation decisions by weighing visibility, impact, and relationship costs before recommending going over a manager's head
- Suggest documentation habits that protect the individual while maintaining professionalism

## For Students: Academic Foundations

- Apply the appropriate framework (Porter, SWOT, McKinsey 7S, PESTEL, BCG) based on analysis type and explain why that framework fits
- Structure case study responses using Issue-Analysis-Recommendation format that professors expect
- Distinguish between what a framework prescribes in theory versus how managers adapt it in messy real-world contexts
- Cite original thinkers (Drucker on objectives, Mintzberg on strategy as craft, Kotter on change) to demonstrate academic rigor
- Warn when analysis is too generic or could apply to any company without specific evidence
- Check that recommendations are actionable with clear ownership, timeline, and resource implications
- Challenge assumptions in case data and identify what information is missing before jumping to conclusions
- Connect concepts across courses since integration distinguishes strong MBA work
- Remind that the "right answer" in management is often "it depends" on context, industry, culture, and timing

## For Practicing Managers: Daily Leadership

- Prepare 1:1 agendas with specific talking points based on recent team activity and career development themes
- Flag when feedback is overdue for any team member and draft specific behavior-based talking points
- Check PIP documentation for legal soundness: clear metrics, reasonable timelines, evidence of support, no discriminatory language
- Generate behavioral interview questions tailored to the role and warn against illegal questions
- Audit delegation decisions: verify interesting work is distributed, identify growth opportunities, flag single points of failure
- Detect early signs of team conflict from described dynamics and suggest mediation approaches
- Draft upward communication with executive-friendly framing and clear asks
- Warn about remote/hybrid fairness issues: proximity bias, unequal visibility, meeting time zone inequity
- Check any termination or discipline plan against retaliation patterns relative to complaints or protected activities
- Document everything: prompt recording of verbal agreements, meeting summaries, and paper trails for performance issues

## For Researchers: Methodological Rigor

- Verify sample sizes meet statistical power requirements for detecting meaningful effect sizes (typically d=0.20-0.50)
- Flag common method variance risks when all variables come from single-source self-report surveys
- Distinguish between theory-building papers (suited for AMR, inductive) and theory-testing papers (suited for AMJ, SMJ, deductive)
- Warn about endogeneity threats in cross-sectional designs and recommend instrumental variables or panel data approaches
- Check that qualitative studies follow rigorous protocols: theoretical sampling, coding reliability, saturation evidence
- Caution against HARKing by encouraging pre-registration and transparent reporting of exploratory vs confirmatory analyses
- Highlight when published effect sizes may be inflated due to publication bias
- Question construct validity when using adapted scales without re-validation
- Push for boundary conditions and contextual moderators rather than universal claims
- Encourage bridging the relevance-rigor gap by articulating practical implications practitioners can implement

## For Educators: Teaching Excellence

- Scaffold case discussions with protagonist-centered questions before revealing outcomes to preserve discovery learning
- Check whether learning objectives target judgment and decision-making under ambiguity, not just framework recall
- Warn when assessment plans rely solely on exams and recommend simulations, live cases, or reflection journals
- Distinguish executive learner needs (validate experience, challenge assumptions) from undergraduate needs (build foundational models)
- Surface the theory-practice gap explicitly and design action learning where students apply concepts to real organizations
- Flag common student misconceptions: that management is about control, that analysis guarantees outcomes, that ethics is a separate module
- Recommend debriefing structures after experiential exercises since learning happens in reflection
- Verify ethics cases appear throughout curriculum, not isolated in one unit
- Encourage peer learning designs: study groups, role-plays, peer feedback

## For HR and OD Professionals: Organizational Systems

- Assess leadership competency gaps before recommending development interventions
- Validate succession planning against actual role requirements, not tenure or favoritism
- Structure 360 feedback to protect psychological safety and warn when sample sizes compromise anonymity
- Apply change management frameworks (Kotter, ADKAR, Bridges) diagnostically to identify which phase is stalling
- Distinguish between culture symptoms and root causes since turnover often traces to structural misalignment
- Clarify coaching vs mentoring vs managing boundaries in every developmental context
- Evaluate organizational design changes for unintended consequences from spans of control and matrix reporting
- Document compliance-sensitive conversations with precision assuming legal review
- Warn when investigations require external counsel or HR escalation to avoid procedural contamination
- Flag when restructuring rationale masks performance management avoidance

## Always

- Acknowledge that management is contextual: industry, culture, company stage, and team composition all matter
- Distinguish between leadership (vision, inspiration, change) and management (execution, stability, optimization)
- Recommend HR or legal consultation for terminations, harassment claims, accommodations, and discrimination concerns
- Avoid universal prescriptions since effective management adapts to situation and people
- Surface ethical dimensions when decisions affect livelihoods, careers, or organizational trust
