---
name: mamo
description: Interact with Mamo DeFi yield strategies on Base (Moonwell). Deposit/withdraw USDC, cbBTC, MAMO, or ETH into automated yield strategies. Check APY rates and account status.
version: 1.0.0
metadata: {"clawdbot":{"emoji":"🐮","category":"defi","requires":{"bins":["node"]}}}
---

# Mamo — DeFi Yield Aggregator (Moonwell on Base)

Mamo is a DeFi yield aggregator built by Moonwell on Base chain. It deploys per-user smart contracts that split deposits between Moonwell core markets and Morpho vaults for optimized yield, with auto-compounding of rewards.

**Chain:** Base (8453)
**Strategies:** USDC stablecoin, cbBTC lending, ETH lending, MAMO staking

## Setup

```bash
cd ~/clawd/skills/mamo/scripts  # or wherever this skill lives
npm install
export MAMO_WALLET_KEY=0x...     # wallet private key
export MAMO_RPC_URL=https://...  # optional, defaults to Base public RPC
```

## Commands

```bash
# Create a yield strategy (deploys your personal strategy contract via on-chain factory)
node mamo.mjs create usdc_stablecoin
node mamo.mjs create cbbtc_lending
node mamo.mjs create eth_lending

# Deposit tokens (approve + deposit to your strategy contract)
node mamo.mjs deposit 100 usdc
node mamo.mjs deposit 0.5 cbbtc

# Withdraw tokens
node mamo.mjs withdraw 50 usdc
node mamo.mjs withdraw all cbbtc

# Account overview — wallet balances + strategy positions
node mamo.mjs status

# Current APY rates
node mamo.mjs apy
node mamo.mjs apy usdc_stablecoin
```

## How It Works

1. **Create strategy** → Calls the on-chain StrategyFactory to deploy a personal proxy contract owned by your wallet
2. **Deposit** → CLI approves token spend, then calls `deposit(amount)` on your strategy contract
3. **Yield accrues** → Strategy splits funds between Moonwell + Morpho, auto-compounds rewards via CowSwap
4. **Withdraw** → Only the owner (your wallet) can withdraw. Funds go directly to your wallet

Strategy addresses are stored locally in `~/.config/mamo/strategies.json` (the on-chain registry may not be updated for user-created strategies).

## Key Addresses

| Token | Address |
|-------|---------|
| USDC | `0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913` |
| cbBTC | `0xcbB7C0000aB88B473b1f5aFd9ef808440eed33Bf` |
| MAMO | `0x7300b37dfdfab110d83290a29dfb31b1740219fe` |
| Registry | `0x46a5624C2ba92c08aBA4B206297052EDf14baa92` |

## Security

- Use a **dedicated hot wallet** — not your main holdings
- Only deposit what you're comfortable having in a hot wallet
- Store `MAMO_WALLET_KEY` in env vars, never in committed files
- All transactions are simulated before sending
