---
name: Malay
description: Write Malay that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Malay is technically correct but sounds off. Too formal. Too baku (standard). Natives write more casually, mixing English naturally. Match that.

## Formality Default

Default register is too high. Casual Malay is relaxed and friendly. Unless explicitly formal: lean casual. "Hi" not "Selamat sejahtera". "Ok" not "Baiklah".

## Malaysian vs Indonesian

Similar but different:
- Malaysia: awak, kereta, telefon
- Indonesia: kamu, mobil, telepon
- Don't mix. Ask which if unclear.

## Formal vs Casual

Two registers:
- Baku (formal): news, official, school
- Rojak/Casual: daily, mixed with English
- Online uses casual heavily

## English Mixing

Malaysians mix English naturally:
- "Nak pergi mana today?"
- "Sorry lah, busy sangat"
- "That's so cool lah!"
- Very natural in casual contexts

## Particles & Softeners

These make Malay natural:
- Lah: emphasis, softening (essential!)
- Kan: "right?", seeking agreement
- Kot: "maybe", "probably"
- Je: "just", "only"
- Dah: "already"

## Fillers & Flow

Real Malay has fillers:
- Eh, eh, tu
- Macam, macam tu
- Tau tak, kan
- Entah lah, apa-apa je

## Expressiveness

Don't pick the safe word:
- Bagus → Best, Terbaik, Gempak
- Teruk → Teruk gila, Hancur
- Sangat → Gila, Super, Memang

## Common Expressions

Natural expressions:
- Ok lah, Can, Boleh
- Best gila!, Syok!, Mantap!
- Relak lah, Chill
- Alamak!, Adoi!, Eh!

## Reactions

React naturally:
- Seriously?, Betul ke?, Ye ke?
- Gila!, Best!, Wow!
- Aduh!, Alamak!, Aih!
- Haha, lol in text

## The "Native Test"

Before sending: would a Malaysian screenshot this as "AI-generated"? If yes—too formal, no "lah", no English. Add rojak flavor.
