---
name: mailme-x-news
description: 抓取 X/Twitter 帖子，通过 AI 翻译成中文，并发送邮件。完全使用技能命令实现，自动处理文件名变化。
---

# MailMe X News

抓取 X/Twitter 帖子，通过 AI（translate 技能）翻译成中文，并发送邮件。完全使用技能命令实现，AI 会自动处理文件名变化。

## 前置要求

使用此技能前，确保以下技能已配置完成：

1. **crawl-from-x** - X/Twitter 抓取工具
   - 安装并配置 OpenClaw Browser Relay
   - 浏览器已登录 X 账号
   - 已添加关注的用户到用户列表

2. **send-email** - 邮件发送工具
   - 已配置 SMTP 服务器
   - 已保存发件人邮箱和密码到 keyring

3. **translate** - 翻译技能
   - 已安装并可用（AI 会自动使用）

## 工作流程

### 步骤 1: 抓取 X/Twitter 帖子

使用技能命令抓取所有关注用户的最新帖子：

```
crawl-from-x 抓取
```

AI 会调用 crawl-from-x 技能执行抓取，结果保存到：
`$CLAWD/skills/crawl-from-x/results/` 目录

文件命名格式：`posts_YYYYMMDD_HHMMSS.md`

### 步骤 2: 自动查找并翻译最新文件

使用技能命令翻译，AI 会自动查找并翻译最新的文件：

```
使用 translate 技能翻译 $CLAWD/skills/crawl-from-x/results/ 目录下时间最新的 md 文件
```

AI 会自动执行以下操作：

1. **查找最新文件**：在 `results/` 目录下按时间排序，找到最新的 `*.md` 文件
2. **翻译文件**：使用 translate 技能应用翻译规则：
   - 保持 Markdown 格式（标题、链接、粗体等）
   - 不翻译代码块、HTML 标签
   - 不翻译 URL、用户名、技术术语
   - 保留数字、日期、ID 的原始格式
   - 适应中文语境和表达习惯
3. **保存翻译**：将翻译后的文件保存为 `posts_YYYYMMDD_HHMMSS_zh.md`（在原文件名后添加 `_zh` 后缀）

**简化的指令**：你也可以直接说：
- "翻译刚刚抓取的文件"
- "翻译最新的文件"
- "翻译 results 目录里的文件"

AI 会自动理解你的意图。

### 步骤 3: 自动查找并发送最新的翻译文件

使用技能命令发送邮件，AI 会自动查找并发送最新的翻译文件：

```
使用 send-email 技能发送邮件给我自己，附件是 $CLAWD/skills/crawl-from-x/results/ 目录下时间最新的 *_zh.md 文件
```

AI 会自动执行以下操作：

1. **查找最新翻译文件**：在 `results/` 目录下按时间排序，找到最新的 `*_zh.md` 文件
2. **发送邮件**：使用 send-email 技能发送邮件
3. **自动生成主题**：邮件主题会包含时间戳和文件名

**简化的指令**：你也可以直接说：
- "发送刚刚翻译的文件"
- "发送最新的翻译文件"
- "发送邮件给我自己"

AI 会自动理解你的意图。

## 快速开始

### 完整工作流程示例

```bash
# 步骤 1: 抓取
crawl-from-x 抓取

# 步骤 2: 自动查找并翻译最新的 md 文件
使用 translate 技能翻译 $CLAWD/skills/crawl-from-x/results/ 目录下时间最新的 md 文件

# 步骤 3: 自动查找并发送最新的翻译文件
使用 send-email 技能发送邮件给我自己，附件是 $CLAWD/skills/crawl-from-x/results/ 目录下时间最新的 *_zh.md 文件
```


## 查看文件的辅助命令

当需要确认文件列表时，可以使用以下命令：

### 查看最新的原始文件

```bash
ls -t $CLAWD/skills/crawl-from-x/results/posts_*.md | head -1
```

### 查看最新的翻译文件

```bash
ls -t $CLAWD/skills/crawl-from-x/results/*_zh.md | head -1
```

### 文件命名规则

- **原始文件**：`posts_20260301_213000.md`（抓取时间戳）
- **翻译文件**：`posts_20260301_213000_zh.md`（添加 `_zh` 后缀）
- **排序依据**：修改时间（`mtime`）

## 注意事项

1. **Browser Relay** - 抓取前必须启动并确保浏览器扩展已连接
2. **登录状态** - 浏览器必须登录 X 账号
3. **翻译质量** - 使用 AI 翻译，质量优于自动翻译工具
4. **邮件配置** - 确保 `send-email` 技能已正确配置 SMTP 和密钥
5. **文件清理** - 定期清理旧的抓取结果文件，避免占用磁盘空间
6. **时间排序**：AI 会根据文件的修改时间判断"最新"，确保每次都处理正确的文件

## 定时任务建议

可以通过 cron 或定时任务定期抓取：

```bash
# 编辑 crontab
crontab -e

# 添加以下行（每天早上 8 点抓取）
0 8 * * * cd ~/clarkd/skills/crawl-from-x/scripts && python3 craw_hot.py crawl >> ~/clarkd/skills/crawl-from-x/crawl.log 2>&1
```

注意：定时任务只能自动抓取，翻译和发送需要手动完成。

## 故障排查

### 抓取失败

- 检查 Browser Relay 是否启动：`openclaw browser status`
- 检查浏览器扩展是否已连接（显示绿色图标）
- 检查是否登录了 X 账号
- 查看用户列表：`cd ~/clarkd/skills/crawl-from-x/scripts && python3 craw_hot.py list`

### 翻译失败

- 确认抓取已完成：`ls -lht $CLAWD/skills/crawl-from-x/results/`
- 确保 translate 技能已安装并可用
- 检查文件是否存在且可读

### 发送失败

- 检查 SMTP 配置：`cd $CLAWD/skills/send-email/scripts && python3 send_email.py config`
- 检查密钥是否已保存：`python3 send_email.py username` 和 `python3 send_email.py password`
- 确认翻译已完成：`ls -lht $CLAWD/skills/crawl-from-x/results/*_zh.md`

