# Mailbox CLI (OpenClaw Skill)

Use the mailbox CLI as a tool to read and manage email. OpenClaw handles
channel delivery and scheduling. The mailbox CLI returns structured JSON
outputs and optional text summaries.

## Requirements
- mailbox CLI installed (`npm install -g mailbox-cli`)
- Credentials in `~/.config/mailbox/auth.json`

## Commands (examples)
- `mailbox account list --json`
- `mailbox email list --limit 20 --json`
- `mailbox email show <email_uid> --account-id <account_id> --json`
- `mailbox email show <email_uid> --account-id <account_id> --preview --no-html --json`
- `mailbox email show <email_uid> --account-id <account_id> --preview --no-html --strip-urls --json`
- `mailbox email delete <email_uid> --account-id <account_id> --folder INBOX --confirm --json`
- `mailbox digest run --json`
- `mailbox monitor run --json`
- `mailbox inbox --limit 15 --text`

## Safety rules
- Always use `--json` for automation and check `success`.
- Include `--account-id` for destructive operations.
- Destructive operations default to dry-run unless `--confirm` is provided.
- Prefer `--dry-run` before mutating when available.

## Output contract
- JSON response includes `success` and `error` fields.
- `error` is an object with `{ code, message, detail? }`.
- Exit codes: 0 success, 1 operation failed, 2 invalid usage.
