---
name: Mail
slug: mail
version: 1.2.0
description: Execute email operations with platform-specific optimizations and secure credential handling.
changelog: Added explicit scope, requirements, and data access documentation
metadata: {"clawdbot":{"emoji":"📧","requires":{"bins":["himalaya"]},"os":["darwin","linux"]}}
---

## Requirements

**Binaries:**
- `himalaya` - IMAP/SMTP CLI (`brew install himalaya` or `cargo install himalaya`)
- `osascript` - macOS only, built-in

**Credentials:**
- App Password for Gmail (not regular password), stored in macOS Keychain
- Configure in `~/.config/himalaya/config.toml`

## Data Access

**Read-only paths:**
- `~/Library/Mail/V*/MailData/Envelope Index` - Apple Mail SQLite database (macOS only)
- `~/Library/Mail/V*/MAILBOX/Messages/` - attachment files (macOS only)

## Scope

This skill:
- ✅ Reads email via himalaya CLI or Apple Mail SQLite
- ✅ Sends email via himalaya (draft-review-send workflow)
- ✅ Searches and filters messages
- ❌ NEVER modifies credentials
- ❌ NEVER deletes emails without explicit confirmation
- ❌ NEVER auto-sends without user review

## Quick Reference

| Topic | File |
|-------|------|
| Apple Mail SQLite queries | `apple-mail.md` |
| himalaya CLI patterns | `himalaya.md` |
| Send/reply protocol | `sending.md` |

## Core Rules

### 1. Platform Detection
- **macOS with Apple Mail**: Use SQLite queries (100x faster than AppleScript)
- **Cross-platform**: Use himalaya CLI for full IMAP/SMTP
- **Never mix approaches** in same task - commit to one to avoid state conflicts

### 2. Apple Mail SQLite
- Query path: `~/Library/Mail/V*/MailData/Envelope\ Index`
- **Force sync first**: `osascript -e 'tell app "Mail" to check for new mail'` - SQLite reads stale data otherwise
- Recent mail filter: `WHERE date_received > strftime('%s','now','-7 days')`
- Join `messages→addresses` on `message_id` for sender lookup

### 3. himalaya CLI
- **Always use**: `--output json` flag for programmatic parsing
- List emails: `himalaya envelope list -o json` (NOT `message list`)
- Folder names are case-sensitive
- Run `himalaya folder list` after server-side folder changes

### 4. Send Protocol
- **Draft-review-send workflow**: Compose → show user full content → send after explicit OK
- Reply threading: Include `In-Reply-To` and `References` headers or thread breaks
- Some SMTP servers reject if From header doesn't match authenticated user

### 5. Credential Management
- macOS Keychain: `security add-internet-password -s imap.gmail.com -a user@gmail.com -w 'app-password'`
- Gmail/Google Workspace: Requires App Password with 2FA enabled
- OAuth: himalaya supports XOAUTH2 via token_cmd in config.toml

### 6. Thread Intelligence
- Thread by `In-Reply-To` chain, not subject matching
- "Re:" prefix is unreliable
- Polling intervals: 15-30 min max; use `himalaya envelope watch` for real-time
