# 📧 mail-client

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](LICENSE)
[![OpenClaw Skill](https://img.shields.io/badge/OpenClaw-skill-blue)](https://openclaw.dev)
[![ClawHub](https://img.shields.io/badge/ClawHub-mail--client-green)](https://clawhub.dev/skills/Romain-Grosos/mail-client)

OpenClaw skill for reading and sending email via standard IMAP and SMTP servers.
Python stdlib only - zero external dependencies.

## Features

- Read and list messages via IMAP SSL
- Search messages with flexible criteria (sender, subject, date, text, unseen)
- Send email via SMTP STARTTLS (plain text + HTML)
- Move, delete, mark read/unread
- List folders and check quota
- All capabilities **disabled by default** - explicit opt-in required

## Install

```bash
clawhub install mail-client
```

Or clone manually:

```bash
git clone https://github.com/Rwx-G/openclaw-skill-mail-client.git skills/mail-client
cd skills/mail-client
python3 scripts/setup.py
```

## Quick start

```bash
# 1. Run interactive setup (creates credentials + config)
python3 scripts/setup.py

# 2. Validate setup
python3 scripts/init.py

# 3. Use the CLI
python3 scripts/mail.py list --limit 5
python3 scripts/mail.py read 42
python3 scripts/mail.py send --to alice@example.com --subject "Hello" --body "Hi Alice"
```

## Configuration

All capabilities are **false by default**. Edit `config.json` (generated by `setup.py`)
to enable what the agent is allowed to do:

```json
{
  "allow_send": false,
  "allow_read": false,
  "allow_search": false,
  "allow_delete": false,
  "smtp_port": 587,
  "imap_port": 993,
  "mail_from": "",
  "default_folder": "INBOX",
  "max_results": 20
}
```

> Note: `config.json` is NOT shipped in this repository (it is gitignored).
> Copy `config.example.json` as a starting template and edit as needed.

## Credentials

Credentials are stored in `~/.openclaw/secrets/mail_creds` (chmod 600), never in the skill directory.
See [SKILL.md](SKILL.md) section "Storage and credentials" for details.

## Security

- Python stdlib only: `imaplib`, `smtplib`, `email`, `json`, `os`, `sys`, `pathlib`
- TLS/SSL enabled by default (IMAP4_SSL + STARTTLS)
- All capabilities false by default
- Credentials isolated from skill directory with strict permissions
- No external HTTP calls

## License

MIT - Copyright (c) 2026 Romain Grosos
