# 宏观数据指标科普

## 通胀指标

### CPI (消费者物价指数)
**是什么**：衡量一篮子消费品和服务价格变化的指标，反映普通家庭的生活成本变化。

**为什么重要**：
- 央行制定货币政策的核心参考
- CPI上涨过快→通胀压力→央行可能加息
- CPI过低甚至负值→通缩风险→央行可能降息

**怎么看**：
- 2%左右通常被认为是健康水平
- >3%：通胀压力较大
- <1%：内需疲软，经济偏冷

### PPI (生产者物价指数)
**是什么**：衡量工业企业产品出厂价格变化的指数。

**为什么重要**：
- CPI的先行指标（PPI上涨会传导到CPI）
- 反映企业生产成本和工业景气度

**怎么看**：
- PPI上涨→企业成本增加→可能推高CPI
- PPI持续为负→工业通缩，企业利润承压

## 经济景气指标

### PMI (采购经理指数)
**是什么**：通过对采购经理的问卷调查，综合反映制造业/非制造业景气状况。

**为什么重要**：
- 经济运行的"温度计"
- 50是分界线：>50扩张，<50收缩

**怎么看**：
- 制造业PMI >50：工厂订单增加，生产扩张
- PMI持续走低：经济下行压力增大

### GDP (国内生产总值)
**是什么**：一个国家或地区在一定时期内生产的所有最终产品和服务的市场价值。

**为什么重要**：
- 衡量经济规模和增长速度的核心指标
- 政府制定经济政策的重要依据

**怎么看**：
- 年增长率5-6%：中国等新兴经济体健康水平
- 年增长率2-3%：发达经济体健康水平
- 负增长：经济衰退

## 就业指标

### 失业率
**是什么**：失业人口占劳动人口的百分比。

**为什么重要**：
- 反映就业市场健康程度
- 影响消费能力和经济稳定

**怎么看**：
- 4-5%：通常被认为是充分就业
- >6%：就业市场疲软
- <3.5%：劳动力市场过热，可能推高工资通胀

## 货币政策指标

### LPR (贷款市场报价利率)
**是什么**：银行对最优质客户执行的贷款利率，其他贷款利率在此基础上加减点形成。

**为什么重要**：
- 中国的基准贷款利率
- 影响房贷、企业贷款成本

**怎么看**：
- LPR下调→贷款利息减少→刺激投资和消费
- LPR上调→贷款利息增加→抑制过热

### MLF (中期借贷便利)
**是什么**：央行向商业银行提供中期基础货币的货币政策工具。

**为什么重要**：
- 央行投放流动性的主要渠道
- MLF利率是LPR的定价基础

**怎么看**：
- MLF利率下调→通常带动LPR下调
- MLF操作量增加→央行在投放流动性

## 市场指标

### 十年期国债收益率
**是什么**：政府发行的10年期债券的年化收益率。

**为什么重要**：
- 无风险利率的基准
- 反映市场对经济和通胀的预期

**怎么看**：
- 收益率上升→预期经济增长或通胀上升
- 收益率下降→预期经济放缓或通缩
- 收益率曲线倒挂（短期>长期）：经济衰退信号

## 使用建议

在报告中，首次提到某个指标时，添加简短解释：

```
- 中国 1月 CPI: 0.2% (预期0.4%)
  💡 CPI衡量消费者物价变化，反映通胀水平。0.2%低于预期，显示内需疲软。
```

对于重要指标变化，可以添加更详细的解读：
- 超预期：为什么超预期？对市场有什么影响？
- 低于预期：反映了什么问题？政策可能如何应对？
