---
name: macos-screenshot-telegram
description: |
  Take a screenshot on macOS and send it to Telegram. Use when the user asks to capture their screen, take a screenshot, or send a screen capture to Telegram. 
  Works around OpenClaw's message tool bug (#15541) that fails to send media.
---

# Setup (Prerequisites)

## 1. Telegram Bot Token

1. 搵 @BotFather on Telegram
2.  Send `/newbot` 創建新 bot
3. 拎個 bot token（好似 `1234567890:ABCdefGHIjklMNOpqrsTUVwxyz`）

## 2. 搵 Telegram Chat ID

- **個人 ID:** 搵 @userinfobot 或者 forward message 俾 @userinfobot
- **Group ID:** Forward 任何 message 俾 @userinfobot

## 3. OpenClaw Config

響你既 OpenClaw profile config 度加入：

```json
{
  "telegram": {
    "botToken": "YOUR_BOT_TOKEN_HERE",
    "allowFrom": ["YOUR_CHAT_ID"]
  }
}
```

## 4. Profile Naming

記住你用既 profile 名（例如 `main`、`rescue`），之後用既時候補返上去。

---

# macOS Screenshot to Telegram

This skill captures the macOS screen and sends it directly via Telegram Bot API.

## Workflow

1. **Capture screenshot** using macOS built-in command:
   ```bash
   /usr/sbin/screencapture -x <output-path>
   ```

2. **Copy to workspace** (required - OpenClaw has security restriction):
   ```bash
   cp <source> <workspace>/screenshot.png
   ```

3. **Send via Telegram Bot API** (bypasses buggy message tool):
   ```bash
   BOT_TOKEN=$(grep botToken <config-path> | sed 's/.*"botToken": *"\([^"]*\)".*/\1/')
   curl -s -X POST "https://api.telegram.org/bot${BOT_TOKEN}/sendPhoto" \
     -F "chat_id=<target-chat-id>" \
     -F "photo=@<workspace>/screenshot.png"
   ```

## Required Parameters

When using this skill, ask the user for:
- `target-chat-id`: The Telegram chat ID to send to (e.g., user's ID for DM)
- `profile`: The OpenClaw profile name (e.g., "main", "rescue")

## How to Find Paths

1. **Config file:** `~/.openclaw-<profile>/openclaw.json`
2. **Workspace:** `~/.openclaw/workspace-<profile>/`

For example, if your profile is "main", paths would be:
- Config: `~/.openclaw-main/openclaw.json`
- Workspace: `~/.openclaw/workspace-main/`

## Notes

- The `message` tool in OpenClaw has a bug (#15541) that returns success but doesn't send media
- Always use curl with Telegram Bot API directly for reliable media delivery
- The screenshot must be copied to workspace first due to OpenClaw's allowed directory security restriction
- This skill is profile-agnostic - just pass the correct profile name
