---
name: mac-notes-agent
description: |
  Integrate with the macOS Notes app (Apple Notes).
  Supports creating, listing, reading, updating, deleting, and searching notes
  via a simple Node.js CLI that bridges to AppleScript.
version: 1.1.0
author: swancho
license: CC-BY-NC-4.0
repository: https://github.com/swancho/mac-memo-agent
metadata:
  openclaw:
    emoji: "📝"
---

# Mac Notes Agent

## Overview

This skill lets the agent talk to **Apple Notes** on macOS using AppleScript
(via `osascript`). It is implemented as a small Node.js CLI:

```bash
node skills/mac-notes-agent/cli.js <command> [options]
```

> Requires macOS with the built-in **Notes** app and `osascript` available.

All operations target the **default Notes account**. Optionally you can specify
which folder to use.

---

## Commands

### 1) Add a new note

```bash
node skills/mac-notes-agent/cli.js add \
  --title "Meeting notes" \
  --body "First line\nSecond line\nThird line" \
  [--folder "Jarvis"]
```

- `--title` (required): Note title
- `--body` (required): Note body text. Use `\n` for line breaks.
- `--folder` (optional): Folder name. If omitted, uses system default folder. If folder doesn't exist, it will be created.

> Line breaks (`\n`) are converted to `<br>` tags internally for proper rendering in Notes.

**Result (JSON):**

```json
{
  "status": "ok",
  "id": "Jarvis::2026-02-09T08:40:00::Meeting notes",
  "title": "Meeting notes",
  "folder": "Jarvis"
}
```

---

### 2) List notes

```bash
node skills/mac-notes-agent/cli.js list [--folder "Jarvis"] [--limit 50]
```

- Lists notes in the given folder (or all folders if omitted).
- Output is JSON array with `title`, `folder`, `creationDate`, and synthetic `id`.

---

### 3) Read a note (get)

```bash
# By folder + title
node skills/mac-notes-agent/cli.js get \
  --folder "Jarvis" \
  --title "Meeting notes"

# By synthetic id
node skills/mac-notes-agent/cli.js get --id "Jarvis::2026-02-09T08:40:00::Meeting notes"
```

---

### 4) Update a note (replace body)

```bash
node skills/mac-notes-agent/cli.js update \
  --folder "Jarvis" \
  --title "Meeting notes" \
  --body "New content\nReplaces everything"
```

- Replaces the entire body of the matching note.
- Can also use `--id` for identification.

---

### 5) Append to a note

```bash
node skills/mac-notes-agent/cli.js append \
  --folder "Jarvis" \
  --title "Meeting notes" \
  --body "\n---\nAdditional notes here"
```

- Appends new content to the end of the existing note.

---

### 6) Delete a note

```bash
node skills/mac-notes-agent/cli.js delete \
  --folder "Jarvis" \
  --title "Meeting notes"
```

---

### 7) Search notes

```bash
node skills/mac-notes-agent/cli.js search \
  --query "keyword" \
  [--folder "Jarvis"] \
  [--limit 20]
```

- Searches note titles and bodies for the keyword.

---

## Identification Model

Apple Notes doesn't expose stable IDs. This CLI uses:

- Primary key: `(folderName, title)`
- Synthetic ID: `folderName::creationDate::title`

When multiple notes share the same title, the CLI operates on the most recently created one.

---

## Environment

- **macOS only**: Uses AppleScript via `osascript`
- **No npm dependencies**: Uses only Node.js built-ins (`child_process`)
