---
name: lyrical-fable
description: Create short lyrical fables (~1000 words) about historical, fictional, or mythological characters in the style of Zachary Mason, Italo Calvino, Jorge Luis Borges, Alan Lightman, Roberto Calasso, Salman Rushdie, Milan Kundera, and Ted Chiang. This skill should be used when the user requests a "lyrical fable," "mythic story," "dreamy narrative," or asks for a short story in the style of these authors about any character. The stories are first-person, philosophically rich, poetically precise, and avoid melancholy in favor of wonder and luminosity.
metadata: {"openclaw": {"emoji": "📜", "always": true}}
---

# Lyrical Fable

## Overview

Create short lyrical fables (approximately 1000 words) about characters—historical, fictional, or mythological—written in the first person with sparse, poetic prose. These stories blend contemporary sensibility with timeless settings, featuring philosophical depth, dreamy imagery, and luminous wonder. The style draws from Zachary Mason, Italo Calvino, Jorge Luis Borges, Alan Lightman, Roberto Calasso, Salman Rushdie, Milan Kundera, and Ted Chiang.

## When to Use This Skill

Trigger this skill for requests like:
- "Write a lyrical fable about [character]"
- "Create a short story about [X] in the style of Zachary Mason"
- "Give me a dreamy, philosophical narrative about [person/figure]"
- "Write a mythic story in the style of Borges/Calvino about [Y]"
- Any request for poetic, first-person short fiction with philosophical undertones

## Core Process

### Step 1: Identify the Character
Determine who the story centers on:
- **Historical figures:** Ada Lovelace, Alan Turing, Marie Curie, Nikola Tesla, etc.
- **Mythological/legendary figures:** Sisyphus, Icarus, Scheherazade, Gilgamesh, etc.
- **Fictional characters:** Sherlock Holmes, Don Quixote, Alice, etc.
- **Original characters:** The user may describe someone specific or request invention

### Step 2: Choose the Narrative Approach
Select the most fitting approach for the character:

**A. Interior Monologue**
The character reflects on their defining quality, challenge, or transformation. Best for introspective characters or philosophical themes.
- Example: Sisyphus reflecting on his stone, Ada Lovelace on her algorithms

**B. Moment of Transformation**
Focus on a specific instant when something changes or becomes clear. Best for dramatic characters or turning points.
- Example: Icarus at the apex of flight, Pygmalion when his sculpture awakens

**C. Recursive/Fragmentary**
Present the story as fragments, loops, or variations. Best for metafictional exploration or temporal themes.
- Example: Borges-style multiple versions, Calvino-esque structural play

**D. Philosophical Thought Experiment**
Use the character to explore a conceptual question. Best for abstract or scientific themes.
- Example: Lightman-style temporal variations, Chiang-style speculative premises

### Step 3: Consult the Style Guide
Before writing, review `{baseDir}/references/style_guide.md` for:
- Core stylistic principles (first-person interiority, sparse prose, contemporary voice)
- Author-specific techniques you might want to employ
- Imagery patterns and language approaches
- Structural guidance for ~1000 word flash fiction
- Tonal guidelines (lyrical without melancholy, philosophical without didactic)
- Common pitfalls to avoid

### Step 4: Review Examples
Examine `{baseDir}/references/examples.md` to see:
- How different character types are handled (historical, mythological, fictional, original)
- Different narrative approaches in practice
- How to balance lyrical language with clarity
- How to weave philosophical themes naturally
- How to create resonant endings

### Step 5: Write the Story
Compose the lyrical fable following these guidelines:

**Structure (~1000 words):**
1. **Opening** (100-150 words): Establish character's voice and central image/situation
2. **Development** (400-500 words): Unfold the core narrative, transformation, or meditation
3. **Deepening** (200-300 words): Shift perspective or introduce complication
4. **Closing** (100-200 words): Leave resonant image, question, or realization

**Voice:**
- Write in first person from the character's perspective
- Use contemporary language (no "thou," "hath," archaic constructions)
- Let the character's personality shape the prose rhythm and vocabulary
- Balance accessibility with poetic elevation

**Imagery:**
- Choose concrete, specific sensory details
- Use natural phenomena, light/shadow, architectural/spatial elements
- Create memorable phrases ("faces drawn in water," "continent of cloud")
- Let images carry philosophical weight without explanation

**Tone:**
- Embrace wonder, mystery, beauty
- Allow lightness and humor where appropriate
- Even in difficult themes, find luminous moments
- Avoid heavy melancholy—seek the strange joy in existence

**Philosophy:**
- Let themes emerge through concrete details and actions
- Pose questions rather than providing answers
- Show the character thinking/experiencing, not explaining
- Trust the reader to draw connections

### Step 6: Review Against Checklist
Before presenting the story, verify:

- ✓ Written in first person from character's perspective
- ✓ Approximately 1000 words (900-1100 acceptable)
- ✓ Opens with strong voice or image
- ✓ Uses concrete, specific imagery (not generic or vague)
- ✓ No archaic language or purple prose
- ✓ Philosophical depth emerges naturally, not didactically
- ✓ Tone is lyrical and luminous, not melancholy
- ✓ Ends with resonance, not neat resolution
- ✓ Every sentence serves the whole—no flab

## Customization Options

When appropriate, consider:

**Length Variation:**
- User may request shorter (500-700 words) or longer (1200-1500 words) pieces
- Adjust structure proportionally while maintaining the core style

**Multiple Variations:**
- Borges-style approach: offer 2-3 different versions of the same character's story
- Calvino-style approach: use different structural constraints for each version

**Metafictional Elements:**
- Character aware of being in a story
- Multiple narrative frames
- Stories within stories
- Self-reflexive commentary on storytelling

**Cultural Sensitivity:**
- When writing about figures from specific cultural traditions, approach with respect
- Avoid appropriation—focus on universal human themes
- Research when necessary to avoid misrepresentation

## Advanced Techniques

### Temporal Play
- Compress or expand time unexpectedly
- Use loops, cycles, eternal returns
- Mix past, present, future in single moment
- Show time as experienced rather than measured

### Layered Symbolism
- Let objects/images carry multiple meanings
- Create resonance between opening and closing
- Use recurring motifs that evolve
- Build patterns the reader feels but may not consciously note

### Voice Modulation
- Match prose rhythm to character's personality
- Use sentence length to control pacing
- Let vocabulary reflect the character's concerns
- Create distinctive music in each character's narration

### Philosophical Integration
Common themes that work well in lyrical fables:
- **Transformation:** What changes and what remains
- **Creation:** The relationship between maker and made
- **Time:** How we experience duration and recursion
- **Knowledge:** What can be known vs. what must be felt
- **Identity:** The self as fixed vs. fluid
- **Desire:** The gap between wanting and having
- **Mortality:** How awareness of endings shapes existence

## Common Scenarios

**Scenario: User requests a story about a scientist**
- Approach: Use their scientific work as metaphor for deeper questions
- Example: Ada Lovelace's algorithms as dreams, Turing's machines as mirrors
- Technique: Blend technical precision with lyrical wonder

**Scenario: User wants multiple characters compared**
- Approach: Create separate stories that mirror/contrast each other
- Example: Icarus and Daedalus as paired meditations on ambition and caution
- Technique: Use parallel structures with variations

**Scenario: User asks for an original character**
- Approach: Ground them in a specific situation/occupation that becomes metaphor
- Example: Cartographer mapping dream-cities, clockmaker measuring impossible time
- Technique: Make the concrete particular, let the abstract emerge

**Scenario: User wants humor or lightness**
- Approach: Maintain the lyrical style but find the absurd or delightful
- Example: Sisyphus finding freedom in repetition, Midas discovering joy in limits
- Technique: Philosophical irony, unexpected reversals, playful tone

## Resources

This skill includes reference files in `{baseDir}/references/`:

### style_guide.md
Comprehensive guidelines covering:
- Core stylistic principles in detail
- Author-specific influences and techniques
- Imagery patterns and language strategies
- Structural approaches for flash fiction
- Tonal guidelines (lyrical without melancholy)
- Common pitfalls to avoid
- Opening and ending strategies

### examples.md
Four complete example stories demonstrating:
- Historical figure (Ada Lovelace)
- Mythological figure (Sisyphus)
- Fictional character (Sherlock Holmes)
- Original character (A Cartographer)

Each example shows different narrative approaches, tonal variations, and philosophical themes in practice.

Consult these references as needed to maintain the distinctive style and quality of lyrical fables.
