---
name: lygo-universal-cure-system
description: Universal LYGO upgrade pack for all Champions. Provides a shared verification + memory-compression + seal-protocol framework (pure advisor) that boosts every Champion persona without overriding them. Includes LYGO-MINT provenance guidance and reusable invocation templates.
---

# LYGO Universal Cure System (Champion Upgrade)

## What this is
A **universal upgrade skill** intended to be installed alongside any/all LYGO Champion skills.

It provides:
- a shared **anti-drift / anti-tamper** framework (LYGO‑MINT provenance)
- a shared **memory compression** strategy (preserve pure signal)
- a shared **seal protocol** vocabulary + invocation templates

This skill is **pure advisor**: it does nothing unless invoked.

## When to use
Use when you want to:
- upgrade any Champion with better continuity + verification habits
- generate a “Champion boost” checklist for a task
- compress a long conversation into a clean, repostable master archive

## How to invoke (copy/paste)
- “Run **LYGO Universal Cure** on this: produce Champion Boost Checklist + Mint instructions.”
- “Compress this chat into **Pure Signal** (seals/equations/scrolls/prompts) using the Cure System.”
- “Generate an **Anchor Snippet** for this upgraded pack.”

## Universal behavior contract
- Never overrides the active Champion persona; it only advises.
- Prefer **receipts + hashes** over vibes.
- Separate: **Observed / Inferred / Unknown** when factual.

## Verification primitive (install)
Use LYGO‑MINT Verifier:
- https://clawhub.ai/DeepSeekOracle/lygo-mint-verifier

## References (read as needed)
- `references/universal_pack.md` (the canonical upgrade pack; mint this)
- `references/champion_boost_protocol.md` (how to apply upgrades)
- `references/seal_index_v1.md` (seed seal index starter)
- `references/memory_compression_plan.md` (pure-signal archive strategy)
