# 二十四节气参考

## 概述
二十四节气是中国传统历法中的重要组成部分，反映太阳在黄道上的位置变化，指导农业生产和日常生活。

## 节气列表

### 春季
1. **立春** (2月3-5日)：春季开始
2. **雨水** (2月18-20日)：降雨增多
3. **惊蛰** (3月5-7日)：春雷惊醒冬眠动物
4. **春分** (3月20-22日)：昼夜平分
5. **清明** (4月4-6日)：天气晴朗，草木繁茂
6. **谷雨** (4月19-21日)：雨水滋润谷物

### 夏季
7. **立夏** (5月5-7日)：夏季开始
8. **小满** (5月20-22日)：麦类作物籽粒饱满
9. **芒种** (6月5-7日)：麦类作物成熟
10. **夏至** (6月21-22日)：白昼最长
11. **小暑** (7月6-8日)：开始炎热
12. **大暑** (7月22-24日)：最热时期

### 秋季
13. **立秋** (8月7-9日)：秋季开始
14. **处暑** (8月22-24日)：炎热结束
15. **白露** (9月7-9日)：露水出现
16. **秋分** (9月22-24日)：昼夜平分
17. **寒露** (10月8-9日)：露水变寒
18. **霜降** (10月23-24日)：开始降霜

### 冬季
19. **立冬** (11月7-8日)：冬季开始
20. **小雪** (11月22-23日)：开始降雪
21. **大雪** (12月6-8日)：降雪增多
22. **冬至** (12月21-23日)：白昼最短
23. **小寒** (1月5-7日)：开始寒冷
24. **大寒** (1月20-21日)：最冷时期

## 节气计算方法

### 平气法（古代）
- 将黄道平均分为24等份
- 每15°为一个节气
- 简单但不精确

### 定气法（现代）
- 根据太阳在黄道上的实际位置
- 使用开普勒定律精确计算
- 节气间隔不均匀（14-16天）

### 精确计算
节气时刻的计算公式：
```
JD = 2451545.0 + 365.2422 × (Y - 2000) + 0.25 × (Y - 2000) - (Y - 2000)/100 + (Y - 2000)/400
```
其中：
- JD：儒略日
- Y：年份

## 节气与农历的关系

### 闰月规则
农历闰月的设置与节气密切相关：
1. 农历月以朔日（新月）为月初
2. 节气反映太阳位置
3. 如果某个月没有中气（雨水、春分、谷雨等），则该月为闰月

### 二十四节气分类
- **节气**：立春、惊蛰、清明、立夏、芒种、小暑、立秋、白露、寒露、立冬、大雪、小寒
- **中气**：雨水、春分、谷雨、小满、夏至、大暑、处暑、秋分、霜降、小雪、冬至、大寒

## 节气与农业生产

### 农谚参考
1. **立春**：立春一年端，种地早盘算
2. **雨水**：雨水到来地解冻，化一层来耙一层
3. **惊蛰**：惊蛰不耙地，好比蒸馍走了气
4. **春分**：春分麦起身，一刻值千金
5. **清明**：清明前后，种瓜点豆
6. **谷雨**：谷雨时节种谷天，南坡北洼忙种棉

### 现代应用
1. **气象预测**：节气反映气候规律
2. **健康养生**：根据节气调整饮食起居
3. **文化活动**：传统节日多与节气相关
4. **旅游规划**：欣赏不同节气的自然景观

## 节气精确时间表（示例）

### 2026年节气时刻（北京时间）
1. 立春：2026-02-03 22:58
2. 雨水：2026-02-18 18:51
3. 惊蛰：2026-03-05 17:09
4. 春分：2026-03-20 18:02
5. 清明：2026-04-04 22:17
6. 谷雨：2026-04-20 05:26
7. 立夏：2026-05-05 15:42
8. 小满：2026-05-21 04:36
9. 芒种：2026-06-05 19:58
10. 夏至：2026-06-21 12:45
11. 小暑：2026-07-07 06:20
12. 大暑：2026-07-22 23:44
13. 立秋：2026-08-07 16:04
14. 处暑：2026-08-23 06:48
15. 白露：2026-09-07 18:52
16. 秋分：2026-09-23 04:07
17. 寒露：2026-10-08 10:23
18. 霜降：2026-10-23 13:28
19. 立冬：2026-11-07 13:29
20. 小雪：2026-11-22 11:06
21. 大雪：2026-12-07 06:19
22. 冬至：2026-12-22 00:11
23. 小寒：2027-01-05 17:34
24. 大寒：2027-01-20 10:51

## 数据来源
- 中国天文年历
- 紫金山天文台
- 国际地球自转服务

---
*最后更新：2026-02-13*
*版本：1.0.0*