# 农历生日提醒系统 - 专业农历计算系统

![版本](https://img.shields.io/badge/版本-v0.9.0-blue)
![Python](https://img.shields.io/badge/Python-3.6%2B-green)
![授权](https://img.shields.io/badge/授权-MIT-lightgrey)
![作者](https://img.shields.io/badge/作者-夏暮辞青-orange)

## 🌟 项目简介

**农历生日提醒系统**是一个基于专业农历计算库的农历计算系统，提供公历与农历之间的精确转换。当前版本v0.9.0为参考版本，已通过多个关键日期验证，计算结果与华为手机等数据源一致。

## 🎯 核心特性

### ✅ 已验证功能
- **专业库集成**: 使用lunardate专业农历计算库
- **双向转换**: 公历↔农历精确转换
- **已知验证**: 5个春节日期100%准确验证
- **一致性**: 与华为手机数据一致

### 📊 验证示例
| 农历日期 | 公历日期 | 验证状态 |
|---------|---------|---------|
| 2037年九月初五 | 2037-10-13 | ✅ 与华为手机一致 |
| 2026年春节 | 2026-02-17 | ✅ 已验证 |
| 2025年春节 | 2025-01-29 | ✅ 已验证 |
| 2024年春节 | 2024-02-10 | ✅ 已验证 |

## 🚀 快速开始

### 安装
```bash
# 克隆仓库
git clone https://github.com/xiamuciqing/lunar-birthday-reminder.git
cd lunar-birthday-reminder

# 安装依赖
pip install lunardate cnlunar
```

### 基本使用
```python
# 公历转农历
python scripts/lunar_calculator.py --solar 2026-02-17

# 农历转公历
python scripts/lunar_calculator.py --lunar "2037-09-05"

# 运行演示
python scripts/demo_lunar.py

# 验证系统
python scripts/simple_validator.py
```

### 在OpenClaw中使用
当用户询问以下内容时自动激活：
- "农历"、"阴历"、"黄历"、"宜忌"
- "干支"、"生肖"、"节气"
- "春节日期"、"闰月"等

## 📁 项目结构

```
lunar-birthday-reminder/
├── SKILL.md                    # OpenClaw技能元数据
├── README.md                   # 项目文档
├── package.json               # 项目配置
├── RELEASE_v0.9.0.md          # 发布说明
├── scripts/
│   ├── lunar_calculator.py    # 农历计算核心
│   ├── validate_lunar.py      # 验证脚本
│   ├── simple_validator.py    # 简化验证
│   ├── demo_lunar.py          # 演示脚本
│   └── publish.sh             # 发布脚本
├── references/
│   ├── fortune_rules.md       # 黄历宜忌规则
│   └── solar_terms.md         # 二十四节气参考
└── tests/                     # 测试用例
```

## 🔧 技术细节

### 依赖要求
- **Python**: 3.6+
- **核心库**: lunardate, cnlunar
- **内存**: 至少100MB
- **系统**: Linux/macOS/Windows (WSL)

### 性能指标
- **计算速度**: < 10ms/次
- **准确率**: 已知日期100%验证通过
- **支持年限**: 1900-2100年
- **内存使用**: < 50MB

## 🧪 测试验证

### 已通过测试
1. ✅ 2022-2026年春节日期验证
2. ✅ 2037年九月初五计算验证
3. ✅ 公历转农历双向验证
4. ✅ 专业库计算结果一致性

### 测试方法
```bash
# 运行完整验证
python scripts/validate_lunar.py

# 运行简化验证
python scripts/simple_validator.py

# 查看验证结果
cat validation_result.txt
```

## 📈 开发路线

### v0.9.0 (当前)
- 基础功能实现
- 专业库集成
- 社区反馈收集

### v1.0.0-alpha (进行中)
- 集成权威数据源
- 扩展测试覆盖
- 改进错误处理

### v1.0.0 (目标)
- 国家权威数据确认
- 1900-2100年100%准确
- 正式发布

## 🤝 贡献指南

### 如何贡献
1. **测试验证**: 测试更多日期并报告结果
2. **数据提供**: 提供权威农历数据参考
3. **代码改进**: 提交Pull Request改进代码
4. **文档完善**: 帮助完善文档和示例

### 反馈渠道
- **GitHub Issues**: 问题报告和功能建议
- **数据校正**: 报告计算差异
- **功能请求**: 提出新功能建议

## ⚠️ 重要声明

### 版本说明
- **当前版本**: v0.9.0参考版本
- **数据源**: 基于lunardate专业库
- **权威性**: 等待国家权威机构数据确认
- **建议用途**: 参考使用，重要日期请多方验证

### 使用限制
- 需要Python环境支持
- 依赖外部库的准确性
- 未集成国家权威数据源
- 部分高级功能待完善

## 📞 支持与联系

### 项目信息
- **作者**: 夏暮辞青
- **目标**: 打造国家权威级农历计算系统
- **原则**: 透明开发，社区参与，追求准确

### 联系方式
- **GitHub**: [xiamuciqing](https://github.com/xiamuciqing)
- **问题反馈**: [GitHub Issues](https://github.com/xiamuciqing/lunar-birthday-reminder/issues)
- **讨论交流**: 小龙虾社区

## 📄 许可证

本项目采用 MIT 许可证 - 查看 [LICENSE](LICENSE) 文件了解详情。

## 🙏 致谢

感谢所有参与测试和反馈的用户，特别感谢：
- **华为手机农历数据** 提供参考验证
- **lunardate/cnlunar库** 开发者
- **OpenClaw社区** 提供平台支持
- **所有贡献者** 的宝贵贡献

---

**农历生日提醒系统 - 让农历计算更精准！**

*如果觉得这个项目有用，请给个⭐️支持！*