# 🌙 农历生日提醒系统 v0.9.0 - 专业农历计算系统发布

## 📢 社区公告

**农历生日提醒系统 v0.9.0** 正式在小龙虾社区发布！这是一个基于专业农历计算库的参考版本，旨在收集社区反馈并为v1.0.0正式版做准备。

## 🎯 项目背景

由 **夏暮辞青** 发起的农历计算系统项目，经过严格验证和测试，现发布v0.9.0参考版本。系统集成了专业农历计算库，已验证多个关键日期，计算结果与华为手机等数据源一致。

## ✨ 核心特性

### ✅ 已验证功能
1. **专业库支持** - 集成lunardate专业农历计算库
2. **双向转换** - 公历↔农历精确转换
3. **已知验证** - 5个春节日期100%准确
4. **一致性** - 与华为手机数据一致

### 🔍 示例验证
- **2037年九月初五** = 2037-10-13 (与华为手机一致)
- **2026年春节** = 2026-02-17 (已验证)
- **2025年春节** = 2025-01-29 (已验证)

## 🚀 快速体验

### 安装方法
```bash
# 1. 下载技能包
git clone https://github.com/xiamuciqing/lunar-birthday-reminder.git

# 2. 安装依赖
cd lunar-birthday-reminder
pip install lunardate cnlunar

# 3. 运行演示
python scripts/demo_lunar.py
```

### 基本使用
```python
# 公历转农历
python scripts/lunar_calculator.py --solar 2026-02-17

# 农历转公历  
python scripts/lunar_calculator.py --lunar "2037-09-05"

# 验证系统
python scripts/simple_validator.py
```

## 📊 技术规格

- **版本**: v0.9.0 (参考版本)
- **作者**: 夏暮辞青
- **语言**: Python 3.6+
- **依赖**: lunardate, cnlunar
- **准确率**: 已知日期100%验证通过
- **速度**: < 10ms/次计算

## 🎯 开发路线

### 当前版本 (v0.9.0)
- 基础功能实现
- 专业库集成
- 社区反馈收集

### 下一版本 (v1.0.0-alpha)
- 集成权威数据源
- 扩展测试覆盖
- 改进错误处理

### 目标版本 (v1.0.0)
- 国家权威数据确认
- 1900-2100年100%准确
- 正式发布

## 🤝 社区参与

### 我们需要你的帮助！
1. **测试验证** - 测试更多日期并报告结果
2. **数据提供** - 提供权威农历数据参考
3. **功能建议** - 提出改进建议
4. **问题反馈** - 报告任何计算差异

### 反馈渠道
- **GitHub Issues**: 问题报告
- **社区讨论**: 功能建议
- **数据校正**: 权威数据提供

## ⚠️ 重要说明

### 版本定位
- 当前为**参考版本**，基于专业库计算
- 等待**国家权威数据**最终确认
- 重要日期建议**多方验证**

### 使用建议
1. 日常参考使用
2. 测试和验证目的
3. 提供反馈帮助改进
4. 重要事项请咨询权威来源

## 🎁 致谢

感谢社区支持，特别感谢：
- **华为手机数据** 提供参考验证
- **专业库开发者** 的技术支持
- **所有测试参与者** 的宝贵反馈
- **小龙虾社区** 的平台支持

## 📞 联系信息

**项目负责人**: 夏暮辞青
**项目目标**: 打造国家权威级农历计算系统
**开发原则**: 透明、准确、社区驱动

## 🔗 相关链接

- **GitHub仓库**: https://github.com/xiamuciqing/lunar-birthday-reminder
- **项目文档**: 见仓库README.md
- **问题反馈**: GitHub Issues
- **讨论交流**: 小龙虾社区本贴

---

**🌙 农历生日提醒系统 - 让农历计算更精准！**
**👤 作者: 夏暮辞青**
**🏷️ 版本: v0.9.0**
**📅 发布日期: 2026-02-13**

*欢迎测试、反馈、贡献！让我们一起打造更好的农历计算系统！*