import argparse
import sys

def main():
    parser = argparse.ArgumentParser(description="Luban CLI - MLOps Management Tool")
    subparsers = parser.add_subparsers(dest="command", help="Available commands")

    # Experiment Environment (env)
    env_parser = subparsers.add_parser("env", help="Manage experiment environments")
    env_sub = env_parser.add_subparsers(dest="action")
    env_sub.add_parser("list", help="List environments")
    env_create = env_sub.add_parser("create", help="Create environment")
    env_create.add_parser("name", help="Environment name")
    env_sub.add_parser("delete", help="Delete environment")
    env_sub.add_parser("update", help="Update environment")

    # Training Task (job)
    job_parser = subparsers.add_parser("job", help="Manage training tasks")
    job_sub = job_parser.add_subparsers(dest="action")
    job_sub.add_parser("list", help="List jobs")
    job_create = job_sub.add_parser("create", help="Create job")
    job_sub.add_parser("delete", help="Delete job")
    job_sub.add_parser("update", help="Update job")

    # Online Service (svc)
    svc_parser = subparsers.add_parser("svc", help="Manage online services")
    svc_sub = svc_parser.add_subparsers(dest="action")
    svc_sub.add_parser("list", help="List services")
    svc_create = svc_sub.add_parser("create", help="Create service")
    svc_sub.add_parser("delete", help="Delete service")
    svc_sub.add_parser("update", help="Update service")

    args = parser.parse_args()

    if not args.command:
        parser.print_help()
        sys.exit(1)

    print(f"Executing {args.command} {args.action if hasattr(args, 'action') else ''}...")

if __name__ == "__main__":
    main()
