# Luban CLI MLOps Management Guide

This guide outlines the core entities and operations for the Luban CLI.

## Core Entities

### 1. Experiment Environment (`env`)
Used for managing development and experimentation environments (e.g., Jupyter notebooks, dev containers).
- **Operations**: `list`, `create`, `delete`, `update`, `get`.
- **Key Attributes**: `name`, `image`, `resource_config` (CPU/GPU/Mem).

### 2. Training Task (`job`)
Used for managing asynchronous model training workloads.
- **Operations**: `list`, `create`, `delete`, `update`, `stop`, `logs`.
- **Key Attributes**: `job_id`, `script_path`, `hyperparameters`, `output_path`.

### 3. Online Service (`svc`)
Used for managing model inference services.
- **Operations**: `list`, `create`, `delete`, `update`, `scale`, `status`.
- **Key Attributes**: `service_name`, `model_version`, `endpoint`, `replicas`.

## Command Structure Pattern
The CLI follows a `<entity> <action> [args]` pattern:
- `luban env create --name my-env`
- `luban job list`
- `luban svc delete --id svc-123`
