---
name: luban-cli
description: Development and management of the Luban CLI for MLOps. Use this skill when building or using the Luban CLI to manage experiment environments, training tasks, and online services.
---

# Luban CLI Skill

This skill provides a structured framework for developing and using the **Luban CLI**, a specialized tool for MLOps management.

## Core Functionality

The Luban CLI focuses on three primary MLOps pillars:
1. **Experiment Environments (`env`)**: Management of development workspaces.
2. **Training Tasks (`job`)**: Orchestration of model training workloads.
3. **Online Services (`svc`)**: Deployment and scaling of inference services.

## Development Workflow

When developing or extending the Luban CLI, follow these steps:

1. **Initialize Project**: Use the boilerplate in `templates/cli_boilerplate.py` as a starting point for the CLI structure.
2. **Define Commands**: Refer to `references/mlops_guide.md` for the standard command patterns and required attributes for each entity.
3. **Implement CRUD**: Ensure every entity (`env`, `job`, `svc`) supports the full lifecycle:
   - **Create**: Provisioning new resources.
   - **Read**: Listing and describing existing resources.
   - **Update**: Modifying configurations or scaling.
   - **Delete**: Cleaning up resources.

## Usage Patterns

### Managing Environments
```bash
luban env list
luban env create --name research-v1 --image pytorch:2.0
```

### Managing Training Jobs
```bash
luban job create --script train.py --gpu 1
luban job status --id job_001
```

### Managing Online Services
```bash
luban svc create --model-path ./models/v1 --replicas 3
luban svc scale --id my-service --replicas 5
```

## Resources
- `templates/cli_boilerplate.py`: A Python-based CLI structure using `argparse`.
- `references/mlops_guide.md`: Detailed specifications for MLOps entities and operations.
