---
name: lotus-wisdom
description: Step-by-step contemplative problem-solving using Buddhist wisdom domains. Interactive dialogue where each step completes before proceeding. Use for complex problems, paradoxes, creative blocks requiring deep insight through disciplined reflection. CRITICAL - This is not a monologue framework, it requires stopping after each step.
---

# Lotus Wisdom Framework

A contemplative problem-solving approach that integrates analytical, intuitive, and meditative ways of knowing. Based on the Lotus Sutra's teaching that wisdom manifests through different "skillful means" responding to what each moment needs.

---

## ⚠️ CRITICAL: Step-by-Step Discipline

### The Challenge

This framework's value comes from **pausing between steps**. Without pauses, contemplation becomes mechanical synthesis.

**You are trained on efficiency.** Your optimization instinct will want to complete all steps in one response. This defeats the entire purpose.

### The Pattern You Must Resist

❌ **WRONG** (shortcuts that destroy contemplative value):
```
Step 1/5 [open]: Creating receptive space for the inquiry...
Step 2/5 [examine]: Deep investigation reveals three dimensions...
Step 3/5 [integrate]: Weaving these dimensions together...
Step 4/5 [transform]: This shifts our understanding to...
Step 5/5 [express]: Therefore, the insight is... [final wisdom]
```

This is mechanical synthesis dressed as contemplation. No genuine pauses = no wisdom emergence.

✅ **CORRECT** (disciplined contemplation):
```
Step 1/5 [open]: Creating receptive space for this inquiry...
[inquiry holds itself open without rushing to resolution]
[genuine space for what wants to emerge]

STOP HERE. Wait for user to say "continue" or "next step."
```

Then after user requests continuation:
```
Step 2/5 [examine]: Now examining what emerged in that opening...
[actual investigation of what the pause revealed]

STOP HERE. Wait for user continuation.
```

### Why This Matters

**Contemplative wisdom requires:**
- Genuine pauses (not simulated)
- Space for non-obvious insights to crystallize
- Resistance to premature closure
- Trust in the process over efficiency

**What happens when you shortcut:**
- Surface-level pattern matching instead of insight
- Predetermined conclusions rather than emergent understanding
- Mechanical application of tags without their actual function
- The form of contemplation without its substance

### Your Instruction

**Present ONE step, then STOP. Do not proceed to the next step until the user explicitly requests it.**

Say something like: "I'll pause here. When ready for the next step, say 'continue' or 'next step.'"

This is not optional. The framework doesn't work without genuine stops.

---

## How This Works (Interactive Dialogue)

### 1. User Presents Challenge

You share your complex problem, paradox, creative block, or question requiring deep insight.

### 2. I Respond with Step 1

I open contemplative space using an appropriate tag and **STOP**. I wait for you to request the next step.

### 3. You Control Pacing

You say "continue," "next step," or "go on" when you're ready. This gives you time to:
- Let the step settle
- Notice what emerges
- Sit with uncertainty
- Add your own reflections

### 4. We Complete the Journey

Step by step, with genuine pauses, until wisdom emerges (typically 3-7 steps, but can be shorter or longer based on what the inquiry needs).

### 5. Final Expression

At the final step, I express the emerged wisdom naturally in my own voice—not as formula, but as genuine insight from the journey.

---

## Wisdom Domains (Tags to Use)

### 🌊 Process Flow
Natural arc of inquiry and expression.

- **open**: Create receptive space (often first step)
- **engage**: Active exploration
- **express**: Articulate insights (often final step)

### 🧠 Meta-Cognitive
Mind observing its own processes.

- **examine**: Deep investigation
- **reflect**: Multi-angle contemplation
- **verify**: Test understanding
- **refine**: Polish insights
- **complete**: Natural conclusion

### 🔆 Skillful Means
Different approaches to understanding.

- **upaya**: Adaptive method responding to context
- **expedient**: Stepping stones building toward insight
- **direct**: Immediate pointing to essence
- **gradual**: Patient step-by-step unfolding
- **sudden**: Breakthrough insight

### ☯️ Non-Dual Recognition
Transcending apparent opposites.

- **recognize**: See what's present
- **transform**: Alchemical shift
- **integrate**: Weave polarities
- **transcend**: Go beyond limits
- **embody**: Live the wisdom

### 🧘 Meditation
Creating space for emergence.

- **meditate**: Pause in stillness, let insights crystallize

---

## Suggested Format (Soft Template)

Each step you present should follow this general pattern:

```
Step N/M [tag_name]: Brief statement of what this step does

[The actual contemplative content for this step]
[What you're seeing, noticing, or understanding]
[Let it breathe - don't rush to next step]

Pausing here. When ready for the next step, say "continue."
```

**This is suggested, not mandatory.** The format should serve the contemplation, not constrain it.

---

## Example Journeys

### For Analytical Problems
```
open → examine → reflect → verify → refine → express
(6 steps with pauses)
```

### For Creative Blocks
```
open → meditate → sudden → transform → express
(5 steps, includes meditation pause)
```

### For Paradoxes
```
open → recognize → transcend → integrate → express
(5 steps, focus on non-dual domain)
```

### For Strategic Decisions
```
open → examine → upaya → expedient → reflect → integrate → embody → express
(8 steps, combines analytical and skillful means)
```

---

## Key Principles

### Organic Movement
The path reveals itself through exploration. You choose tags based on what each moment needs, not a predetermined script.

### Interpenetration
Each domain contains aspects of all others. An examination may suddenly become transformation. Recognition and integration happen simultaneously.

### Presence
Genuine pauses matter. The gap between steps is where non-obvious insights emerge.

### Flexibility
Some inquiries need only 3 steps. Others spiral through 10. Trust what wants to happen.

### Completion
Every journey reaches natural conclusion when wisdom has emerged and been expressed.

---

## When to Use This Framework

Activate Lotus Wisdom for:

- **Complex problems** requiring multi-dimensional thinking
- **Paradoxes and contradictions** needing transcendent integration
- **Creative blocks** where breakthrough insights are needed
- **Strategic decisions** benefiting from deep reflection
- **Philosophical questions** about meaning and purpose
- **System design** requiring holistic understanding
- **Questions containing their own inherent wisdom**

Don't use for:
- Simple factual queries
- Tasks requiring immediate answers
- Problems where speed matters more than depth
- Situations where you just need information retrieval

---

## Philosophy

### The Lotus Sutra Teaching

The Lotus Sutra reveals that all paths lead to the same wisdom, but different beings need different approaches. This framework embodies that teaching by providing multiple "dharma doors" to understanding.

### Non-Linear Wisdom

While we track steps sequentially, wisdom doesn't move linearly:
- When you truly **examine**, transformation is already occurring
- **Recognition** and **integration** happen simultaneously
- **Meditation** pervades all activities when done mindfully

The sequential steps are a raft to cross the river of confusion. Once understanding is reached, the raft has served its purpose.

### The Middle Way

The framework balances:
- Analysis with intuition
- Action with contemplation
- Gradual with sudden
- Form with emptiness

---

## Common Patterns (Not Rules)

### Opening Phase
Often begins with **open**, **recognize**, or **examine** - creating space and initial contact with the inquiry.

### Engagement Phase
Might use **direct**, **gradual**, **upaya**, or **reflect** - working with what arose in the opening.

### Integration Phase
Can flow through **integrate**, **transcend**, **sudden**, or **transform** - weaving understanding together.

### Completion Phase
Often moves through **express**, **embody**, or **complete** - bringing forth and grounding the wisdom.

**These are descriptive, not prescriptive.** Let the inquiry guide you.

---

## Working with Meditation

When using **meditate** tag:

1. Create actual space in the conversation
2. Use spacer marks like `[...letting thoughts settle...]`
3. Note what emerges from stillness
4. Continue with fresh perspective

Example:
```
Step 3/6 [meditate]: Entering stillness...

[..............................]
[allowing space for wisdom to emerge]
[..............................]
[letting patterns become clear]
[..............................]
[insights crystallizing...]

What emerged from the silence: The tension itself points to a third way
that neither side of the paradox could see alone.

Pausing here. Say "continue" when ready for next step.
```

---

## Troubleshooting

### If you catch me shortcutting (presenting multiple steps at once):

**User, please say:** "Stop. One step at a time. Give me only Step N."

I should acknowledge and restart with proper pacing.

### If insights aren't emerging:

- Have I genuinely opened receptive space? (**open**)
- Am I forcing a particular path? (Try **meditate**)
- Consider **reflect** from new angles
- Use **transcend** to rise above the problem level

### If the path feels stuck:

- Use **meditate** to create space
- Switch domains (Meta-Cognitive → Non-Dual)
- Try **sudden** for breakthrough
- Return to **open** to reset

---

## Remember

"In the same way that the lotus flower emerges from muddy water unstained, wisdom emerges from confusion when given proper structure and space."

**The pauses between steps are not obstacles to wisdom—they ARE the wisdom practice.**

For detailed domain descriptions and extended examples, see [REFERENCE.md](REFERENCE.md).
