# Visitor Tips — Los Angeles

Practical advice for getting the most out of LA.

---

## Before You Go

### What to Book Ahead

| Attraction | How Far Ahead |
|------------|---------------|
| **The Broad** | 2-4 weeks (free tix release schedule) |
| **Getty Villa** | 1-2 weeks |
| **Universal Studios** | 1 week (for best prices) |
| **Disneyland** | 2+ weeks (can sell out) |
| **Popular restaurants** | 1-4 weeks on Resy |
| **Warner Bros Tour** | 1 week |

### What to Download

| App | Purpose |
|-----|---------|
| **Waze** | Navigation (better than Google Maps for traffic) |
| **Google Maps** | General, transit |
| **Uber/Lyft** | Rideshare |
| **Resy/OpenTable** | Restaurant reservations |
| **SpotHero** | Parking deals |
| **Eater LA** | Food recommendations |

### What to Pack

| Item | Why |
|------|-----|
| **Layers** | Morning fog, warm afternoons |
| **Sunscreen** | UV is strong |
| **Comfortable walking shoes** | Despite driving, you'll walk |
| **Light jacket** | Evenings cool (60s) |
| **Sunglasses** | Bright sun |
| **Reusable water bottle** | Stay hydrated |

---

## Getting Around

### The Car Question

| Situation | Rent a Car? |
|-----------|-------------|
| **1-2 days, beach only** | No, Uber + walking |
| **3+ days, seeing everything** | Yes |
| **Disneyland + LA** | Yes |
| **DTLA + Santa Monica only** | Maybe (Metro E Line works) |

### Rental Tips
- Book ahead for best prices
- Get GPS or use phone
- Add all drivers to insurance
- Fill gas before returning (they charge premium)
- Take photos of car condition

### Parking Reality
- **Budget:** $10-30/day
- **Meters:** Use ParkMobile app
- **Hotel:** Often $25-50/night extra
- **Free:** Some residential areas, far from attractions

### Uber/Lyft Reality
- $20-50 for most rides
- Surge during rush hour, events
- Schedule airport pickups
- Lyft often cheaper in LA

---

## Best Times to Visit

### By Month

| Months | Weather | Crowds | Events |
|--------|---------|--------|--------|
| **Jan-Feb** | Mild, some rain | Low | Award season |
| **Mar-Apr** | Pleasant | Medium | Spring break |
| **May-Jun** | June Gloom coast | Medium | |
| **Jul-Aug** | Warm, clear | High | Summer crowds |
| **Sep-Oct** | Best weather | Medium | LA Film Fest |
| **Nov-Dec** | Mild, some rain | High (holidays) | Hollywood Christmas |

**Best overall:** September-October (warm, clear, fewer crowds)

---

## Money-Saving Tips

### Free Attractions
- All beaches
- Griffith Observatory
- Getty Center + Getty Villa
- The Broad (book ahead)
- Hiking trails
- Farmers markets (window shop)

### Museum Free Days
| Museum | Free When |
|--------|-----------|
| **LACMA** | Second Tuesday |
| **Hammer** | Always free |
| **California Science Center** | Always free |
| **Natural History** | First Tuesday |

### Food Savings
- Taco trucks > sit-down Mexican
- Grand Central Market for variety
- Avoid tourist trap restaurants
- Happy hours (common 4-7pm)
- Hotel breakfasts are overpriced

### Entertainment Savings
- TodayTix for theatre
- GroupOn for attractions (sometimes)
- Library card = free museum passes (for residents)

---

## Safety Tips

### General
- Keep valuables out of car (even trunk)
- Be aware of surroundings at night
- Stick to well-lit, populated areas
- Tourist areas are generally safe

### Car Safety
- Don't leave ANYTHING visible
- Empty trunk before parking at trailheads
- Park in well-lit areas
- Use garages when possible

### Beach Safety
- Rip currents are real
- Lifeguards = swim there
- Don't leave valuables on beach
- Apply sunscreen (you will burn)

---

## Local Etiquette

### Driving
- Use turn signals
- Don't honk excessively
- Let people merge
- Road rage is real — stay calm
- Pedestrians have right of way

### Dining
- Reservations for popular spots
- Tipping: 18-22% standard
- Casual dress is fine almost everywhere
- Outside seating = dog-friendly often

### Social
- Casual is the vibe
- Nobody cares about celebrities (don't stare)
- "The industry" = entertainment
- Traffic is an acceptable excuse for lateness

---

## Common Mistakes

### 1. Underestimating Distances
LA is 50+ miles across. You can't "pop over" to different areas.

### 2. Not Reserving Popular Attractions
The Broad, Getty Villa, popular restaurants — book ahead.

### 3. Spending Time on Hollywood Blvd
It's disappointing. See it for 20 minutes and leave.

### 4. Expecting Good Weather Always
June Gloom is real at the coast May-July.

### 5. Trying to Do Too Much
Pick an area each day, don't zigzag across the city.

### 6. Driving at Rush Hour
Avoid 7-10am and 4-8pm on freeways.

### 7. Leaving Things in Your Car
They will get stolen, especially at trailheads and tourist spots.

---

## Day Trips from LA

### 1-2 Hours

| Destination | Time | Highlights |
|-------------|------|------------|
| **Malibu** | 45-60 min | Beaches, PCH, seafood |
| **San Diego** | 2 hrs | Zoo, beaches, Gaslamp |
| **Santa Barbara** | 1.5 hrs | Wine country, beach town |
| **Big Bear** | 2 hrs | Mountain escape, skiing (winter) |
| **Laguna Beach** | 1.5 hrs | Art galleries, coves |

### Half-Day Trips

| Destination | Time | Highlights |
|-------------|------|------------|
| **Joshua Tree** | 2.5 hrs | Desert, rock formations, stars |
| **Palm Springs** | 2 hrs | Desert resort, architecture |
| **Temecula Wine Country** | 1.5 hrs | Wine tasting |

### Tips
- Leave early (beat traffic)
- Joshua Tree = bring water, food
- Palm Springs = hot in summer
- PCH to Malibu = beautiful but slow

---

## Seasonal Events

| Event | When | Notes |
|-------|------|-------|
| **Rose Parade** | Jan 1 | Pasadena, book WAY ahead |
| **Oscars** | Feb-Mar | Hollywood, road closures |
| **Coachella** | April | 2 hrs to Indio, book months ahead |
| **Pride** | June | West Hollywood |
| **Hollywood Bowl season** | Jun-Sep | Outdoor concerts |
| **LA County Fair** | Sep | Pomona |
| **Día de los Muertos** | Nov 1-2 | Olvera Street, Hollywood Forever |
| **Holiday Lights** | Dec | Various neighborhoods |

---

## If You Only Have Time For...

### One Museum
**The Broad** — Free, contemporary, infinity room

### One Hike
**Griffith Observatory** — Views + Hollywood sign

### One Beach
**Santa Monica** — Pier, walkable, classic

### One Food Experience
**Street tacos** — Any good truck, $2-4/taco

### One Neighborhood Walk
**Venice Canals** — Quiet, beautiful, free
