# Where to Stay — Los Angeles

Location matters hugely in LA. Pick based on your priorities.

---

## Quick Decision

| Priority | Stay In |
|----------|---------|
| **Beach + walking** | Santa Monica |
| **Hollywood sights** | West Hollywood |
| **Central to everything** | DTLA or Mid-Wilshire |
| **Budget** | Koreatown |
| **Quiet/Upscale** | Beverly Hills |
| **Near Universal** | Studio City |
| **Near Disneyland** | Anaheim (not LA) |

---

## Best Areas for Tourists

### Santa Monica
**Best for:** Beach lovers, walkability, first-timers

| Pros | Cons |
|------|------|
| Beach access | Far from Hollywood/DTLA |
| Walkable | Expensive |
| Great food/shops | June Gloom (fog May-July) |
| Safe | Tourist-heavy |

**Price Range:** $200-500/night
**Hotels:** Shutters, Casa del Mar (luxury); Shore Hotel, Viceroy (mid); HI Santa Monica (hostel)

### West Hollywood
**Best for:** Nightlife, central location, LGBTQ+ travelers

| Pros | Cons |
|------|------|
| Central to Hollywood | No beach |
| Great nightlife | Can be loud |
| Walkable on Santa Monica Blvd | Traffic |
| Safe | Parking difficult |

**Price Range:** $200-450/night
**Hotels:** Sunset Marquis, Mondrian (design); Chamberlain (boutique); Best Western Plus (value)

### DTLA
**Best for:** Urban vibe, museums, foodies

| Pros | Cons |
|------|------|
| Museums nearby | Safety varies by block |
| Arts District cool | Some areas dead at night |
| Metro access | Far from beach |
| Interesting architecture | Can feel gritty |

**Price Range:** $150-400/night
**Hotels:** Ace Hotel, The Standard (hip); InterContinental (business); Freehand (budget)

### Beverly Hills
**Best for:** Luxury, quiet, older travelers

| Pros | Cons |
|------|------|
| Ultra-safe | Expensive |
| Beautiful | Need car |
| Rodeo Drive shopping | Not much nightlife |
| Great restaurants | Far from beach |

**Price Range:** $400-1,000+/night
**Hotels:** Beverly Wilshire, Peninsula, Waldorf Astoria (luxury); Sixty Beverly Hills (design)

### Mid-Wilshire (Miracle Mile)
**Best for:** Museums, central, value

| Pros | Cons |
|------|------|
| LACMA, The Broad nearby | Not walkable beyond museums |
| Central location | Nondescript |
| Good value | Need car |
| Less touristy | Limited dining walking distance |

**Price Range:** $150-300/night
**Hotels:** Kimpton La Peer, The Line (design); various chains

---

## Budget Options

### Hostels
| Name | Location | Price |
|------|----------|-------|
| **HI Santa Monica** | Santa Monica | $40-80 |
| **Samesun Venice** | Venice | $40-70 |
| **Freehand LA** | DTLA | $50-100 (private rooms higher) |
| **Banana Bungalow** | Hollywood | $35-60 |

### Motels (Basic but Cheap)
- **Hollywood:** Various on Sunset (research carefully)
- **Airport area:** Many budget options near LAX
- **Valley:** Cheaper than central LA

### Airbnb Reality
- Good value for groups
- Whole apartments often better than hotels
- Check parking situation
- Beware of party house restrictions

---

## Luxury Options

### Top Hotels
| Hotel | Area | Price |
|-------|------|-------|
| **Shutters on the Beach** | Santa Monica | $600-1,200 |
| **Beverly Wilshire** | Beverly Hills | $700-1,500 |
| **The Peninsula** | Beverly Hills | $800-1,800 |
| **Chateau Marmont** | West Hollywood | $500-1,000 |
| **Sunset Tower** | West Hollywood | $500-900 |
| **The Standard Hollywood** | West Hollywood | $300-500 |

### Unique Stays
| Hotel | Why |
|-------|-----|
| **Chateau Marmont** | Old Hollywood glamour, celebrity history |
| **The Line** | Koreatown, design-forward |
| **Ace Hotel DTLA** | Hipster landmark, rooftop pool |
| **Hotel Bel-Air** | Ultra-exclusive, nature setting |
| **Malibu Beach Inn** | On the sand, PCH escape |

---

## By Interest

### For Theme Park Visits
| Park | Stay In |
|------|---------|
| **Universal Studios** | Studio City, Burbank, Universal City |
| **Disneyland** | Anaheim (not LA proper, 1+ hr) |

**For Disneyland:** Stay in Anaheim area, not LA. Drive back and forth doesn't make sense.

### For Beach Vacation
| Priority | Area |
|----------|------|
| **Iconic beach** | Santa Monica |
| **Quieter beach** | Manhattan Beach, Hermosa |
| **Surfing** | Venice, Malibu |
| **Family beach** | Redondo, Long Beach |

### For Business
| Area | Why |
|------|-----|
| **DTLA** | Convention center, financial district |
| **Beverly Hills/Century City** | Corporate offices |
| **Santa Monica** | Tech (Westside) |
| **Burbank** | Entertainment industry |

---

## Transportation Considerations

### If You Have a Car
- Stay anywhere, parking is the issue
- Check hotel parking costs ($20-50/night)
- Valley and South Bay easier for parking

### Without a Car
| Area | Transit | Walkability |
|------|---------|-------------|
| **Santa Monica** | E Line | High |
| **DTLA** | Metro hub | Medium |
| **Hollywood** | B/D Line | Medium |
| **Koreatown** | B/D Line | Medium |
| **Beverly Hills** | Buses | Low |

**Reality:** Car is helpful but not mandatory if you stay in Santa Monica or DTLA and are OK with Uber for some trips.

---

## Booking Tips

### When to Book
- **3-6 months ahead:** Major events, holidays
- **1-2 months:** Regular travel
- **Last minute:** Can find deals if flexible

### Where to Book
| Platform | Notes |
|----------|-------|
| **Direct hotel** | Best for loyalty points, rate matching |
| **Hotels.com** | 10th night free |
| **Booking.com** | Good selection |
| **Airbnb** | Groups, longer stays |
| **HotelTonight** | Last-minute deals |

### Price Timing
- **Most expensive:** Summer, holidays, award season
- **Cheapest:** January (post-holidays), September
- **Weekends:** More expensive at beach areas
- **Weekdays:** More expensive in business areas

---

## What to Avoid

- **Hollywood Blvd motels:** Often sketchy
- **Very cheap Airbnbs:** Read reviews carefully
- **LAX airport hotels:** Only if catching early flight
- **Far-flung locations:** Don't stay in Ontario/Riverside to "save money" — you'll waste hours driving
