# Transport Guide — Los Angeles

**Reality check:** LA is a car city. Accept this and plan accordingly.

---

## The Car Reality

### Do You Need a Car?

| Situation | Need Car? | Notes |
|-----------|-----------|-------|
| **Living in LA full-time** | YES | 95% of life requires it |
| **Tourist (1 week)** | PROBABLY | Unless staying beach-only |
| **Working in tech (Westside)** | YES | Unless work/home walking distance |
| **Working DTLA only** | MAYBE | Metro improving, still limited |
| **Never leaving one neighborhood** | NO | Rare but possible |

### Monthly Car Costs (Budget This!)

| Item | Range | Notes |
|------|-------|-------|
| **Car payment** | $300-600 | Or buy used cash |
| **Insurance** | $150-300 | CA rates are HIGH |
| **Gas** | $150-300 | Depends on commute |
| **Parking (if renting)** | $100-300 | Often separate from rent |
| **Maintenance** | $50-100 | Average over time |
| **TOTAL** | $400-700/month | Minimum realistic budget |

### Traffic Realities

| Route | Rush Hour | Off-Peak | Notes |
|-------|-----------|----------|-------|
| **405 anywhere** | Brutal (1-2 hrs) | 30-45 min | "The 405" is always jammed |
| **101 through Hollywood** | Bad (45-90 min) | 20-30 min | Avoid 4-7pm |
| **10 Freeway** | Moderate-Bad | 20-40 min | East-West corridor |
| **PCH (1)** | Weekend gridlock | Beautiful drive | Beach traffic Sat/Sun |

**Best Times to Drive:**
- Early morning (before 7am)
- Late evening (after 8pm)
- Mid-day (10am-3pm usually OK)
- Avoid: 7-10am and 4-8pm on weekdays

### Parking Survival

| Situation | Tip |
|-----------|-----|
| **Street parking** | Read signs CAREFULLY (permit zones, cleaning days) |
| **Meters** | Use ParkMobile app, no coins needed |
| **Valet** | $5-15 + tip, often worth it |
| **Beach parking** | Arrive by 9am weekends or pay $15-30 lots |
| **DTLA** | Use SpotHero app for garage deals |

---

## Metro (Public Transit)

### Current Lines (2025)

| Line | Route | Useful For |
|------|-------|------------|
| **A Line (Blue)** | DTLA → Long Beach | Long Beach, South LA |
| **B/D Line (Red/Purple)** | DTLA → Hollywood → North Hollywood/Koreatown | Hollywood, K-Town, Universal |
| **C Line (Green)** | Norwalk → Redondo Beach | LAX connection, South Bay |
| **E Line (Expo)** | DTLA → Santa Monica | Beach from downtown |
| **K Line** | Expo/Crenshaw corridor | Inglewood, SoFi Stadium |
| **G Line (Orange)** | North Hollywood → Chatsworth | Valley connector (bus rapid) |

### Metro Fares

| Type | Cost |
|------|------|
| **Single ride** | $1.75 |
| **Day pass** | $5.00 |
| **Weekly** | $18.00 |
| **Monthly** | $50.00 |

**Get a TAP card** at any station ($2 card fee, reloadable).

### Metro Reality Check

**Good for:**
- DTLA ↔ Hollywood ↔ Universal Studios
- DTLA ↔ Santa Monica (E Line)
- Getting to events (SoFi, Crypto.com Arena)

**NOT good for:**
- Most commutes (limited coverage)
- Valley ↔ Westside (no direct line)
- Anywhere not near a station

**Safety:** Generally fine during day. More cautious late night.

---

## Rideshare (Uber/Lyft)

### Typical Costs

| Route | Estimate |
|-------|----------|
| LAX → Santa Monica | $25-40 |
| LAX → DTLA | $30-50 |
| Hollywood → DTLA | $15-25 |
| Santa Monica → West Hollywood | $20-30 |
| Any ride in traffic | 1.5-2x surge |

### Tips

- **Schedule rides** for airport trips (better pricing)
- **Avoid surge** around events (concerts, games)
- **Lyft often cheaper** in LA than Uber
- **Uber Reserve** for reliable airport pickups

---

## LAX Airport

### Getting There

| Option | Time | Cost | Notes |
|--------|------|------|-------|
| **Uber/Lyft** | Varies | $25-50+ | Drop-off at terminal |
| **FlyAway Bus** | 30-60 min | $8-10 | From Union Station, Van Nuys, others |
| **Metro K Line** | Opening soon | ~$2 | To Inglewood, then shuttle |
| **Driving** | Varies | Parking $15-40/day | Central lots or economy |

### LAX Tips

- **Pick-up:** LAX-it lot for Uber/Lyft (free shuttle from terminal)
- **Traffic:** Budget extra time afternoons
- **Terminal spacing:** Allow 20 min between terminals
- **Southwest:** Terminal 1 is far from rest

### Other Airports

| Airport | When to Use |
|---------|-------------|
| **Burbank (BUR)** | Best for Valley/Pasadena, easier than LAX |
| **Long Beach (LGB)** | JetBlue hub, chill small airport |
| **Ontario (ONT)** | Inland Empire, some Southwest |
| **John Wayne (SNA)** | Orange County, for south LA |

---

## Cycling & Scooters

### Biking

- **NOT a commuter city** for bikes (dangerous roads)
- **Beach bike path:** Excellent (Santa Monica ↔ Palos Verdes)
- **Metro Bike Share:** $1.75/ride, limited coverage
- **E-bikes:** Popular in beach cities

### Scooters (Bird, Lime, etc.)

| Pros | Cons |
|------|------|
| Fun for short trips | Dangerous on busy streets |
| Good in beach cities | LA roads are rough |
| Last mile from Metro | Helmets not provided |

**Best for:** Beach areas, Santa Monica, Venice boardwalk area

---

## Apps to Have

| App | Purpose |
|-----|---------|
| **Waze** | Navigation (better than Google Maps for traffic) |
| **Google Maps** | General directions, transit |
| **Metro TAP** | Transit fare and trip planning |
| **ParkMobile** | Street parking payment |
| **SpotHero** | Garage parking deals |
| **Uber/Lyft** | Rideshare |

---

## Quick Decision Rules

| Situation | Do This |
|-----------|---------|
| Living in LA | Get a car, budget $500/month |
| Tourist, beach-focused | Uber + walking OK |
| Tourist, seeing everything | Rent a car |
| Going to LAX | Uber/Lyft or FlyAway |
| Event at SoFi/Crypto | Metro if possible, parking $50-80 |
| Rush hour commute | Leave early or late, never 5-7pm |
| Weekend beach trip | Arrive before 10am or skip driving |
