# Tech Industry Guide — Los Angeles (Silicon Beach)

## Overview

LA is California's second tech hub, growing rapidly. Known as "Silicon Beach" (Westside focus). Strong in entertainment tech, gaming, aerospace, and consumer brands.

**Not SF, and that's OK:** Lower salaries but lower cost of living, better weather, more diverse economy.

---

## Tech Hubs by Area

| Area | Character | Key Companies | Rent Impact |
|------|-----------|---------------|-------------|
| **Santa Monica** | Original Silicon Beach, startups + established | Snap, Hulu, Headspace | High ($2,800-4,000) |
| **Venice** | Creative tech, agencies | Google (small office) | High ($2,500-3,500) |
| **Playa Vista** | "Silicon Beach" campus hub | Google, Facebook Meta, YouTube | High ($2,600-3,400) |
| **Culver City** | Studios + tech convergence | Apple TV+, Amazon Studios, Sony | Moderate ($2,400-3,200) |
| **El Segundo** | Aerospace + defense tech | SpaceX, Northrop, Raytheon | Moderate ($2,300-3,000) |
| **Burbank** | Entertainment + streaming | Disney, Warner Bros, Netflix | Moderate ($2,000-2,600) |
| **DTLA** | FinTech, startups | Various startups | Mixed ($2,200-3,500) |
| **Pasadena** | JPL, CalTech startups | NASA JPL, CalTech spinoffs | Moderate ($2,000-2,800) |

---

## Major Companies

### Big Tech Presence

| Company | LA Role | Location | Headcount |
|---------|---------|----------|-----------|
| **Google** | YouTube HQ, Cloud, some engineering | Playa Vista | 5,000+ |
| **Meta** | Engineering hub | Playa Vista | 1,500+ |
| **Apple** | Apple TV+ production | Culver City | 1,000+ |
| **Amazon** | Studios, some AWS | Culver City, SM | 3,000+ |
| **Snap** | HQ | Santa Monica | 4,000+ |
| **TikTok/ByteDance** | US operations | Culver City | 1,500+ |

### Aerospace/Defense

| Company | Focus | Location |
|---------|-------|----------|
| **SpaceX** | Rockets, Starlink | Hawthorne (South Bay) |
| **Northrop Grumman** | Defense, space | El Segundo |
| **Boeing** | Defense, satellites | El Segundo |
| **Anduril** | Defense AI | Costa Mesa (OC border) |
| **Relativity Space** | 3D printed rockets | Long Beach |

### Entertainment Tech

| Company | Focus | Location |
|---------|-------|----------|
| **Netflix** | Streaming, production | Hollywood |
| **Disney** | Streaming, parks tech | Burbank |
| **Warner Bros Discovery** | Streaming, production | Burbank |
| **Sony** | PlayStation, movies | Culver City |
| **Riot Games** | Gaming (League of Legends) | West LA |
| **Activision Blizzard** | Gaming (Call of Duty) | Santa Monica |

### Notable Startups/Scale-ups

| Company | Stage | Focus |
|---------|-------|-------|
| **SpaceX** | Mega-unicorn | Aerospace |
| **Snap** | Public | Social |
| **Anduril** | Unicorn | Defense AI |
| **Scopely** | Acquired by Savvy | Mobile gaming |
| **GOAT** | Unicorn | Sneaker marketplace |
| **Tala** | Series E | FinTech, developing markets |
| **ServiceTitan** | Unicorn | SaaS for trades |
| **Sweetgreen** | Public | Food tech |

---

## Salary Ranges (Total Compensation)

### Software Engineering

| Level | Base | Total Comp | Notes |
|-------|------|------------|-------|
| **Junior (0-2 yrs)** | $100K-130K | $110K-150K | |
| **Mid (2-5 yrs)** | $130K-170K | $150K-220K | |
| **Senior (5-8 yrs)** | $170K-220K | $200K-300K | |
| **Staff/Principal** | $220K-280K | $300K-400K | Rare |
| **Engineering Manager** | $180K-250K | $250K-350K | |

### LA vs SF Comparison

| Level | SF Total Comp | LA Total Comp | Difference |
|-------|---------------|---------------|------------|
| **Senior SWE** | $350-450K | $200-300K | ~25-30% lower |
| **Staff SWE** | $450-600K | $300-400K | ~30% lower |

**BUT:** LA housing is 15-25% cheaper. Net disposable income often similar.

### Other Roles

| Role | Mid-Level | Senior |
|------|-----------|--------|
| **Product Manager** | $120K-180K | $180K-250K |
| **UX/Product Designer** | $100K-140K | $140K-200K |
| **Data Scientist** | $130K-180K | $180K-260K |
| **DevOps/SRE** | $130K-180K | $180K-250K |

### Aerospace Salaries

| Role | Range | Notes |
|------|-------|-------|
| **SpaceX SWE** | $140K-200K | Lower cash, high mission drive |
| **Defense contractors** | $110K-180K | Clearance premium |
| **JPL engineer** | $100K-160K | Federal scale |

---

## Work Culture

### Hybrid Norms (2025)

| Type | Prevalence |
|------|------------|
| **3 days office** | Most common (60%) |
| **Fully remote** | ~20%, mostly startups |
| **5 days office** | ~20%, SpaceX, some studios |

### Culture by Sector

| Sector | Culture |
|--------|---------|
| **Big Tech (Google, Snap)** | Standard tech, good WLB |
| **Entertainment tech** | Crunch around releases |
| **Gaming** | Notorious crunch culture |
| **Aerospace (SpaceX)** | Intense, mission-driven, long hours |
| **Startups** | Varies wildly |

### LA vs SF Culture

| Aspect | LA | SF |
|--------|-------|-------|
| **Networking** | More casual, entertainment overlap | More intense, VC-focused |
| **Dress** | Casual + creative | Tech casual |
| **Commute** | Drive or remote | Transit possible |
| **Scene** | Growing, less dominant | Tech is THE industry |

---

## Where to Live (By Office)

### If Working in Santa Monica/Playa Vista

| Live In | Commute | Cost |
|---------|---------|------|
| **Santa Monica** | Walk/bike | $$$$$ |
| **Venice** | Bike/short drive | $$$$ |
| **Culver City** | 15-25 min drive | $$$ |
| **Mar Vista** | 10-15 min | $$ |
| **Palms** | 10-15 min | $$ |

### If Working in Culver City

| Live In | Commute | Cost |
|---------|---------|------|
| **Culver City** | Walk/bike | $$$ |
| **Mar Vista** | 5-10 min | $$ |
| **West LA** | 10-15 min | $$$ |
| **Palms** | 5-10 min | $$ |

### If Working in El Segundo (SpaceX, Aerospace)

| Live In | Commute | Cost |
|---------|---------|------|
| **El Segundo** | Walk/bike | $$$ |
| **Manhattan Beach** | 5-10 min | $$$$ |
| **Hermosa Beach** | 10-15 min | $$$ |
| **Redondo Beach** | 10-15 min | $$ |
| **Playa del Rey** | 10 min | $$$ |

### If Working in Burbank (Entertainment)

| Live In | Commute | Cost |
|---------|---------|------|
| **Burbank** | 5-15 min | $$ |
| **Studio City** | 10-15 min | $$ |
| **Glendale** | 10 min | $$ |
| **Toluca Lake** | 5 min | $$$ |

---

## Breaking Into LA Tech

### From Outside LA

1. **Apply remotely** — Many companies hire remote-first
2. **Network at events** — LA Tech Week, meetups
3. **Target growing companies** — Easier than FAANG
4. **Consider aerospace** — Less competition than consumer tech

### Key Networking

| Event/Community | Focus |
|-----------------|-------|
| **LA Tech Week** | Annual big event |
| **Dot LA** | News + events |
| **Silicon Beach meetups** | Various Meetup groups |
| **Cross Campus** | Coworking + events |
| **WeWork events** | Networking |

### Coworking Spaces

| Space | Areas | Vibe |
|-------|-------|------|
| **WeWork** | Multiple | Corporate startup |
| **Second Home** | Hollywood | Creative |
| **Cross Campus** | Santa Monica, DTLA | Tech focused |
| **Industrious** | Multiple | Premium |

---

## Visa & Sponsorship

Most large LA tech companies sponsor H-1B visas. Aerospace companies may require US citizenship for clearance work.

| Sector | Sponsorship |
|--------|-------------|
| **Big Tech** | Standard |
| **Entertainment tech** | Common |
| **Defense (SpaceX, etc.)** | Limited (clearance issues) |
| **Startups** | Case-by-case |

---

## Summary for AI Agent

For LA tech career questions:

1. **Salary expectations:** 20-30% lower than SF, but housing cheaper too
2. **Best areas:** Playa Vista (Big Tech), El Segundo (Aerospace), Burbank (Entertainment)
3. **Industries:** Entertainment tech, gaming, aerospace are LA strengths
4. **Culture:** More casual than SF, entertainment industry overlap
5. **Growing market:** Less saturated than SF, more opportunity in some sectors
