# Startup Guide — Los Angeles

## LA Startup Scene Overview

LA is the #3 startup ecosystem in the US (after SF and NYC). Growing rapidly, especially in entertainment tech, gaming, consumer brands, and aerospace.

### LA vs SF Startups

| Aspect | LA | SF |
|--------|-------|-------|
| **VC density** | Growing, less saturated | Highest in world |
| **Talent pool** | Diverse, entertainment + tech | Tech-focused |
| **Cost** | 20-30% cheaper | Most expensive |
| **Culture** | More casual, entertainment overlap | Intense, tech-centric |
| **Industries** | Entertainment, consumer, aerospace | Enterprise, fintech, SaaS |

---

## Strong Industries

### Entertainment Tech
- Streaming platforms
- Content tools
- Creator economy
- Gaming
- VR/AR entertainment

**Companies:** Snap, Hulu, Pluto TV, Cameo, PatreonLA

### Gaming
- Mobile gaming
- Console studios
- Esports
- Gaming tools

**Companies:** Riot Games, Activision, Scopely, Jam City

### Aerospace/Defense
- SpaceX effect: created ecosystem
- New space companies
- Defense tech growing

**Companies:** SpaceX, Anduril, Relativity Space, Astra

### Consumer Brands (DTC)
- LA understands brands/lifestyle
- Influencer ecosystem helps
- Strong creative talent

**Companies:** Dollar Shave Club (sold), The Honest Company, Goop

### Creator Economy
- YouTube HQ in Bay Area but creators in LA
- Influencer marketing
- Creator tools

**Companies:** MrBeast operations, MCNs, creator tools

---

## Funding Landscape

### Major VC Firms with LA Presence

| Firm | Focus |
|------|-------|
| **Andreessen Horowitz (a16z)** | Games, consumer, crypto |
| **Upfront Ventures** | LA-focused, multi-stage |
| **Greycroft** | Consumer, entertainment |
| **TenOneTen** | LA seed stage |
| **M13** | Consumer brands |
| **Crosscut Ventures** | LA seed, Series A |
| **Amplify** | LA-based |
| **Science Inc** | Studio model, LA |

### Accelerators

| Program | Focus | Notes |
|--------|-------|-------|
| **Y Combinator** | General | Remote now, but SF demo day |
| **Techstars LA** | LA-specific | Multiple tracks |
| **MuckerLab** | LA seed | Very LA-focused |
| **Grid110** | Underrepresented | South LA based |
| **Launchpad LA** | Mentorship | No investment |
| **Disney Accelerator** | Entertainment | Unique access |

### Funding Amounts (Typical)

| Stage | Range | Notes |
|-------|-------|-------|
| **Pre-seed** | $250K-1M | Angels, micro-VCs |
| **Seed** | $1-4M | Seed funds, some A funds |
| **Series A** | $8-20M | Institutional |
| **Series B** | $20-60M | Growth |

---

## Coworking & Incubators

| Space | Location | Vibe |
|-------|----------|------|
| **Cross Campus** | Santa Monica, DTLA | Tech-focused |
| **WeWork** | Multiple | Corporate |
| **Second Home** | Hollywood | Creative |
| **Industrious** | Multiple | Premium |
| **Blankspaces** | Multiple | Affordable |
| **CTRL Collective** | Playa Vista | Tech hub |

### Startup-Friendly Neighborhoods

| Area | Why |
|------|-----|
| **Santa Monica** | Original Silicon Beach, VCs nearby |
| **Playa Vista** | Tech campus feel |
| **Culver City** | Growing tech hub |
| **DTLA** | Cheaper, urban |
| **Pasadena** | CalTech spinoffs |

---

## Hiring & Talent

### Where to Find Talent

| Role | Where to Look |
|------|---------------|
| **Engineering** | LinkedIn, AngelList, tech meetups |
| **Design** | Art Center grads, Dribbble, Behance |
| **Creative** | USC/UCLA grads, agencies |
| **Marketing** | Strong local talent pool |
| **Sales** | LinkedIn, referrals |

### Salary Expectations (Startup)

| Role | Seed Stage | Series A+ |
|------|------------|-----------|
| **Engineer** | $100-150K + equity | $140-200K + equity |
| **Designer** | $80-120K + equity | $120-170K + equity |
| **Marketing** | $80-120K + equity | $120-180K + equity |
| **Sales** | $80-100K + commission | $120-150K + commission |

### Equity Reality
- Early employees: 0.5-2%
- Later hires: 0.01-0.1%
- Vesting: 4 years, 1 year cliff standard

---

## Networking

### Events & Conferences

| Event | When | For |
|-------|------|-----|
| **LA Tech Week** | Annual | Whole ecosystem |
| **Upfront Summit** | January | VCs, founders |
| **Silicon Beach Fest** | Summer | Community |
| **TechCrunch Disrupt** | October (SF but many LA folks) | Startups |

### Regular Meetups
- LA Tech Happy Hour
- Silicon Beach meetups
- Various Meetup.com groups
- Industry-specific (gaming, entertainment, etc.)

### Informal Networking
- Coffee meetings (LA loves coffee)
- Running/fitness groups
- Beach volleyball pickup
- House parties, events

---

## Legal & Admin

### Entity Formation
- Delaware C-Corp standard for VC-backed
- California LLC for smaller/bootstrapped
- Get a startup lawyer (many defer fees)

### Recommended Service Providers

| Service | Options |
|---------|---------|
| **Banking** | Mercury, SVB (careful), Brex |
| **Legal** | Cooley, Goodwin, WSGR |
| **Accounting** | Early stage: Pilot, Bench |
| **HR/Payroll** | Gusto, Rippling |
| **Insurance** | Vouch |

### California Considerations
- Higher taxes than other states
- Strong employee protections
- Non-competes unenforceable (good for hiring)
- Prop 65 warnings if consumer product

---

## Raising in LA

### How LA Differs
- **Less formal:** Coffee meetings more than pitch decks initially
- **Entertainment overlap:** VCs often have entertainment connections
- **Consumer expertise:** LA understands brands, culture
- **Relationship-driven:** Network matters a lot

### Pitch Tips
- Lead with market/traction
- Entertainment angle if relevant
- Show you understand LA's strengths
- Don't pretend to be SF

### Meeting VCs
- Warm intros strongly preferred
- LinkedIn cold outreach works sometimes
- Attend events, build relationships
- Angels often bridge to VCs

---

## Bootstrapping in LA

### Why It's Viable
- Lower burn than SF
- Strong freelance talent
- Consumer revenue models work
- Agency-to-product path

### Cost Structure (Lean)

| Item | Monthly |
|------|---------|
| **2 founders, no salary** | $0 |
| **Coworking** | $600 |
| **Software** | $200 |
| **Legal/Admin** | $200 |
| **TOTAL** | **~$1,000** |

Add living expenses ($3,500-5,000/founder in LA).

---

## Success Stories (LA Origin)

| Company | Founded | Exit/Status |
|---------|---------|-------------|
| **Snap** | 2011 | Public ($15B+) |
| **Dollar Shave Club** | 2011 | Acquired $1B |
| **The Honest Company** | 2011 | Public |
| **SpaceX** | 2002 | $150B+ valuation |
| **Hulu** | 2007 | Acquired by Disney |
| **Scopely** | 2011 | Acquired $4.9B |
| **Riot Games** | 2006 | Acquired by Tencent |

---

## Summary for AI Agent

For startup questions:

1. **Ecosystem:** #3 in US, growing, less saturated than SF
2. **Strong sectors:** Entertainment tech, gaming, aerospace, consumer
3. **Funding:** Upfront, Greycroft, TenOneTen are LA-focused
4. **Cost:** 20-30% cheaper than SF
5. **Culture:** More casual, entertainment industry overlap
6. **Where:** Santa Monica/Playa Vista (tech), Pasadena (deep tech)
