# Safety Guide — Los Angeles (Honest Assessment)

## Overview

LA is generally safe, but it's a huge city with massive variation block-to-block. Most neighborhoods are quite safe. Problems are concentrated in specific areas.

**Key insight:** LA feels less "street-level dangerous" than SF or NYC. Main concerns are property crime and driving safety.

---

## Areas with Caution

### Skid Row (DTLA)

**Boundaries:** 3rd to 7th Street, Main to Alameda (DTLA)

- Largest homeless concentration in US
- Open drug use and mental health crises
- Walk around, not through
- **Day:** Avoid if possible
- **Night:** Do not enter

### Parts of Hollywood

- **Hollywood Blvd tourist area:** Pickpockets, scams, aggressive characters
- **North of Hollywood Blvd:** Gets sketchy quickly in some blocks
- **Day:** Tourist area is fine, just crowded
- **Night:** Stick to main streets, Uber if unsure

### South LA

- Higher crime in some neighborhoods
- NOT a tourist area
- Improving in some parts (Leimert Park, Hyde Park)
- Research specific blocks before renting

### MacArthur Park Area

- Historically rough, still some issues
- Near Koreatown but feels different
- Gentrification changing some blocks

---

## Generally Safe Areas

| Area | Safety Level | Notes |
|------|-------------|-------|
| **Santa Monica** | Very Safe | Tourist-friendly, police presence |
| **Beverly Hills** | Very Safe | Private security, residential |
| **Westside beaches** | Safe | Normal beach city awareness |
| **South Bay** | Very Safe | Family beach towns |
| **Pasadena** | Very Safe | Historic, residential |
| **Burbank/Glendale** | Very Safe | Suburban, low crime |
| **Studio City/Sherman Oaks** | Very Safe | Residential Valley |
| **Culver City** | Safe | Revitalized, tech hub |
| **Los Feliz/Silver Lake** | Safe | Trendy, walkable (mostly) |

---

## Safety by Activity

### Walking

| Time | Safe Areas | Caution Areas | Avoid |
|------|------------|---------------|-------|
| **Day** | Most neighborhoods | Hollywood tourist area | Skid Row |
| **Night** | Westside, South Bay, Valley | DTLA, Hollywood | Skid Row, sketchy blocks |
| **Late night** | Residential areas OK | Most commercial areas | Anywhere unfamiliar |

### Driving

| Concern | Reality |
|---------|---------|
| **Car break-ins** | Less than SF, still common at trailheads, tourist spots |
| **Road rage** | Real. Stay calm, don't engage |
| **Freeway shootings** | Rare but reported. Don't cut people off. |
| **DUI enforcement** | Aggressive. Use Uber if drinking. |

**Tips:**
- Don't leave ANYTHING visible in car
- Trailhead parking = target for break-ins
- Lock doors while driving
- Don't engage with aggressive drivers

### Public Transit

| Line | Safety |
|------|--------|
| **E Line (to beach)** | Generally fine |
| **B/D Line (Hollywood)** | Fine during day, more aware at night |
| **A Line (to Long Beach)** | More rough in South LA portions |
| **Buses** | Varies by neighborhood |

**Tips:**
- Day travel is fine
- Night: sit near driver, stay alert
- Keep phone and valuables secured

---

## Homelessness Context

### Reality
- Visible in many areas (not just Skid Row)
- DTLA, Venice Beach, Hollywood areas affected
- Most homeless people are not dangerous
- Mental health and drug issues affect some

### Areas Most Affected
- Skid Row (DTLA) — by far worst
- Venice Beach boardwalk
- Parts of Hollywood
- Some freeway underpasses
- Parks (Echo Park, MacArthur Park areas)

### How to Handle
- Walk past, don't engage if uncomfortable
- Most people will leave you alone
- Aggressive behavior is rare but call 911 if threatened
- Don't leave food in car (attracts searching)

---

## Natural Disasters

### Earthquakes

**Reality:** They happen. Usually minor. Buildings are built for it.

**What to Have:**
- 3 days water (1 gallon/person/day)
- Non-perishable food
- Flashlight, batteries
- First aid kit
- Cash (ATMs may not work)
- Phone charger
- Shoes by bed (broken glass)

**During a Quake:**
- **Inside:** Drop, cover, hold on (under table/desk)
- **Outside:** Move away from buildings, power lines
- **Driving:** Pull over, stay in car
- **After:** Expect aftershocks, check for damage

**Apps:**
- **MyShake** — Earthquake early warning (CA official)
- **ShakeAlertLA** — City warning system

### Wildfires (Fire Season: June-December)

| If You Live In | Fire Risk |
|----------------|-----------|
| **Hills/canyons** | HIGH — evacuation zones |
| **Beach cities** | LOW — ocean buffer |
| **Valley floor** | LOW-MEDIUM |
| **Malibu/Pacific Palisades** | HIGH — history of major fires |

**During Fire Season:**
- Air quality can be bad (get N95 masks)
- Follow evacuation orders immediately
- Have "go bag" ready if in fire zone
- Watch for red flag warnings

**Apps:**
- **Watch Duty** — Best fire tracking app
- **AirNow** — Air quality
- **Ready LA** — Emergency alerts

### Mudslides (Rainy Season: Dec-Mar)

- Follow fires, especially in burn areas
- Canyon and hillside homes at risk
- Obey evacuation orders

---

## Property Crime

### Car Break-ins

| Location | Risk |
|----------|------|
| **Trailhead parking** | HIGH |
| **Tourist spots (Hollywood sign area)** | HIGH |
| **Beach parking lots** | MEDIUM |
| **Residential streets** | LOW-MEDIUM |
| **Secure garages** | LOW |

**Prevention:**
- Leave NOTHING visible
- Empty trunk BEFORE arriving (they watch)
- Use garages when possible
- Don't rely on tinted windows

### Package Theft

- Common in apartment buildings
- Use Amazon Locker or office delivery
- Many buildings have package rooms now
- Ring cameras help but don't prevent

### Bike Theft

- Very common
- U-lock through frame, not just wheel
- Register bike with LAPD
- Don't leave expensive bikes outside

---

## Emergency Numbers

| Service | Number |
|---------|--------|
| **Emergency** | 911 |
| **LAPD Non-emergency** | 877-ASK-LAPD (877-275-5273) |
| **Poison Control** | 1-800-222-1222 |
| **Mental Health Crisis** | 988 (new national line) |
| **Fire/AQI Info** | 311 |

---

## The Honest Summary

**LA is safe for most people in most places.** Key points:

- **Not as street-level sketchy** as SF or parts of NYC
- **Biggest concerns:** Property crime, traffic, natural disasters
- **Block-by-block variation:** Always research specific areas
- **Skid Row:** Only area to actively avoid
- **Prepare for disasters:** Earthquake kit is non-negotiable

Don't let fear stop you from enjoying LA, but be smart about where you park, where you walk late at night, and have an earthquake kit ready.
