# Moving & Settling Guide — Los Angeles

## Before You Move

### What to Know

1. **You need a car** — Accept this and budget $400-700/month
2. **Choose neighborhood carefully** — Where you live = your lifestyle
3. **Weather varies by location** — Valley is 10-15°F hotter than coast
4. **It's expensive** — Budget $4,000-6,000/month minimum for single person
5. **Job first** — Don't move without employment or 6+ months savings

### Research Your Neighborhood

- Visit at different times of day
- Check traffic to likely workplace
- Talk to locals if possible
- Use Google Street View extensively

---

## Finding Housing

### Where to Search

| Platform | Best For |
|----------|----------|
| **Apartments.com** | Large complexes |
| **Zillow** | All types |
| **Craigslist** | Still active in LA, be careful |
| **Facebook groups** | Room shares, sublets |
| **Westside Rentals** | Premium listings |
| **PadMapper** | Good filtering |
| **Radpad** | Newer buildings |

### Application Requirements

- Proof of income (2-3x rent)
- Credit check (~$35-50 fee)
- Previous landlord references
- Employment verification
- First month + security deposit (usually one month)
- Sometimes last month too

### Common Lease Terms

- 12-month standard
- Month-to-month rare, more expensive
- Rent control: Applies to buildings pre-1979 (LA City)
- Pets: Often extra deposit ($250-500) + monthly fee

### Red Flags

- No in-person showing → probably scam
- Way below market rent → scam
- Pressure to wire money → scam
- Won't provide lease before signing → avoid

---

## Getting Set Up

### Driver's License

**Must get CA license within 10 days of establishing residency.**

| Step | Where | Cost |
|------|-------|------|
| 1. DMV appointment | dmv.ca.gov | |
| 2. REAL ID application | DMV | $41 |
| 3. Written test | DMV | Included |
| 4. Driving test (if no valid license) | DMV | Included |

**Tip:** Appointments book weeks out. Schedule immediately.

### Vehicle Registration

If bringing a car from another state:

| Step | Deadline | Cost |
|------|----------|------|
| Smog check | Before registration | $50-80 |
| Register vehicle | Within 20 days | ~$200-400 (varies by value) |
| Get CA plates | | Included |

**Note:** CA registration is expensive. Budget ~$400/year.

### Utilities

| Utility | Provider | Notes |
|---------|----------|-------|
| **Electric** | LADWP (LA City) or SCE | Automatic transfer usually |
| **Gas** | SoCalGas | |
| **Water** | LADWP (often with electric) | Sometimes included in rent |
| **Trash** | LADWP (often included) | |
| **Internet** | Spectrum (most common), AT&T | ~$60-100/month |

**LADWP:** ladwp.com — Sign up online, deposit may be required

### Internet Options

| Provider | Speed | Price | Notes |
|----------|-------|-------|-------|
| **Spectrum** | 200-940 Mbps | $50-100 | Most available |
| **AT&T Fiber** | 1 Gbps | $80-120 | Limited areas |
| **Starlink** | Variable | $120 | Good for remote areas |

---

## Getting a Car

### Buying

| Option | Pros | Cons |
|--------|------|------|
| **Dealership (new)** | Warranty, financing | More expensive |
| **Dealership (used)** | Some warranty, financing | Markup |
| **Private (Craigslist, FB)** | Cheaper | Risk, cash only |
| **CarMax** | Easy, no haggle | Premium price |
| **Carvana** | Delivered, 7-day return | Premium price |

### Leasing vs Buying

- **Lease:** Lower monthly, but high mileage area (12k/year often not enough)
- **Buy:** Higher monthly, but yours. Makes more sense in LA.

### Insurance

**CA insurance is expensive.** Budget $150-300/month.

| Factor | Impact |
|--------|--------|
| Under 25 | +50-100% |
| Tickets/accidents | +20-50% |
| Nice car | +30-50% |
| Good credit | -10-20% |

**Minimum coverage:** Liability only legal, but collision recommended.

---

## Banking

### Major Banks with LA Presence

| Bank | Notes |
|------|-------|
| **Chase** | Many branches, good app |
| **Bank of America** | Many ATMs |
| **Wells Fargo** | Widespread |
| **Charles Schwab** | No ATM fees worldwide |
| **Online (Ally, etc.)** | Good rates, limited physical |

### Credit Unions

- LA Federal Credit Union
- First Entertainment Credit Union (industry workers)
- Kinecta

---

## Healthcare

### Finding a Doctor

| Need | How |
|------|-----|
| **Primary care** | Zocdoc, insurance directory |
| **Urgent care** | CityMD, Carbon Health, CVS |
| **Emergency** | Cedars-Sinai, UCLA, Providence |

### Major Hospital Systems

| System | Locations | Notes |
|--------|-----------|-------|
| **Cedars-Sinai** | Beverly Hills area | Top-rated |
| **UCLA Health** | Westwood + others | Academic, excellent |
| **Providence** | Multiple | Catholic system |
| **Kaiser** | Multiple | If you have Kaiser |

### Health Insurance

- **Employer:** Most common
- **Covered California:** Marketplace if no employer coverage
- **Medi-Cal:** If income-qualifying

---

## Earthquake Preparedness

### Essential Kit

| Item | Quantity |
|------|----------|
| **Water** | 1 gallon per person per day × 3 days |
| **Food** | Non-perishable, 3 days |
| **Flashlight** | With batteries |
| **First aid kit** | Basic |
| **Cash** | Small bills, $100-300 |
| **Phone charger** | Battery pack |
| **Radio** | Battery or crank |
| **Shoes by bed** | For broken glass |

### Apps

| App | Purpose |
|-----|---------|
| **MyShake** | Official CA earthquake warning |
| **ShakeAlertLA** | LA-specific alerts |
| **Ready LA** | Emergency info |

### Basic Knowledge

- **Drop, cover, hold on** — Under table/desk
- **Doorways are NOT safer** — Old myth
- **Expect aftershocks** — Can continue for days
- **Check for damage** — Gas leaks, structural

---

## Fire Season Preparedness

### If You Live in Fire Zone (Hills/Canyons)

- **Know evacuation routes** — Multiple options
- **Go bag ready** — Documents, meds, essentials
- **Defensible space** — Clear brush around property
- **Sign up for alerts** — LA County Alert

### Air Quality

- **N95 masks** — Keep supply
- **Air purifier** — For home during smoke events
- **Check AirNow.gov** — Before outdoor activities

---

## Neighborhood Life

### Getting to Know Your Area

- Walk around different times
- Find your coffee shop, grocery, gym
- Introduce yourself to neighbors
- Join Nextdoor (with skepticism)
- Find local Facebook groups

### Essential Apps

| App | Purpose |
|-----|---------|
| **Waze** | Traffic navigation |
| **SpotHero** | Parking deals |
| **ParkMobile** | Street parking payment |
| **Metro TAP** | Transit |
| **Citizen** | Local incidents (use sparingly) |
| **Nextdoor** | Neighborhood (take with grain of salt) |

---

## Building Community

### Finding Your People

| Interest | Where |
|----------|-------|
| **Fitness** | Gyms, running clubs, hiking groups |
| **Creative** | Coffee shops, coworking, classes |
| **Sports** | Rec leagues, pickup games |
| **Professional** | Industry meetups, happy hours |
| **Spiritual** | Churches, temples, meditation centers |

### Meetup Categories

- Tech/startup meetups
- Hiking groups (many)
- Photography walks
- Running clubs
- Creative writing
- Industry-specific

### The Reality

LA can feel lonely at first. Everyone is busy, traffic limits spontaneous hangouts. It takes effort to build community. Give it 6-12 months before judging.

---

## Summary Checklist

### First Week
- [ ] Sign lease, get keys
- [ ] Set up utilities (LADWP, SoCalGas, internet)
- [ ] Get California driver's license (schedule DMV)
- [ ] Register car (if bringing one)
- [ ] Open local bank account (optional)

### First Month
- [ ] Find primary care doctor
- [ ] Build earthquake kit
- [ ] Learn neighborhood (grocery, coffee, gym)
- [ ] Figure out commute patterns
- [ ] Download essential apps

### First 90 Days
- [ ] Register to vote (California)
- [ ] Join something social (gym, group, class)
- [ ] Explore different neighborhoods
- [ ] Establish routines
- [ ] Find your favorite taco spot
