# Neighborhood Quick Reference — Los Angeles

> Match users to neighborhoods based on budget, lifestyle, and priorities.

## Comparison Table

| Neighborhood | Area | Vibe | 1BR Rent ($/mo) | Safety | Best For |
|-------------|------|------|-----------------|--------|----------|
| **Santa Monica** | Westside | Beach, upscale, walkable | $2,800–4,000 | ★★★★★ | Beach lovers, tech workers |
| **Venice** | Westside | Artsy, edgy, trendy | $2,500–3,500 | ★★★☆☆ | Creatives, young professionals |
| **Culver City** | Westside | Revitalized, hip, family | $2,400–3,200 | ★★★★☆ | Tech workers, families |
| **Playa Vista** | Westside | Modern, tech hub, new | $2,600–3,400 | ★★★★★ | Tech workers, young families |
| **Mar Vista** | Westside | Affordable beach-adjacent | $2,200–2,800 | ★★★★☆ | Budget beach lifestyle |
| **Brentwood** | Westside | Affluent, quiet, family | $3,000–4,500 | ★★★★★ | Wealthy families, executives |
| **West Hollywood** | Central | LGBTQ+, nightlife, creative | $2,400–3,500 | ★★★★☆ | LGBTQ+, entertainment industry |
| **Hollywood** | Central | Tourist, mixed, gritty | $2,000–2,800 | ★★★☆☆ | Budget central, nightlife |
| **Los Feliz** | Central | Hipster, village, artsy | $2,200–3,200 | ★★★★☆ | Creatives, young professionals |
| **Silver Lake** | Central | Trendy, indie, cafes | $2,300–3,300 | ★★★★☆ | Hipsters, creatives |
| **Echo Park** | Central | Up-and-coming, diverse | $1,900–2,600 | ★★★☆☆ | Artists on budget |
| **DTLA** | Central | Urban, lofts, arts district | $2,200–3,500 | ★★★☆☆ | Urban lifestyle, young pros |
| **Koreatown** | Central | Dense, diverse, 24/7 | $1,600–2,200 | ★★★☆☆ | Budget central, nightlife |
| **Manhattan Beach** | South Bay | Beach town, affluent | $3,000–4,500 | ★★★★★ | Families, beach lifestyle |
| **Hermosa Beach** | South Bay | Young, party, volleyball | $2,400–3,200 | ★★★★★ | Young professionals, beach |
| **Redondo Beach** | South Bay | Family, affordable beach | $2,200–3,000 | ★★★★☆ | Families, beach on budget |
| **El Segundo** | South Bay | Aerospace, tech, quiet | $2,300–3,000 | ★★★★★ | Tech workers, aerospace |
| **Studio City** | Valley | Entertainment, quiet | $2,000–2,800 | ★★★★☆ | Entertainment industry |
| **Sherman Oaks** | Valley | Family, suburban | $1,900–2,600 | ★★★★☆ | Families, value seekers |
| **Burbank** | Valley | Studios, family, safe | $2,000–2,600 | ★★★★★ | Entertainment workers, families |
| **Glendale** | Valley | Armenian community, safe | $1,900–2,500 | ★★★★★ | Families, safe suburb |
| **Pasadena** | East | Historic, college, culture | $2,000–2,800 | ★★★★☆ | Families, academics |
| **Highland Park** | Northeast | Gentrifying, arts | $1,800–2,500 | ★★★☆☆ | Hipsters, artists |
| **Eagle Rock** | Northeast | Artsy, affordable | $1,700–2,400 | ★★★★☆ | Creatives on budget |

**Safety Key**: ★★★★★ = Very Safe | ★★★★☆ = Safe | ★★★☆☆ = Varies by block

## By Profile

| Looking For | Best Areas |
|-------------|------------|
| **Beach lifestyle** | Santa Monica, Manhattan Beach, Hermosa |
| **Tech/Silicon Beach** | Playa Vista, Culver City, Santa Monica |
| **Entertainment industry** | West Hollywood, Studio City, Burbank |
| **Budget + central** | Koreatown, Echo Park, Highland Park |
| **Family-friendly** | Pasadena, South Bay, Sherman Oaks |
| **Nightlife + social** | West Hollywood, Hollywood, Silver Lake |
| **Creative community** | Silver Lake, Los Feliz, Echo Park |
| **Quiet suburban** | Glendale, Burbank, Pasadena |

## Critical Weather Note

| Area | Summer Temps | Notes |
|------|--------------|-------|
| **Westside (coast)** | 70-80°F | June Gloom fog May-July |
| **Valley** | 85-105°F | 10-15°F hotter than coast |
| **DTLA** | 80-95°F | Heat island effect |
| **South Bay** | 72-82°F | Best beach weather |
| **Pasadena** | 85-100°F | Hot, dry summers |

**Key insight:** If you hate heat, avoid the Valley. If you hate fog, avoid the immediate coast May-July.

## Detailed Profiles

| Area Type | File |
|-----------|------|
| Westside | `neighborhoods-westside.md` |
| Hollywood/Central | `neighborhoods-central.md` |
| South Bay | `neighborhoods-southbay.md` |
| Valley | `neighborhoods-valley.md` |
| East/Northeast | `neighborhoods-east.md` |
