# Central LA Neighborhoods — Hollywood & Surrounding

Central LA includes Hollywood and the eastside hipster neighborhoods. More affordable than Westside, more character, better nightlife.

---

## Hollywood

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Tourist meets residential, mixed |
| **1BR Rent** | $2,000-2,800 |
| **Safety** | ★★★☆☆ Varies significantly |
| **Transit** | B/D Line (Red/Purple) |
| **Parking** | Difficult |

### Who It's For
- Entertainment industry workers
- Budget-conscious central seekers
- Nightlife lovers
- People who don't mind grit

### Pros
- Metro access (B Line)
- Nightlife, music venues
- Entertainment industry proximity
- More affordable than Westside
- Central location

### Cons
- Tourist chaos on Hollywood Blvd
- Safety varies block to block
- Homeless presence in parts
- Noisy (helicopters, traffic)
- Hollywood Blvd itself is disappointing

### Sub-Areas
- **Beachwood Canyon:** Quiet, residential, Hollywood sign adjacent
- **Hollywood & Highland:** Tourist central, avoid living here
- **Thai Town:** Affordable, great food
- **Little Armenia:** Cultural, affordable

### Safety Note
Research exact block before renting. One block can be fine, the next sketchy.

---

## West Hollywood (WeHo)

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | LGBTQ+ hub, nightlife, creative |
| **1BR Rent** | $2,400-3,500 |
| **Safety** | ★★★★☆ Safe |
| **Transit** | Buses (no Metro rail) |
| **Parking** | Difficult |

### Who It's For
- LGBTQ+ community
- Nightlife lovers
- Entertainment industry people
- Young, social professionals

### Pros
- Vibrant nightlife
- Great restaurants
- LGBTQ+-friendly
- Walkable on Santa Monica Blvd
- Safe, well-maintained

### Cons
- Expensive for what it is
- Loud (nightlife noise)
- Parking terrible
- Can feel party-focused
- No Metro rail

### Sub-Areas
- **Sunset Strip:** Music venues, clubs
- **Santa Monica Blvd:** LGBTQ+ bars, restaurants
- **Design District:** Upscale, quiet
- **Boys Town:** Gay bars, nightlife center

---

## Los Feliz

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Hipster village, leafy, artsy |
| **1BR Rent** | $2,200-3,200 |
| **Safety** | ★★★★☆ Safe |
| **Transit** | Limited |
| **Parking** | Moderate |

### Who It's For
- Creatives, writers
- People who want village feel
- Griffith Park lovers
- Independent film types

### Pros
- Beautiful, tree-lined streets
- Griffith Park access
- Great indie restaurants, bars
- Village feel (Vermont/Hillhurst)
- Character architecture

### Cons
- Limited transit
- Need car
- Hills mean walking is tough
- Gets hot (not coastal)
- Limited parking on main streets

### Sub-Areas
- **Vermont corridor:** Walkable shops, restaurants
- **Hillhurst:** More residential
- **Los Feliz Hills:** Expensive, views

---

## Silver Lake

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Peak hipster, trendy, indie |
| **1BR Rent** | $2,300-3,300 |
| **Safety** | ★★★★☆ Safe |
| **Transit** | Limited |
| **Parking** | Difficult |

### Who It's For
- Creative professionals
- Music/art scene people
- Coffee shop workers
- Instagram-lifestyle types

### Pros
- Peak trendy
- Reservoir walking/running
- Great coffee, cafes
- Independent businesses
- Music venues

### Cons
- Expensive for location
- Hilly (hard to walk)
- Limited parking
- Can feel pretentious
- Gentrification completed

### The Reservoir
- 2.2 mile loop
- Great for running, walking
- Dog-friendly
- Sunset views

---

## Echo Park

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Up-and-coming, diverse, artsy |
| **1BR Rent** | $1,900-2,600 |
| **Safety** | ★★★☆☆ Varies |
| **Transit** | Some bus access |
| **Parking** | Moderate |

### Who It's For
- Artists on budget
- Those priced out of Silver Lake
- Adventurous types
- Latin culture appreciators

### Pros
- More affordable than Silver Lake
- Echo Park Lake (paddleboats!)
- Good tacos
- Diverse, authentic
- Artist community

### Cons
- Gentrifying (displacement tension)
- Safety varies by block
- Less polish than Silver Lake
- Some sketchy areas
- Getting expensive

---

## DTLA (Downtown)

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Urban loft living, mixed |
| **1BR Rent** | $2,200-3,500 |
| **Safety** | ★★★☆☆ Highly variable |
| **Transit** | Best in LA (Metro hub) |
| **Parking** | Expensive |

### Who It's For
- Urban lifestyle seekers
- Those wanting transit
- Young professionals
- Loft lovers

### Pros
- Best transit access in LA
- Loft apartments
- Arts District is cool
- Grand Central Market
- Urban density (rare in LA)

### Cons
- Skid Row nearby (homelessness crisis)
- Safety very block-dependent
- Dead at night in parts
- Parking expensive
- Can feel apocalyptic

### Sub-Areas
- **Arts District:** Coolest, galleries, converted warehouses
- **Historic Core:** Grand Central Market, old buildings
- **South Park:** Newer towers, Crypto.com Arena
- **Financial District:** Dead at night
- **Fashion District:** Wholesale, not residential

### Critical Warning
Research EXACT building location. Blocks matter enormously in DTLA. Some beautiful lofts are steps from Skid Row.

---

## Koreatown (K-Town)

### Overview
| Aspect | Detail |
|--------|--------|
| **Vibe** | Dense, diverse, 24/7, food heaven |
| **1BR Rent** | $1,600-2,200 |
| **Safety** | ★★★☆☆ Average |
| **Transit** | B/D Line access |
| **Parking** | Terrible |

### Who It's For
- Budget-conscious
- Food lovers (Korean, diverse)
- Nightlife lovers (bars open late)
- Those wanting urban density

### Pros
- Most affordable central location
- Best Korean food in America
- 24/7 dining, drinking
- Metro access
- Dense, walkable

### Cons
- Crowded
- Parking nightmare
- Some crime
- Not pretty
- Noise (dense)

### Food Note
Koreatown has the highest concentration of restaurants per capita in LA. KBBQ, cafes, bars everywhere.

---

## Central Summary

| Neighborhood | Best For | Avoid If |
|--------------|----------|----------|
| **Hollywood** | Budget central | Safety-concerned |
| **West Hollywood** | LGBTQ+, nightlife | Quiet seekers |
| **Los Feliz** | Village feel | Need transit |
| **Silver Lake** | Peak trendy | Budget-focused |
| **Echo Park** | Budget artsy | Safety-focused |
| **DTLA** | Urban lifestyle | Nervous about homelessness |
| **Koreatown** | Food + budget | Need quiet |
