# Local Services Guide — Los Angeles

Practical services and resources for daily life in LA.

---

## DMV (Department of Motor Vehicles)

### Getting a License
1. **Schedule appointment:** dmv.ca.gov (book weeks ahead)
2. **Bring:** Out-of-state license, proof of residency, SSN
3. **Written test:** 36 questions, need 30 correct
4. **Driving test:** If no valid US license
5. **Cost:** $41 (REAL ID)

### Tips
- Appointments book out 2-4 weeks
- Go to smaller offices (avoid Hollywood, DTLA)
- AAA members can do some DMV services at AAA

### Best DMV Offices (Less Wait)
- Culver City
- Glendale
- El Monte
- Avoid: Hollywood, DTLA, Van Nuys

---

## Vehicle Registration

### New to California
1. **Smog check** within 20 days
2. **Register** at DMV within 20 days
3. **Cost:** ~$200-400 depending on car value

### Annual Renewal
- ~$200-400/year
- Smog every 2 years
- Online renewal: dmv.ca.gov

---

## Voter Registration

### How to Register
- Online: registertovote.ca.gov
- Same-day registration at polls
- Need: CA license or SSN

### Elections
- Primary: March (varies)
- General: November
- LA has many local elections too

---

## Healthcare

### Finding Providers

| Need | Options |
|------|---------|
| **Primary care** | Zocdoc, One Medical, insurance directory |
| **Urgent care** | CityMD, Carbon Health, CVS MinuteClinic |
| **ER** | Cedars-Sinai, UCLA, Providence |
| **Dentist** | Zocdoc, Yelp |

### Major Hospital Systems

| System | Locations | Notes |
|--------|-----------|-------|
| **Cedars-Sinai** | Beverly Hills area | Top-ranked |
| **UCLA Health** | Westwood + others | Academic, excellent |
| **Providence** | Multiple | Large network |
| **Kaiser** | Multiple | HMO model |
| **Keck/USC** | DTLA area | Academic |

### Insurance Options
- **Employer:** Most common
- **Covered California:** Marketplace (coveredca.com)
- **Medi-Cal:** Income-qualifying
- **Uninsured:** Community clinics, Planned Parenthood

---

## Banking

### Major Banks (Many Branches)
- Chase
- Bank of America
- Wells Fargo
- Citibank

### Good Online Options
- Charles Schwab (no ATM fees worldwide)
- Ally (high interest savings)
- Marcus (Goldman Sachs savings)

### Credit Unions
- LA Federal Credit Union
- First Entertainment (entertainment industry)
- Kinecta
- SchoolsFirst (educators)

---

## Postal & Shipping

### USPS
- Find locations: usps.com
- General delivery available
- Informed Delivery (see mail before delivery)

### Package Delivery Issues
- **Theft common:** Use Amazon Locker, work address, or building package room
- **UPS/FedEx:** Can redirect to pickup locations
- **Ring cameras:** Don't prevent but help identify

---

## Utilities Setup

### LADWP (LA City)
- Electric + water (usually bundled)
- ladwp.com
- Deposit may be required

### SoCalGas
- Gas service
- socalgas.com
- Usually quick setup

### Internet
| Provider | Coverage | Speed |
|----------|----------|-------|
| **Spectrum** | Widest | 200-940 Mbps |
| **AT&T Fiber** | Limited areas | 1 Gbps |
| **Frontier** | Some areas | Variable |

---

## Phone & Mobile

### Major Carriers
- Verizon (best coverage, most expensive)
- AT&T (good coverage)
- T-Mobile (good value, coverage varies)
- Mint Mobile (cheap, T-Mobile network)
- Visible (cheap, Verizon network)

### Dead Zones
- Some canyons (Malibu, etc.)
- Parts of Griffith Park
- Some buildings (concrete)

---

## Laundry

### Options
| Type | Cost |
|------|------|
| **In-unit** | Best, often included |
| **Building laundry** | $2-4/load |
| **Laundromat** | $2-4/load |
| **Wash & fold** | $1-2/lb (delivery: Rinse, Cleanly) |
| **Dry cleaning** | $10-20/item |

---

## Groceries

### Chains by Type

| Type | Stores |
|------|--------|
| **Budget** | Aldi, Food 4 Less, Grocery Outlet |
| **Mid-range** | Ralphs, Vons, Albertsons |
| **Premium** | Whole Foods, Gelson's |
| **Value + Quality** | Trader Joe's, Costco |
| **Wellness tax** | Erewhon ($25 smoothies) |

### Delivery
- Instacart (most stores)
- Amazon Fresh
- Whole Foods (Prime)
- Vons/Ralphs delivery

### Ethnic Markets
| Cuisine | Markets |
|---------|---------|
| **Korean** | H Mart, Hannam Chain |
| **Japanese** | Mitsuwa, Nijiya |
| **Mexican** | Vallarta, Northgate |
| **Chinese** | 99 Ranch, Great Wall |
| **Armenian/Middle Eastern** | Jon's, Elat Market |

---

## Gyms & Fitness

### Budget
| Gym | Price | Notes |
|-----|-------|-------|
| **Planet Fitness** | $10-25/mo | Basic |
| **24 Hour Fitness** | $30-50/mo | More equipment |
| **LA Fitness** | $30-50/mo | Standard |

### Premium
| Gym | Price | Notes |
|-----|-------|-------|
| **Equinox** | $250+/mo | Luxury |
| **SoulCycle** | Per class | Boutique |
| **Barry's** | Per class | High intensity |
| **Rise Nation** | Per class | Climbing |

### Free Options
- Beach (running, volleyball)
- Hiking trails
- Outdoor stairs (Santa Monica stairs)
- Public parks

---

## Pet Services

### Veterinary
- **VCA** (chain, multiple locations)
- **Banfield** (in PetSmart)
- **Independent vets** (often better)
- **Emergency:** VCA Emergency, ACCESS

### Dog Parks (Off-Leash)
- Runyon Canyon (parts)
- Laurel Canyon Dog Park
- Silverlake Dog Park
- Westminster Dog Park (Venice)
- Rosie's Dog Beach (Long Beach)

### Boarding/Sitting
- Rover
- Wag
- Local pet hotels

---

## Home Services

### Finding Help
| Need | Where |
|------|-------|
| **Handyman** | Yelp, Thumbtack |
| **Plumber** | Yelp, HomeAdvisor |
| **Electrician** | Yelp, licensed required |
| **Cleaning** | Handy, Yelp, TaskRabbit |
| **Moving** | Yelp, Dolly (small moves) |

### Tips
- Check license for contractors (CSLB.ca.gov)
- Get multiple quotes
- Read Yelp reviews (actually useful in LA)
- Pay with credit card (protection)

---

## Parking

### Street Parking
- Read signs CAREFULLY
- Street cleaning days = tickets
- Permit zones in residential areas
- ParkMobile app for meters

### Parking Apps
- **ParkMobile:** Street meters
- **SpotHero:** Garage deals
- **ParkWhiz:** Event parking

### Parking Costs
| Area | Street/Hour | Garage/Hour |
|------|-------------|-------------|
| **Santa Monica** | $2-4 | $3-8 |
| **DTLA** | $2-6 | $5-15 |
| **Hollywood** | $2-4 | $5-12 |
| **Residential** | Often free | N/A |

---

## Emergency Services

| Service | Number |
|---------|--------|
| **Emergency** | 911 |
| **LAPD Non-emergency** | 877-ASK-LAPD |
| **Fire (non-emergency)** | 311 |
| **Poison Control** | 1-800-222-1222 |
| **Mental Health Crisis** | 988 |
| **City Services** | 311 |

---

## Government Services

### City of LA
- 311 app for reporting issues
- lacity.org for services

### LA County
- lacounty.gov
- Social services, courts, etc.

### State of California
- DMV: dmv.ca.gov
- Covered California: coveredca.com
- EDD (unemployment): edd.ca.gov
