# Food Practical Guide — Los Angeles

Apps, grocery, dietary options, and practical food info.

---

## Restaurant Apps

| App | Best For |
|-----|----------|
| **Resy** | Hot restaurants, reservations |
| **OpenTable** | Mainstream reservations |
| **Yelp** | Reviews (actually useful in LA) |
| **The Infatuation** | Curated recommendations |
| **Eater LA** | News, lists, new openings |
| **Instagram** | Finding trendy spots |
| **Google Maps** | Quick searches, hours |

### Resy Tips
- Book 2-4 weeks ahead for popular spots
- Day-of cancellations happen — check at 9am
- "Notify Me" for hard-to-get spots

---

## Grocery Shopping

### By Type

| Need | Best Option |
|------|-------------|
| **Budget** | Aldi, Grocery Outlet, Food 4 Less |
| **Mid-range** | Ralphs, Vons, Trader Joe's |
| **Premium** | Whole Foods, Gelson's |
| **Wellness obsession** | Erewhon ($$$) |
| **Korean** | H Mart, Hannam Chain |
| **Japanese** | Mitsuwa, Nijiya |
| **Mexican** | Vallarta, Northgate |
| **Chinese** | 99 Ranch, Great Wall |
| **Middle Eastern** | Jon's, Elat Market |

### Trader Joe's Tips
- Best value for quality
- House brand everything
- Frozen section is excellent
- Wine selection is great
- Go early to avoid crowds

### Erewhon Reality
- $25 smoothies are real
- Groceries 2-3x normal prices
- Great prepared foods
- Go once for the experience
- Don't make it your regular store

---

## Delivery Options

| Service | Best For |
|---------|----------|
| **DoorDash** | Most restaurants |
| **Uber Eats** | Wide selection |
| **Postmates** | Similar to above |
| **Grubhub** | Some exclusives |
| **Instacart** | Groceries |
| **Amazon Fresh** | Groceries |

### Delivery Tips
- Fees add up (budget extra $5-10)
- Tip your driver (min $5)
- Check restaurant directly — sometimes same price + no fee
- Pickup saves money if driving anyway

---

## Dietary Options

### Vegan/Vegetarian Paradise

LA is one of the best cities for plant-based eating.

| Type | Where |
|------|-------|
| **Fine dining** | Crossroads Kitchen |
| **Mexican** | Gracias Madre |
| **Fast casual** | Cafe Gratitude |
| **Burgers** | Monty's Good Burger |
| **Thai** | Araya's Place |
| **Everything** | Sage Plant Based Bistro |

### Gluten-Free

- Most trendy restaurants have GF options
- Thai food is naturally often GF
- Mexican corn tortillas = GF
- Ask servers — LA is accommodating

### Halal

- Many Middle Eastern restaurants
- Glendale has many options
- Zankou Chicken (chain)
- Ask at Mediterranean spots

### Kosher

- Pico-Robertson area (main hub)
- Many options in Beverly Hills area
- Jeff's Gourmet, Milky Way

---

## Tipping Guide

| Situation | Tip |
|-----------|-----|
| **Sit-down restaurant** | 18-22% (20% standard) |
| **Fast casual (counter)** | $1-2 or 10-15% |
| **Coffee shop** | $1-2 |
| **Food truck** | $1-2 or 15% |
| **Delivery** | $5 minimum, 20% for large orders |
| **Takeout** | Optional, $1-2 appreciated |

---

## Reservations vs Walk-In

### Need Reservations
- Jon & Vinny's
- Bestia
- Republique (brunch)
- Providence
- Any hot new opening

### Walk-In Usually Fine
- Most taquerias
- Ramen shops
- Korean BBQ (except weekend nights)
- Food halls
- Counter-service places

### Pro Tips
- **Bar seating:** Often no reservation needed
- **Early dinner (5pm):** Easier to get in
- **Resy notifications:** Set alerts for hard spots
- **Walk-in backup:** Have a second choice ready

---

## Food Costs

### Budget Meals
| Type | Cost |
|------|------|
| **Taco truck (2-3 tacos)** | $6-12 |
| **Pho** | $12-15 |
| **Ramen** | $15-18 |
| **Fast casual** | $12-18 |
| **KBBQ (AYCE)** | $25-35 |

### Mid-Range Meals
| Type | Cost |
|------|------|
| **Casual sit-down** | $25-40/person |
| **Sushi (good)** | $40-60/person |
| **KBBQ (premium)** | $50-70/person |
| **Italian** | $40-60/person |

### Splurge Meals
| Type | Cost |
|------|------|
| **Omakase** | $150-400/person |
| **Fine dining** | $100-200/person |
| **Special occasion** | $150-300/person |

---

## Late Night Food

### After 11pm
| Type | Where | Hours |
|------|-------|-------|
| **Korean BBQ** | Koreatown | 2-4am |
| **Taco trucks** | Various | 2-3am |
| **Canter's Deli** | Fairfax | 24 hrs |
| **Fred 62** | Los Feliz | 2am |
| **Tommy's Burgers** | Various | 24 hrs |

### After 2am
- Koreatown has options until 3-4am
- Taco trucks wind down ~3am
- Canter's = always open
- Fast food chains (Jack in the Box, etc.)

---

## Food Safety

### Street Food
- If truck has long line, it's safe
- High turnover = fresh food
- Look for cleanliness
- Meat should be hot and fresh

### Fish
- LA sushi is high quality
- Avoid cheap all-you-can-eat sushi (quality concern)
- Omakase places source excellent fish

### Allergies
- Servers generally know ingredients
- "Contains" warnings common
- Cross-contamination harder to avoid at casual spots
- Thai/Asian = often has peanuts, fish sauce

---

## Farmers Markets

| Market | Day | Location |
|--------|-----|----------|
| **Santa Monica Wednesday** | Wed 8:30am-1pm | Arizona Ave |
| **Hollywood** | Sun 8am-1pm | Ivar & Selma |
| **Silver Lake** | Sat 8am-1pm | Sunset Junction |
| **Mar Vista** | Sun 9am-2pm | Venice & Grand View |
| **Original Farmers Market** | Daily | 3rd & Fairfax |

### Tips
- Bring cash (some vendors prefer)
- Go early for best selection
- Try samples
- Great for produce, not cheap
