# Entertainment Industry Guide — Los Angeles

## Overview

LA is the entertainment capital of the world. If you want to work in film, TV, music, gaming, or digital media — this is where you need to be.

**Reality check:** The industry is brutally competitive. Most people don't make it. But if you're serious, LA is non-negotiable.

---

## Industry Structure

### Major Studios

| Studio | Location | Owns |
|--------|----------|------|
| **Warner Bros Discovery** | Burbank | HBO, WB, Discovery |
| **Disney** | Burbank | ABC, ESPN, Marvel, Pixar, Star Wars |
| **Universal (NBCUniversal)** | Universal City | NBC, Peacock, DreamWorks |
| **Paramount** | Hollywood | CBS, Showtime |
| **Sony Pictures** | Culver City | Columbia, TriStar |
| **Netflix** | Hollywood (HQ Los Gatos) | Original content |
| **Amazon Studios** | Culver City | Prime Video |
| **Apple TV+** | Culver City | Originals |

### Streaming vs Traditional

- **Streaming:** More jobs, faster turnaround, less stability
- **Traditional studios:** More structure, union jobs, slower pace
- **Hybrid:** Everyone is both now

### Agencies (CAA, WME, etc.)

The major agencies package talent, negotiate deals, and control access:

| Agency | Location | Notes |
|--------|----------|-------|
| **CAA** | Century City | Biggest, most corporate |
| **WME (Endeavor)** | Beverly Hills | Sports + entertainment |
| **UTA** | Beverly Hills | Tech-forward |
| **ICM** | Century City | Merged with CAA |

**Reality:** Getting an agent requires having work. Getting work requires an agent. Classic catch-22.

---

## Entry-Level Paths

### The Mailroom/Assistant Route

Traditional path into agencies and studios:

1. **Agency mailroom** → Agent assistant → Junior agent
2. **Studio PA (Production Assistant)** → Coordinator → Manager
3. **Development assistant** → Reader → Creative executive

**Pay:** $40-60K starting, 60-80hr weeks, no overtime
**Why do it:** Access, learning, networking

### Writer's Room Path

1. **Writers' PA** → Writers' assistant → Staff writer
2. **Spec scripts** → Contests/fellowships → Staffing
3. **Showrunner assistant** → Get to know what works

**Fellowships:**
- Disney ABC Writing Fellowship
- Warner Bros Writers' Workshop
- NBC Writers on the Verge
- Sundance Labs

### Production Path

| Role | Entry | Progression |
|------|-------|-------------|
| **Set PA** | Anyone | → 2nd AD → 1st AD → UPM → Line Producer |
| **Office PA** | College grad | → Coordinator → Manager → Producer |
| **Camera** | Trainee → Loader | → 2nd AC → 1st AC → DP |
| **Art Dept** | PA/Runner | → Set dresser → Art director |

### Digital/Creator Route

New path for the social media era:

1. Build audience on YouTube, TikTok, Instagram
2. Get noticed by MCNs (Multi-Channel Networks)
3. Brand deals → production deals → traditional media

---

## Salary Ranges

### Entry Level

| Role | Annual | Notes |
|------|--------|-------|
| **Agency mailroom** | $40-50K | Plus overtime (often none) |
| **Studio assistant** | $45-60K | |
| **Set PA** | $200-300/day | Non-union |
| **Writers' PA** | $3,500-4,000/week | During production |

### Mid-Level

| Role | Annual |
|------|--------|
| **Junior agent** | $100-150K + bonuses |
| **Development exec** | $80-120K |
| **Line producer** | $4,000-8,000/week |
| **TV staff writer** | $5,000-8,000/week (WGA) |

### Senior Level

| Role | Range |
|------|-------|
| **Agent (senior)** | $300K-1M+ |
| **Showrunner** | $50K-200K/episode |
| **Studio exec (VP+)** | $200-500K+ |
| **A-list writer** | $500K-2M/feature |

### Union Minimums (WGA, SAG, DGA)

- **WGA Staff Writer:** ~$5,500/week minimum
- **SAG Day Rate:** ~$1,000/day minimum
- **DGA UPM:** ~$5,000/week minimum

---

## Where to Live

### By Job Type

| Job Type | Best Areas | Why |
|----------|------------|-----|
| **Agency/management** | Beverly Hills area, West LA | Close to offices |
| **Writers** | Anywhere (work from home/room) | Writers' room varies |
| **Studio jobs** | Burbank, Studio City | Near Warner/Disney |
| **Universal** | Studio City, Hollywood | Near Universal City |
| **Sony/Amazon** | Culver City area | Near studios |
| **Music industry** | Hollywood, West Hollywood | Studios, clubs |
| **Gaming** | Santa Monica, West LA | Riot, Activision |

### Commute Considerations

- **Early call times:** Production starts 5-7am, live close
- **Agency hours:** 9am-10pm, proximity matters
- **Writers:** More flexible, but still meetings

---

## Networking Reality

### How Jobs Actually Get Filled

1. **Who you know:** 60%+ of jobs come through connections
2. **Reputation:** You're only as good as your last project
3. **Cold applications:** Work occasionally, especially for assistant jobs
4. **Online (LinkedIn, etc.):** Growing, especially for corporate roles

### Essential Networking

| Event/Venue | For |
|-------------|-----|
| **Screenings/premieres** | Building relationships |
| **Industry parties** | Everyone |
| **Panels/talks** | Learning + networking |
| **Cafes/restaurants** | Random encounters (Soho House, Chateau) |
| **Gym (certain ones)** | Industry types work out |

### Memberships

| Organization | For |
|--------------|-----|
| **Academy (AMPAS)** | Voting, events (very selective) |
| **WGA** | Writers (requires credits) |
| **SAG-AFTRA** | Actors (requires jobs) |
| **DGA** | Directors (requires credits) |
| **PGA** | Producers (requires credits) |
| **Film Independent** | Indie filmmakers |

---

## The Unions

### WGA (Writers Guild)

- Protects writers
- Minimum pay, residuals, credits
- 2023 strike changed industry

### SAG-AFTRA (Actors)

- Protects performers
- Minimum rates, residuals
- Healthcare when working

### DGA (Directors Guild)

- Directors, ADs, UPMs
- Strong minimums
- Creative control protections

### IATSE (Crew)

- Camera, lighting, grips, etc.
- Strong on-set protections
- 12-hour minimum turnaround

### Getting In

Most unions require being hired for a union job first (employer must sign union contract).

---

## Gaming Industry

### Major Studios in LA

| Studio | Location | Known For |
|--------|----------|-----------|
| **Riot Games** | West LA | League of Legends, Valorant |
| **Activision Blizzard** | Santa Monica | Call of Duty, WoW |
| **EA (satellite)** | Playa Vista | Various |
| **Sony PlayStation** | Santa Monica | PlayStation studios |
| **Treyarch** | Santa Monica | Call of Duty |
| **Naughty Dog** | Santa Monica | Last of Us |

### Gaming Culture

- **Crunch:** Industry-wide problem, improving slowly
- **Pay:** Lower than tech, higher than traditional entertainment
- **Culture:** Passionate, younger, less hierarchical

---

## Music Industry

### Record Labels (Big Three)

| Label | LA Presence | Artists |
|-------|-------------|---------|
| **Universal Music Group** | Santa Monica | Taylor Swift, Drake, etc. |
| **Sony Music** | Santa Monica | Beyoncé, Harry Styles |
| **Warner Music Group** | DTLA | Ed Sheeran, Bruno Mars |

### Recording Studios

Major studios in Hollywood, North Hollywood, Santa Monica area.

### Live Music

- **The Forum** — Major concerts (Inglewood)
- **Hollywood Bowl** — Outdoor classical + pop
- **Greek Theatre** — Outdoor, intimate
- **Troubadour, Roxy, Whisky** — Smaller, legendary venues

---

## Survival Tips

### Financial Reality

- **Have savings:** 6+ months runway
- **Have side income:** Many assistants have second jobs
- **Don't overspend:** The trappings of LA can drain you

### Career Reality

- **It takes time:** Average time to "make it" = 7-10 years
- **Rejection is constant:** Develop thick skin
- **Relationships matter:** Be nice to everyone (today's PA is tomorrow's exec)
- **Stay in touch:** Check in, don't just reach out when you need something

### When to Give Up

A personal decision. Some questions:
- Are you still passionate after 5 years?
- Are you making progress (even small)?
- Do you have backup skills?
- Can you be happy doing something else?

---

## Summary for AI Agent

For entertainment industry questions:

1. **Entry path:** Assistant jobs → relationships → advancement
2. **Where to live:** Near your likely employers (Burbank for studios, WeHo for agencies)
3. **Timeline:** Plan for 5-10 years before "making it"
4. **Union jobs:** Protected, better pay, require getting hired first
5. **Networking:** Non-negotiable, how 60%+ jobs are filled
6. **Gaming:** Different culture, Santa Monica hub, still competitive
