# Cost of Living — Los Angeles (2025)

LA is expensive, but cheaper than SF or NYC. Costs vary dramatically by neighborhood and lifestyle.

---

## Quick Budget Summary

| Lifestyle | Monthly Budget | Notes |
|-----------|----------------|-------|
| **Survival mode** | $3,500-4,500 | Roommates, no car, minimal fun |
| **Comfortable single** | $5,000-6,500 | Own 1BR, car, normal social life |
| **Comfortable couple** | $7,000-9,000 | 1BR, one car, comfortable |
| **Family of 4** | $10,000-15,000 | 2-3BR, car(s), kids activities |
| **Tech salary lifestyle** | $8,000-12,000 | Nice place, dining, experiences |

---

## Housing

### Rent by Area (1BR Apartment)

| Area | Range | Median |
|------|-------|--------|
| **Santa Monica** | $2,800-4,000 | $3,300 |
| **Venice** | $2,500-3,500 | $2,900 |
| **Culver City** | $2,400-3,200 | $2,700 |
| **Playa Vista** | $2,600-3,400 | $3,000 |
| **West Hollywood** | $2,400-3,500 | $2,900 |
| **Hollywood** | $2,000-2,800 | $2,300 |
| **Silver Lake** | $2,300-3,300 | $2,700 |
| **Los Feliz** | $2,200-3,200 | $2,600 |
| **DTLA** | $2,200-3,500 | $2,700 |
| **Koreatown** | $1,600-2,200 | $1,900 |
| **Manhattan Beach** | $3,000-4,500 | $3,500 |
| **Hermosa Beach** | $2,400-3,200 | $2,800 |
| **Studio City** | $2,000-2,800 | $2,400 |
| **Sherman Oaks** | $1,900-2,600 | $2,200 |
| **Burbank** | $2,000-2,600 | $2,300 |
| **Pasadena** | $2,000-2,800 | $2,400 |
| **Highland Park** | $1,800-2,500 | $2,100 |

### By Apartment Size

| Type | Westside | Hollywood Area | Valley |
|------|----------|----------------|--------|
| **Studio** | $2,000-2,800 | $1,500-2,200 | $1,500-2,000 |
| **1BR** | $2,500-3,500 | $2,000-2,800 | $1,800-2,500 |
| **2BR** | $3,500-5,000 | $2,800-3,800 | $2,300-3,200 |

### Buying (Median Prices)

| Area | Condo | Single Family |
|------|-------|---------------|
| **Santa Monica** | $900K-1.5M | $2M-4M |
| **Culver City** | $700K-1M | $1.3M-2M |
| **DTLA** | $500K-800K | N/A (mostly condos) |
| **South Bay** | $800K-1.2M | $1.5M-3M |
| **Valley** | $500K-700K | $900K-1.5M |
| **Pasadena** | $500K-700K | $1M-2M |

### Additional Housing Costs

| Item | Monthly |
|------|---------|
| **Parking (if separate)** | $100-300 |
| **Utilities (gas/electric)** | $100-200 |
| **Internet** | $60-100 |
| **Renter's insurance** | $15-30 |

---

## Transportation

### Owning a Car (Budget This!)

| Item | Monthly | Notes |
|------|---------|-------|
| **Car payment** | $300-600 | Or buy used cash |
| **Insurance** | $150-300 | CA rates are HIGH |
| **Gas** | $150-300 | At $5/gal, depends on commute |
| **Parking (home)** | $0-300 | Often included or separate |
| **Parking (work/city)** | $100-300 | If commuting |
| **Maintenance** | $50-100 | Average monthly |
| **Registration/fees** | $20-30 | Annualized |
| **TOTAL** | **$400-700** | Minimum realistic |

### Insurance Reality

CA insurance rates are among highest in US.
- Clean driving record: $150-200/month
- Under 25 or tickets: $250-400/month
- Nice car: Higher

### Without a Car (If Possible)

| Item | Monthly |
|------|---------|
| **Metro pass** | $50-100 |
| **Uber/Lyft budget** | $200-400 |
| **TOTAL** | $250-500 |

Reality: Very few LA residents can live car-free. Budget for a car.

---

## Food

### Groceries

| Store Type | Monthly (Single) | Notes |
|------------|------------------|-------|
| **Budget (Aldi, Food 4 Less)** | $250-350 | |
| **Mid-range (Ralph's, Vons)** | $350-450 | |
| **Trader Joe's** | $300-400 | Great value |
| **Whole Foods** | $450-600 | |
| **Erewhon** | $600+ | LA's $25 smoothie store |

### Dining Out

| Type | Per Person |
|------|------------|
| **Taco stand** | $3-8 |
| **Fast casual** | $12-18 |
| **Casual restaurant** | $20-35 |
| **Nice dinner** | $60-100 |
| **Special occasion** | $100-200+ |

### Monthly Food Budgets

| Style | Monthly |
|-------|---------|
| **Cook mostly, rare dining** | $400-500 |
| **Mix of cooking/dining** | $600-900 |
| **Frequent dining out** | $1,000-1,500 |
| **Foodie lifestyle** | $1,500-2,500 |

---

## Utilities

| Utility | Monthly | Notes |
|---------|---------|-------|
| **Electric** | $80-150 | More with AC in Valley |
| **Gas** | $30-60 | Heating minimal |
| **Water (if separate)** | $30-50 | Often included |
| **Trash** | $0-40 | Often included |
| **Internet** | $60-100 | |
| **Cell phone** | $60-100 | |
| **TOTAL** | **$250-400** | |

**Note:** Valley = higher electric (AC). Beach = lower.

---

## Healthcare

### With Employer Insurance

| Item | Monthly |
|------|---------|
| **Premium (employee share)** | $100-500 |
| **Copays, prescriptions** | $50-150 |

### Without Insurance

Covered California marketplace: $300-600/month for decent coverage.

### Major Hospitals

- **Cedars-Sinai** — Top hospital, Beverly Hills area
- **UCLA Medical** — Major academic center, Westwood
- **USC Keck** — Research hospital, DTLA area
- **Providence St. John's** — Santa Monica

---

## Entertainment & Lifestyle

### Monthly Averages

| Category | Budget | Moderate | High |
|----------|--------|----------|------|
| **Gym** | $20-50 | $80-150 | $200-400 |
| **Entertainment** | $50-100 | $150-300 | $400+ |
| **Clothing** | $50-100 | $150-250 | $400+ |
| **Personal care** | $50 | $100-200 | $300+ |
| **Subscriptions** | $30-50 | $50-100 | $100-200 |

### LA-Specific

| Activity | Cost |
|----------|------|
| **Beach day** | FREE |
| **Hiking** | FREE (parking $5-15) |
| **Movie ticket** | $15-22 |
| **Concert tickets** | $50-200+ |
| **Disneyland (1 day)** | $150-200 |
| **Yoga class (drop-in)** | $25-35 |
| **Coffee shop** | $5-8 |

---

## Sample Monthly Budgets

### Single, $90K Salary (Tech)

| Category | Amount |
|----------|--------|
| Gross salary | $7,500 |
| Taxes (~30%) | -$2,250 |
| **Net** | $5,250 |
| Rent (1BR Valley) | $2,200 |
| Car total | $450 |
| Utilities | $300 |
| Food | $600 |
| Entertainment | $200 |
| Savings | $500 |
| **Remainder** | $0 |

### Couple, $200K Combined

| Category | Amount |
|----------|--------|
| Net income | $12,000 |
| Rent (1BR Santa Monica) | $3,300 |
| Car (one car) | $500 |
| Utilities | $350 |
| Food | $1,000 |
| Entertainment | $500 |
| Savings | $2,000 |
| **Remainder** | $4,350 |

### Family, $180K (One Income)

| Category | Amount |
|----------|--------|
| Net income | $11,000 |
| Rent (2BR Valley) | $2,800 |
| Cars (two) | $900 |
| Utilities | $400 |
| Food | $1,200 |
| Childcare | $2,000 |
| Kids activities | $300 |
| Savings | $1,000 |
| **Remainder** | $2,400 |

---

## Cost Comparison

| City | vs LA |
|------|-------|
| **San Francisco** | 15-25% higher |
| **New York** | 10-20% higher |
| **Seattle** | 5-10% lower |
| **Austin** | 20-30% lower |
| **Denver** | 15-25% lower |

---

## Tips for Saving Money

1. **Live in Valley** — 20-30% cheaper rent, more space
2. **Get roommates** — Save $800-1,500/month
3. **Buy a used car** — Avoid payments
4. **Cook at home** — LA dining adds up fast
5. **Free beaches/hikes** — Best entertainment is free
6. **Skip Erewhon** — Trader Joe's is plenty healthy
7. **South Bay commute** — Cheaper than Westside, great quality of life
