# Climate Guide — Los Angeles

LA's weather is one of its biggest draws, but it's more nuanced than "always sunny." Understanding microclimates is key to choosing where to live.

---

## The Basics

### Annual Overview

| Season | Months | Temperature | Notes |
|--------|--------|-------------|-------|
| **Spring** | Mar-May | 60-75°F | Pleasant, wildflowers |
| **Summer** | Jun-Aug | 70-90°F | Hottest, but varies by area |
| **Fall** | Sep-Nov | 70-85°F | Best weather, warmest |
| **Winter** | Dec-Feb | 50-70°F | "Rainy" season, mild |

**Annual rainfall:** ~15 inches (mostly Dec-Mar)
**Sunny days:** 280+ per year

---

## The Microclimate Reality

This is the most important thing about LA weather: **it varies DRAMATICALLY by location.**

### Temperature Zones

| Zone | Summer High | Winter High | Character |
|------|-------------|-------------|-----------|
| **Immediate coast** (Santa Monica, Venice) | 72-78°F | 60-68°F | Mild, foggy, rarely hot |
| **Coastal inland** (Culver City, West LA) | 75-85°F | 62-70°F | Moderate |
| **Central basin** (DTLA, Hollywood) | 80-95°F | 58-70°F | Heat island effect |
| **Valley** (Sherman Oaks, Burbank) | 90-105°F | 55-68°F | MUCH hotter |
| **High desert edge** (Pasadena, foothills) | 85-100°F | 55-70°F | Hot, dry |
| **South Bay** (Manhattan Beach) | 72-82°F | 60-68°F | Best beach weather |

**Key insight:** On a 100°F day in the Valley, it might be 75°F at the beach. Plan accordingly.

---

## June Gloom (May-July)

### What It Is

A marine layer (coastal fog) that blankets the immediate coast, especially mornings.

| Aspect | Reality |
|--------|---------|
| **When** | May-July, worst in June |
| **Where** | Within 5 miles of coast |
| **Time** | Morning until 11am-2pm |
| **Inland impact** | None — clear and hot |

### By Area

| Area | June Gloom? |
|------|-------------|
| **Santa Monica, Venice** | Heavy — overcast mornings |
| **Manhattan Beach, Hermosa** | Moderate — burns off by noon |
| **Malibu** | Heavy — whole days can be grey |
| **Hollywood, DTLA** | Minimal — sunny and warm |
| **Valley** | None — hot and clear |
| **Pasadena** | None — hot and dry |

**Implication for living:** If you hate grey weather, don't live right on the coast. Move a few miles inland (Culver City, Palms) for dramatically sunnier weather.

---

## Best Weather Times

### For Visiting

| Month | Weather | Notes |
|-------|---------|-------|
| **September** | ★★★★★ | Warmest, clearest, no June Gloom |
| **October** | ★★★★★ | Perfect temps, clear skies |
| **November** | ★★★★☆ | Still great, slight cooling |
| **April** | ★★★★☆ | Pre-June Gloom, pleasant |
| **March** | ★★★★☆ | Spring temps, green hills |
| **May** | ★★★☆☆ | June Gloom starting at coast |
| **June-July** | ★★★☆☆ | June Gloom (coast), hot (inland) |
| **August** | ★★★★☆ | Hottest month, but Gloom ending |
| **Dec-Feb** | ★★★☆☆ | Rainy season, but still mild |

### Worst Times

- **Early June at the beach** — Grey and cold feeling
- **Valley in August** — 105°F+ heat waves
- **Fire season (Oct-Dec)** — Smoke days, poor air quality

---

## Seasonal Specifics

### Rainy Season (December-March)

- ~15 inches annual rainfall, concentrated in winter
- "Storm" = one day of actual rain, then clear
- Angelenos drive terribly in rain
- Green hills only in winter/spring
- Flash flooding in canyons, burn areas

### Heat Waves (Typically Aug-Oct)

- Valley: 105-115°F
- Coastal: Can stay 80s
- "Santa Ana winds" = hot, dry, fire danger
- Air conditioning is essential in Valley
- Beach areas often survivable without AC

### Fire Season (June-December, Peak Sept-Nov)

- Affects hillside/canyon neighborhoods
- Smoke can blanket whole region for days
- Air quality alerts common
- Santa Ana winds = extreme fire danger
- Check fire maps before hiking

---

## Air Quality

### General

LA's air quality has improved dramatically since the 1980s but is still among worst in US.

| Season | Air Quality | Notes |
|--------|-------------|-------|
| **Summer** | Moderate-Poor | Heat = ozone issues |
| **Fire season** | Can be Hazardous | Smoke events |
| **Winter** | Good-Moderate | Rain clears air |
| **Spring** | Good | Best air quality |

### By Area

| Area | Typical Air Quality |
|------|---------------------|
| **Beach cities** | Best — ocean breeze |
| **Valley** | Worse — trapped basin |
| **DTLA** | Moderate — traffic |
| **Pasadena/foothills** | Worse — base of mountains traps smog |

### Tips

- **AirNow.gov** or app for daily AQI
- Exercise early morning (best air)
- N95 masks for bad smoke days
- Air purifier for apartments

---

## Choosing Where to Live (Climate Edition)

### Hate Heat?
→ Live near the coast (Santa Monica, South Bay)
→ Avoid the Valley

### Hate Grey Mornings?
→ Move just 3-5 miles inland (Culver City, Silver Lake)
→ Or accept June Gloom as trade-off for mild summers

### Want AC Optional?
→ Beach cities, or within 5 miles of coast
→ Valley: AC is MANDATORY

### Allergies?
→ Worst in spring (Feb-May)
→ Santa Ana winds kick up dust
→ Beach cities have cleaner air

---

## What to Pack (Visitors)

### Year-Round

| Item | Why |
|------|-----|
| **Layers** | Morning fog, warm afternoons |
| **Sunscreen** | UV is strong year-round |
| **Sunglasses** | Bright sun |
| **Light jacket** | Evenings cool (60s) |

### Summer (Jun-Aug)

| Coastal Visit | Inland Visit |
|--------------|--------------|
| Light layers | Light clothes |
| Light jacket (fog) | Hat, water |
| No heavy sunscreen | SPF 50+ |

### Winter (Dec-Feb)

- Rain jacket (just in case)
- Warm layer for evenings
- Still don't need heavy coat

---

## Summary for Living Decisions

| Priority | Best Area |
|----------|-----------|
| **Mildest year-round** | South Bay beaches |
| **Most sun (no Gloom)** | Valley, Pasadena (but HOT summer) |
| **Balance** | Culver City, Los Feliz, Silver Lake |
| **Best air quality** | Santa Monica, South Bay |
| **AC optional** | Within 5 miles of coast |
| **AC required** | Valley, Pasadena, anywhere inland |

The weather is genuinely great in LA — just pick your neighborhood based on which climate you actually want.
